/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Collections;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.AbstractSensitivity;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.access.AbstractClassificationResource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SensitivityResourceDefinition
extends SimpleResourceDefinition {
    public static PathElement PATH_ELEMENT = PathElement.pathElement((String)"classification");
    public static PathElement VAULT_ELEMENT = PathElement.pathElement((String)"constraint", (String)"vault-expression");
    public static SimpleAttributeDefinition DEFAULT_REQUIRES_ADDRESSABLE = SimpleAttributeDefinitionBuilder.create((String)"default-requires-addressable", (ModelType)ModelType.BOOLEAN, (boolean)false).setStorageRuntime().build();
    public static SimpleAttributeDefinition DEFAULT_REQUIRES_READ = SimpleAttributeDefinitionBuilder.create((String)"default-requires-read", (ModelType)ModelType.BOOLEAN, (boolean)false).setStorageRuntime().build();
    public static SimpleAttributeDefinition DEFAULT_REQUIRES_WRITE = SimpleAttributeDefinitionBuilder.create((String)"default-requires-write", (ModelType)ModelType.BOOLEAN, (boolean)false).setStorageRuntime().build();
    public static SimpleAttributeDefinition CONFIGURED_REQUIRES_ADDRESSABLE = SimpleAttributeDefinitionBuilder.create((String)"configured-requires-addressable", (ModelType)ModelType.BOOLEAN, (boolean)true).setXmlName(Attribute.REQUIRES_ADDRESSABLE.getLocalName()).build();
    public static SimpleAttributeDefinition CONFIGURED_REQUIRES_READ = SimpleAttributeDefinitionBuilder.create((String)"configured-requires-read", (ModelType)ModelType.BOOLEAN, (boolean)true).setXmlName(Attribute.REQUIRES_READ.getLocalName()).build();
    public static SimpleAttributeDefinition CONFIGURED_REQUIRES_WRITE = SimpleAttributeDefinitionBuilder.create((String)"configured-requires-write", (ModelType)ModelType.BOOLEAN, (boolean)true).setXmlName(Attribute.REQUIRES_WRITE.getLocalName()).build();

    private SensitivityResourceDefinition(PathElement pathElement, ResourceDescriptionResolver resolver) {
        super(pathElement, resolver);
    }

    static SensitivityResourceDefinition createSensitivityClassification() {
        return new SensitivityResourceDefinition(PATH_ELEMENT, DomainManagementResolver.getResolver("core.access-control.constraint.sensitivity-classification-config"));
    }

    static SensitivityResourceDefinition createVaultExpressionConfiguration() {
        return new SensitivityResourceDefinition(VAULT_ELEMENT, DomainManagementResolver.getResolver("core.access-control.constraint.vault-expression-sensitivity"));
    }

    static Resource.ResourceEntry createResource(AbstractSensitivity classification, String type, String name) {
        return SensitivityResourceDefinition.createResource(classification, PathElement.pathElement((String)type, (String)name));
    }

    static Resource.ResourceEntry createResource(AbstractSensitivity classification, PathElement pathElement) {
        return new SensitivityClassificationResource(pathElement, classification);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)DEFAULT_REQUIRES_ADDRESSABLE, (OperationStepHandler)SensitivityClassificationReadAttributeHandler.INSTANCE);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)DEFAULT_REQUIRES_READ, (OperationStepHandler)SensitivityClassificationReadAttributeHandler.INSTANCE);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)DEFAULT_REQUIRES_WRITE, (OperationStepHandler)SensitivityClassificationReadAttributeHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CONFIGURED_REQUIRES_ADDRESSABLE, (OperationStepHandler)SensitivityClassificationReadAttributeHandler.INSTANCE, (OperationStepHandler)SensitivityClassificationWriteAttributeHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CONFIGURED_REQUIRES_READ, (OperationStepHandler)SensitivityClassificationReadAttributeHandler.INSTANCE, (OperationStepHandler)SensitivityClassificationWriteAttributeHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CONFIGURED_REQUIRES_WRITE, (OperationStepHandler)SensitivityClassificationReadAttributeHandler.INSTANCE, (OperationStepHandler)SensitivityClassificationWriteAttributeHandler.INSTANCE);
    }

    private static class SensitivityClassificationResource
    extends AbstractClassificationResource {
        private final AbstractSensitivity classification;

        SensitivityClassificationResource(PathElement pathElement, AbstractSensitivity classification) {
            super(pathElement);
            this.classification = classification;
        }

        @Override
        public ModelNode getModel() {
            ModelNode model = new ModelNode();
            model.get(DEFAULT_REQUIRES_ADDRESSABLE.getName()).set(this.classification.isDefaultRequiresAccessPermission());
            model.get(DEFAULT_REQUIRES_READ.getName()).set(this.classification.isDefaultRequiresReadPermission());
            model.get(DEFAULT_REQUIRES_WRITE.getName()).set(this.classification.isDefaultRequiresWritePermission());
            model.get(CONFIGURED_REQUIRES_ADDRESSABLE.getName()).set(this.getBoolean(this.classification.getConfiguredRequiresAccessPermission()));
            model.get(CONFIGURED_REQUIRES_READ.getName()).set(this.getBoolean(this.classification.getConfiguredRequiresReadPermission()));
            model.get(CONFIGURED_REQUIRES_WRITE.getName()).set(this.getBoolean(this.classification.getConfiguredRequiresWritePermission()));
            return model;
        }

        private ModelNode getBoolean(Boolean booleanValue) {
            if (booleanValue == null) {
                return new ModelNode();
            }
            return new ModelNode(booleanValue.booleanValue());
        }

        public Set<String> getChildTypes() {
            return Collections.emptySet();
        }

        @Override
        Resource.ResourceEntry getChildEntry(String type, String name) {
            return null;
        }

        @Override
        public Set<String> getChildrenNames(String type) {
            return Collections.emptySet();
        }

        @Override
        public Set<Resource.ResourceEntry> getChildren(String childType) {
            return Collections.emptySet();
        }
    }

    private static class SensitivityClassificationWriteAttributeHandler
    implements OperationStepHandler {
        static final SensitivityClassificationWriteAttributeHandler INSTANCE = new SensitivityClassificationWriteAttributeHandler();

        private SensitivityClassificationWriteAttributeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String attribute = operation.require("name").asString();
            ModelNode value = operation.require("value");
            SensitivityClassificationResource resource = (SensitivityClassificationResource)context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            AbstractSensitivity classification = resource.classification;
            if (attribute.equals(CONFIGURED_REQUIRES_ADDRESSABLE.getName())) {
                classification.setConfiguredRequiresAccessPermission(this.readValue(context, value, (AttributeDefinition)CONFIGURED_REQUIRES_ADDRESSABLE));
            } else if (attribute.equals(CONFIGURED_REQUIRES_READ.getName())) {
                classification.setConfiguredRequiresReadPermission(this.readValue(context, value, (AttributeDefinition)CONFIGURED_REQUIRES_READ));
            } else if (attribute.equals(CONFIGURED_REQUIRES_WRITE.getName())) {
                classification.setConfiguredRequiresWritePermission(this.readValue(context, value, (AttributeDefinition)CONFIGURED_REQUIRES_WRITE));
            } else {
                throw new IllegalStateException();
            }
            context.stepCompleted();
        }

        private Boolean readValue(OperationContext context, ModelNode value, AttributeDefinition definition) throws OperationFailedException {
            if (value.isDefined()) {
                return definition.resolveValue(context, value).asBoolean();
            }
            return null;
        }
    }

    private static class SensitivityClassificationReadAttributeHandler
    implements OperationStepHandler {
        static final SensitivityClassificationReadAttributeHandler INSTANCE = new SensitivityClassificationReadAttributeHandler();

        private SensitivityClassificationReadAttributeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String attribute = operation.require("name").asString();
            SensitivityClassificationResource resource = (SensitivityClassificationResource)context.readResource(PathAddress.EMPTY_ADDRESS);
            AbstractSensitivity classification = resource.classification;
            Boolean result = null;
            if (attribute.equals(DEFAULT_REQUIRES_ADDRESSABLE.getName())) {
                result = classification.isDefaultRequiresAccessPermission();
            } else if (attribute.equals(DEFAULT_REQUIRES_READ.getName())) {
                result = classification.isDefaultRequiresReadPermission();
            } else if (attribute.equals(DEFAULT_REQUIRES_WRITE.getName())) {
                result = classification.isDefaultRequiresWritePermission();
            } else if (attribute.equals(CONFIGURED_REQUIRES_ADDRESSABLE.getName())) {
                result = classification.getConfiguredRequiresAccessPermission();
            } else if (attribute.equals(CONFIGURED_REQUIRES_READ.getName())) {
                result = classification.getConfiguredRequiresReadPermission();
            } else if (attribute.equals(CONFIGURED_REQUIRES_WRITE.getName())) {
                result = classification.getConfiguredRequiresWritePermission();
            } else {
                throw new IllegalStateException();
            }
            context.getResult();
            if (result != null) {
                context.getResult().set(result.booleanValue());
            }
            context.stepCompleted();
        }
    }
}

