/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import org.jboss.as.domain.management.security.FileKeystore;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class FileKeystoreService
implements Service<FileKeystore> {
    public static final String KEYSTORE_SUFFIX = "keystore";
    public static final String TRUSTSTORE_SUFFIX = "truststore";
    private volatile FileKeystore theKeyStore;
    private final String path;
    private final char[] keystorePassword;
    private final String alias;
    private final char[] keyPassword;
    private final InjectedValue<String> relativeTo = new InjectedValue();

    public FileKeystoreService(String path, char[] keystorePassword, String alias, char[] keyPassword) {
        this.path = path;
        this.keystorePassword = keystorePassword;
        this.alias = alias;
        this.keyPassword = keyPassword;
    }

    public void start(StartContext ctx) throws StartException {
        String relativeTo = (String)this.relativeTo.getOptionalValue();
        String file = relativeTo == null ? this.path : relativeTo + "/" + this.path;
        FileKeystore fileKeystore = new FileKeystore(file, this.keystorePassword, this.keyPassword, this.alias);
        fileKeystore.load();
        this.theKeyStore = fileKeystore;
    }

    public void stop(StopContext ctx) {
        this.theKeyStore = null;
    }

    public FileKeystore getValue() throws IllegalStateException, IllegalArgumentException {
        return this.theKeyStore;
    }

    public InjectedValue<String> getRelativeToInjector() {
        return this.relativeTo;
    }
}

