/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.net.ssl.SSLContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.jboss.as.core.security.RealmGroup;
import org.jboss.as.core.security.RealmRole;
import org.jboss.as.core.security.RealmSubjectUserInfo;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.core.security.SubjectUserInfo;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.AuthorizingCallbackHandler;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.DomainManagementLogger;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.SSLIdentity;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.as.domain.management.security.SubjectCallback;
import org.jboss.as.domain.management.security.SubjectSupplemental;
import org.jboss.as.domain.management.security.SubjectSupplementalService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedSetValue;
import org.jboss.msc.value.InjectedValue;

public class SecurityRealmService
implements Service<SecurityRealm>,
SecurityRealm {
    public static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "controller", "management", "security_realm"});
    private final InjectedValue<SubjectSupplementalService> subjectSupplemental = new InjectedValue();
    private final InjectedValue<SSLIdentity> sslIdentity = new InjectedValue();
    private final InjectedValue<CallbackHandlerFactory> secretCallbackFactory = new InjectedValue();
    private final InjectedSetValue<CallbackHandlerService> callbackHandlerServices = new InjectedSetValue();
    private final String name;
    private final boolean mapGroupsToRoles;
    private final Map<AuthMechanism, CallbackHandlerService> registeredServices = new HashMap<AuthMechanism, CallbackHandlerService>();

    public SecurityRealmService(String name, boolean mapGroupsToRoles) {
        this.name = name;
        this.mapGroupsToRoles = mapGroupsToRoles;
    }

    public void start(StartContext context) throws StartException {
        DomainManagementLogger.ROOT_LOGGER.debugf("Starting '%s' Security Realm Service", this.name);
        for (CallbackHandlerService current : this.callbackHandlerServices.getValue()) {
            AuthMechanism mechanism = current.getPreferredMechanism();
            if (this.registeredServices.containsKey((Object)mechanism)) {
                this.registeredServices.clear();
                throw DomainManagementMessages.MESSAGES.multipleCallbackHandlerForMechanism(mechanism.name());
            }
            this.registeredServices.put(mechanism, current);
        }
    }

    public void stop(StopContext context) {
        DomainManagementLogger.ROOT_LOGGER.debugf("Stopping '%s' Security Realm Service", this.name);
        this.registeredServices.clear();
    }

    public SecurityRealmService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<AuthMechanism> getSupportedAuthenticationMechanisms() {
        TreeSet<AuthMechanism> response = new TreeSet<AuthMechanism>();
        response.addAll(this.registeredServices.keySet());
        return response;
    }

    @Override
    public Map<String, String> getMechanismConfig(AuthMechanism mechanism) {
        CallbackHandlerService service = this.getCallbackHandlerService(mechanism);
        return service.getConfigurationOptions();
    }

    @Override
    public boolean isReady() {
        for (CallbackHandlerService current : this.registeredServices.values()) {
            if (current.isReady()) continue;
            return false;
        }
        return true;
    }

    @Override
    public AuthorizingCallbackHandler getAuthorizingCallbackHandler(AuthMechanism mechanism) {
        final CallbackHandlerService handlerService = this.getCallbackHandlerService(mechanism);
        final HashMap sharedState = new HashMap();
        return new AuthorizingCallbackHandler(){
            CallbackHandler handler;
            Map<String, String> options;
            final boolean subjectCallbackSupported;
            Subject subject;
            {
                this.handler = handlerService.getCallbackHandler(sharedState);
                this.options = handlerService.getConfigurationOptions();
                this.subjectCallbackSupported = this.options.containsKey("org.jboss.as.domain.management.subject_callback_supported") ? Boolean.parseBoolean(this.options.get("org.jboss.as.domain.management.subject_callback_supported")) : false;
            }

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                if (this.subjectCallbackSupported && this.notAuthorizeCallback(callbacks)) {
                    Callback[] newCallbacks = new Callback[callbacks.length + 1];
                    System.arraycopy(callbacks, 0, newCallbacks, 0, callbacks.length);
                    SubjectCallback subjectCallBack = new SubjectCallback();
                    newCallbacks[newCallbacks.length - 1] = subjectCallBack;
                    this.handler.handle(newCallbacks);
                    this.subject = subjectCallBack.getSubject();
                } else {
                    this.handler.handle(callbacks);
                }
            }

            private boolean notAuthorizeCallback(Callback[] callbacks) {
                return !(callbacks.length == 1 && callbacks[0] instanceof AuthorizeCallback);
            }

            @Override
            public SubjectUserInfo createSubjectUserInfo(Collection<Principal> userPrincipals) throws IOException {
                Subject subject = this.subject == null ? new Subject() : this.subject;
                Set<Principal> allPrincipals = subject.getPrincipals();
                for (Principal userPrincipal : userPrincipals) {
                    allPrincipals.add(userPrincipal);
                    allPrincipals.add((Principal)new RealmUser(SecurityRealmService.this.getName(), userPrincipal.getName()));
                }
                SubjectSupplementalService subjectSupplementalService = (SubjectSupplementalService)SecurityRealmService.this.subjectSupplemental.getOptionalValue();
                if (subjectSupplementalService != null) {
                    SubjectSupplemental subjectSupplemental = subjectSupplementalService.getSubjectSupplemental(sharedState);
                    subjectSupplemental.supplementSubject(subject);
                }
                if (SecurityRealmService.this.mapGroupsToRoles) {
                    Set<RealmGroup> groups = subject.getPrincipals(RealmGroup.class);
                    HashSet<RealmRole> roles = new HashSet<RealmRole>(groups.size());
                    for (RealmGroup current : groups) {
                        roles.add(new RealmRole(current.getName()));
                    }
                    subject.getPrincipals().addAll(roles);
                }
                return new RealmSubjectUserInfo(subject);
            }
        };
    }

    private CallbackHandlerService getCallbackHandlerService(AuthMechanism mechanism) {
        if (this.registeredServices.containsKey((Object)mechanism)) {
            return this.registeredServices.get((Object)mechanism);
        }
        for (CallbackHandlerService current : this.registeredServices.values()) {
            if (!current.getSupplementaryMechanisms().contains((Object)mechanism)) continue;
            return current;
        }
        throw DomainManagementMessages.MESSAGES.noCallbackHandlerForMechanism(mechanism.toString(), this.name);
    }

    public InjectedValue<SubjectSupplementalService> getSubjectSupplementalInjector() {
        return this.subjectSupplemental;
    }

    public InjectedValue<SSLIdentity> getSSLIdentityInjector() {
        return this.sslIdentity;
    }

    public InjectedValue<CallbackHandlerFactory> getSecretCallbackFactory() {
        return this.secretCallbackFactory;
    }

    public InjectedSetValue<CallbackHandlerService> getCallbackHandlerService() {
        return this.callbackHandlerServices;
    }

    @Override
    public SSLContext getSSLContext() {
        SSLIdentity service = (SSLIdentity)this.sslIdentity.getOptionalValue();
        if (service != null) {
            return service.getFullContext();
        }
        return null;
    }

    @Override
    public CallbackHandlerFactory getSecretCallbackHandlerFactory() {
        return (CallbackHandlerFactory)this.secretCallbackFactory.getOptionalValue();
    }
}

