/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wst11.messaging.engines;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices.SoapFaultType;
import com.arjuna.webservices.logging.WSTLogger;
import com.arjuna.webservices.util.TransportTimer;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsarj.ArjunaContext;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsat.AtomicTransactionConstants;
import com.arjuna.webservices11.wsat.ParticipantInboundEvents;
import com.arjuna.webservices11.wsat.State;
import com.arjuna.webservices11.wsat.client.CoordinatorClient;
import com.arjuna.webservices11.wsat.processors.ParticipantProcessor;
import com.arjuna.webservices11.wscoor.CoordinationConstants;
import com.arjuna.wsc11.messaging.MessageId;
import com.arjuna.wst.Aborted;
import com.arjuna.wst.Durable2PCParticipant;
import com.arjuna.wst.Participant;
import com.arjuna.wst.Prepared;
import com.arjuna.wst.ReadOnly;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.Vote;
import java.util.TimerTask;
import javax.xml.namespace.QName;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.jboss.jbossts.xts.recovery.participant.at.XTSATRecoveryManager;
import org.jboss.jbossts.xts11.recovery.participant.at.ATParticipantRecoveryRecord;
import org.jboss.ws.api.addressing.MAP;
import org.oasis_open.docs.ws_tx.wsat._2006._06.Notification;

public class ParticipantEngine
implements ParticipantInboundEvents {
    private final Participant participant;
    private final String id;
    private final W3CEndpointReference coordinator;
    private State state;
    private TimerTask timerTask;
    private long resendPeriod;
    private long initialResendPeriod;
    private long maxResendPeriod;
    private boolean recovered;
    private boolean persisted;

    public ParticipantEngine(Participant participant, String id, W3CEndpointReference coordinator) {
        this(participant, id, State.STATE_ACTIVE, coordinator, false);
    }

    public ParticipantEngine(Participant participant, String id, State state, W3CEndpointReference coordinator, boolean recovered) {
        this.participant = participant;
        this.id = id;
        this.state = state;
        this.coordinator = coordinator;
        this.recovered = recovered;
        this.persisted = recovered;
        this.initialResendPeriod = TransportTimer.getTransportPeriod();
        this.maxResendPeriod = TransportTimer.getMaximumTransportPeriod();
        this.resendPeriod = this.initialResendPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Notification commit, MAP map, ArjunaContext arjunaContext) {
        State current;
        ParticipantEngine participantEngine = this;
        synchronized (participantEngine) {
            current = this.state;
            if (current == State.STATE_PREPARED_SUCCESS) {
                this.state = State.STATE_COMMITTING;
                if (this.timerTask != null) {
                    this.timerTask.cancel();
                }
            } else if (current == State.STATE_ACTIVE || current == State.STATE_PREPARING) {
                this.state = State.STATE_ABORTING;
            }
        }
        if (current == State.STATE_PREPARED_SUCCESS) {
            this.executeCommit();
        } else if (current == null) {
            this.sendCommitted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(Notification prepare, MAP map, ArjunaContext arjunaContext) {
        State current;
        ParticipantEngine participantEngine = this;
        synchronized (participantEngine) {
            current = this.state;
            if (current == State.STATE_ACTIVE) {
                this.state = State.STATE_PREPARING;
            }
        }
        if (current == State.STATE_ACTIVE) {
            this.executePrepare();
        } else if (current == State.STATE_PREPARED_SUCCESS) {
            this.sendPrepared();
        } else if (current == State.STATE_ABORTING || current == null) {
            this.sendAborted();
            this.forget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Notification rollback, MAP map, ArjunaContext arjunaContext) {
        State current;
        ParticipantEngine participantEngine = this;
        synchronized (participantEngine) {
            current = this.state;
            if (current == State.STATE_ACTIVE || current == State.STATE_PREPARING || current == State.STATE_PREPARED_SUCCESS) {
                this.state = State.STATE_ABORTING;
            }
        }
        if (current == State.STATE_ACTIVE || current == State.STATE_PREPARING || current == State.STATE_PREPARED_SUCCESS) {
            if (!this.executeRollback()) {
                participantEngine = this;
                synchronized (participantEngine) {
                    this.state = current;
                }
                return;
            }
            if (this.persisted && this.participant instanceof Durable2PCParticipant && !XTSATRecoveryManager.getRecoveryManager().deleteParticipantRecoveryRecord(this.id)) {
                WSTLogger.i18NLogger.warn_wst11_messaging_engines_ParticipantEngine_rollback_1(this.id);
            }
            this.sendAborted();
            this.forget();
        } else if (current != State.STATE_ABORTING) {
            this.sendAborted();
        }
    }

    public void earlyRollback() {
        this.rollbackDecision();
    }

    public void earlyReadonly() {
        this.readOnlyDecision();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recovery() {
        State current;
        ParticipantEngine participantEngine = this;
        synchronized (participantEngine) {
            current = this.state;
        }
        if (current == State.STATE_PREPARED_SUCCESS) {
            this.sendPrepared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void soapFault(SoapFault soapFault, MAP map, ArjunaContext arjunaContext) {
        QName subcode;
        QName subCode;
        SoapFaultType soapFaultType;
        if (WSTLogger.logger.isTraceEnabled()) {
            InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
            soapFaultType = soapFault.getSoapFaultType();
            subCode = soapFault.getSubcode();
            WSTLogger.logger.tracev("Unexpected SOAP fault for participant {0}: {1} {2}", new Object[]{instanceIdentifier, soapFaultType, subCode});
        }
        if (CoordinationConstants.WSCOOR_ERROR_CODE_INVALID_STATE_QNAME.equals(subcode = soapFault.getSubcode()) || AtomicTransactionConstants.WSAT_ERROR_CODE_INCONSISTENT_INTERNAL_STATE_QNAME.equals(subcode) || AtomicTransactionConstants.WSAT_ERROR_CODE_UNKNOWN_TRANSACTION_QNAME.equals(subcode)) {
            State current;
            soapFaultType = soapFault.getSoapFaultType();
            subCode = soapFault.getSubcode();
            WSTLogger.i18NLogger.error_wst11_messaging_engines_ParticipantEngine_soapFault_2(this.id, soapFaultType.toString(), subCode);
            ParticipantEngine participantEngine = this;
            synchronized (participantEngine) {
                current = this.state;
                this.state = null;
            }
            if (current == State.STATE_PREPARED_SUCCESS && AtomicTransactionConstants.WSAT_ERROR_CODE_UNKNOWN_TRANSACTION_QNAME.equals(subcode)) {
                this.executeRollback();
            }
            if (this.persisted && this.participant instanceof Durable2PCParticipant) {
                Durable2PCParticipant durableParticipant = (Durable2PCParticipant)this.participant;
                if (!XTSATRecoveryManager.getRecoveryManager().deleteParticipantRecoveryRecord(this.id)) {
                    WSTLogger.i18NLogger.error_wst11_messaging_engines_ParticipantEngine_soapFault_3(this.id);
                }
            }
            this.forget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitDecision() {
        Object durableParticipant;
        State current;
        boolean rollbackRequired = false;
        boolean deleteRequired = false;
        ParticipantEngine participantEngine = this;
        synchronized (participantEngine) {
            current = this.state;
        }
        if (current == State.STATE_PREPARING) {
            if (this.participant instanceof Durable2PCParticipant) {
                durableParticipant = (Durable2PCParticipant)this.participant;
                ATParticipantRecoveryRecord recoveryRecord = new ATParticipantRecoveryRecord(this.id, (Durable2PCParticipant)durableParticipant, this.coordinator);
                if (!XTSATRecoveryManager.getRecoveryManager().writeParticipantRecoveryRecord(recoveryRecord)) {
                    rollbackRequired = true;
                }
            }
            durableParticipant = this;
            synchronized (durableParticipant) {
                current = this.state;
                if (current == State.STATE_PREPARING) {
                    if (rollbackRequired) {
                        this.state = State.STATE_ABORTING;
                    } else {
                        this.state = State.STATE_PREPARED_SUCCESS;
                        this.persisted = true;
                    }
                } else if (!rollbackRequired) {
                    deleteRequired = true;
                }
            }
            if (rollbackRequired) {
                this.executeRollback();
                this.sendAborted();
                this.forget();
            } else if (deleteRequired) {
                if (!XTSATRecoveryManager.getRecoveryManager().deleteParticipantRecoveryRecord(this.id)) {
                    WSTLogger.i18NLogger.warn_wst11_messaging_engines_ParticipantEngine_commitDecision_2(this.id);
                }
            } else {
                this.sendPrepared();
            }
        } else if (current == State.STATE_COMMITTING) {
            if (this.persisted && this.participant instanceof Durable2PCParticipant) {
                durableParticipant = (Durable2PCParticipant)this.participant;
                if (!XTSATRecoveryManager.getRecoveryManager().deleteParticipantRecoveryRecord(this.id)) {
                    WSTLogger.i18NLogger.warn_wst11_messaging_engines_ParticipantEngine_commitDecision_3(this.id);
                    ParticipantEngine participantEngine2 = this;
                    synchronized (participantEngine2) {
                        this.state = State.STATE_PREPARED_SUCCESS;
                    }
                    return;
                }
            }
            this.sendCommitted();
            this.forget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readOnlyDecision() {
        State current;
        ParticipantEngine participantEngine = this;
        synchronized (participantEngine) {
            current = this.state;
            if (current == State.STATE_ACTIVE || current == State.STATE_PREPARING) {
                this.state = null;
            }
        }
        if (current == State.STATE_ACTIVE || current == State.STATE_PREPARING) {
            this.sendReadOnly();
            this.forget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackDecision() {
        State current;
        ParticipantEngine participantEngine = this;
        synchronized (participantEngine) {
            current = this.state;
            if (current == State.STATE_PREPARING || current == State.STATE_ACTIVE) {
                this.state = State.STATE_ABORTING;
            }
        }
        if (current == State.STATE_PREPARING || current == State.STATE_ACTIVE) {
            this.sendAborted();
            this.forget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commsTimeout(TimerTask caller) {
        State current;
        ParticipantEngine participantEngine = this;
        synchronized (participantEngine) {
            if (!this.timerTask.equals(caller)) {
                return;
            }
            if (this.resendPeriod < this.maxResendPeriod) {
                this.resendPeriod = this.resendPeriod * 14L / 10L;
                if (this.resendPeriod > this.maxResendPeriod) {
                    this.resendPeriod = this.maxResendPeriod;
                }
            }
            current = this.state;
        }
        if (current == State.STATE_PREPARED_SUCCESS) {
            this.sendPrepared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommit() {
        block6: {
            try {
                this.participant.commit();
                this.commitDecision();
            }
            catch (Throwable th) {
                ParticipantEngine participantEngine = this;
                synchronized (participantEngine) {
                    if (this.state == State.STATE_COMMITTING) {
                        this.state = State.STATE_PREPARED_SUCCESS;
                    }
                }
                if (!WSTLogger.logger.isTraceEnabled()) break block6;
                WSTLogger.logger.tracev("Unexpected exception from participant commit", (Object)th);
            }
        }
    }

    private boolean executeRollback() {
        block3: {
            try {
                this.participant.rollback();
            }
            catch (SystemException se) {
                return false;
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block3;
                WSTLogger.logger.tracev("Unexpected exception from participant rollback", (Object)th);
            }
        }
        return true;
    }

    private void executePrepare() {
        Vote vote;
        try {
            vote = this.participant.prepare();
        }
        catch (SystemException se) {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev("Unexpected exception from participant prepare", (Object)se);
            }
            return;
        }
        catch (Throwable th) {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev("Unexpected exception from participant prepare", (Object)th);
            }
            this.rollbackDecision();
            return;
        }
        if (vote instanceof Prepared) {
            this.commitDecision();
        } else if (vote instanceof ReadOnly) {
            this.readOnlyDecision();
        } else if (vote instanceof Aborted) {
            this.rollbackDecision();
        } else {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev("Unexpected result from participant prepare: {0}", new Object[]{vote == null ? "null" : vote.getClass().getName()});
            }
            this.rollbackDecision();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forget() {
        ParticipantEngine participantEngine = this;
        synchronized (participantEngine) {
            this.state = null;
        }
        ParticipantProcessor.getProcessor().deactivateParticipant(this);
    }

    private void sendCommitted() {
        block2: {
            MAP responseAddressingContext = this.createContext();
            InstanceIdentifier instanceIdentifier = new InstanceIdentifier(this.id);
            try {
                CoordinatorClient.getClient().sendCommitted(this.coordinator, responseAddressingContext, instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Committed", (Object)th);
            }
        }
    }

    private void sendPrepared() {
        this.sendPrepared(false);
    }

    private void sendPrepared(boolean timedOut) {
        block2: {
            MAP responseAddressingContext = this.createContext();
            InstanceIdentifier instanceIdentifier = new InstanceIdentifier(this.id);
            try {
                CoordinatorClient.getClient().sendPrepared(this.coordinator, responseAddressingContext, instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Prepared", (Object)th);
            }
        }
        this.updateResendPeriod(timedOut);
        this.initiateTimer();
    }

    private synchronized void updateResendPeriod(boolean timedOut) {
        if (timedOut) {
            if (this.resendPeriod < this.maxResendPeriod) {
                long newPeriod = this.resendPeriod * 14L / 10L;
                if (newPeriod > this.maxResendPeriod) {
                    newPeriod = this.maxResendPeriod;
                }
                this.resendPeriod = newPeriod;
            }
        } else if (this.resendPeriod > this.initialResendPeriod) {
            this.resendPeriod = this.initialResendPeriod;
        }
    }

    private void sendAborted() {
        block2: {
            MAP responseAddressingContext = this.createContext();
            InstanceIdentifier instanceIdentifier = new InstanceIdentifier(this.id);
            try {
                CoordinatorClient.getClient().sendAborted(this.coordinator, responseAddressingContext, instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Aborted", (Object)th);
            }
        }
    }

    private void sendReadOnly() {
        block2: {
            MAP responseAddressingContext = this.createContext();
            InstanceIdentifier instanceIdentifier = new InstanceIdentifier(this.id);
            try {
                CoordinatorClient.getClient().sendReadOnly(this.coordinator, responseAddressingContext, instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending ReadOnly", (Object)th);
            }
        }
    }

    private synchronized void initiateTimer() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        if (this.state == State.STATE_PREPARED_SUCCESS) {
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    ParticipantEngine.this.commsTimeout(this);
                }
            };
            TransportTimer.getTimer().schedule(this.timerTask, this.resendPeriod);
        } else {
            this.timerTask = null;
        }
    }

    private MAP createContext() {
        String messageId = MessageId.getMessageId();
        return AddressingHelper.createNotificationContext(messageId);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public W3CEndpointReference getCoordinator() {
        return this.coordinator;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public boolean isRecovered() {
        return this.recovered;
    }
}

