/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.UndertowLogger;
import io.undertow.client.HttpClientConnection;
import io.undertow.client.HttpClientImpl;
import io.undertow.client.HttpClientRequest;
import io.undertow.client.HttpClientRequestImpl;
import io.undertow.client.HttpRequestQueueStrategy;
import io.undertow.client.HttpResponseParser;
import io.undertow.client.PendingHttpRequest;
import io.undertow.client.ResponseParseState;
import io.undertow.client.UndertowClientMessages;
import io.undertow.util.HttpString;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.AssembledConnectedStreamChannel;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.PushBackStreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

class HttpClientConnectionImpl
extends HttpClientConnection
implements ConnectedChannel {
    private final OptionMap options;
    private final ConnectedStreamChannel underlyingChannel;
    private final PushBackStreamChannel readChannel;
    private final Pool<ByteBuffer> bufferPool;
    private final HttpRequestQueueStrategy queuingStrategy;
    private final ClientReadListener readListener = new ClientReadListener();
    private final ChannelListener.Setter<ConnectedChannel> closeSetter;
    private static final int UPGRADED = 0x20000000;
    private static final int CLOSE_REQ = 0x40000000;
    private static final int CLOSED = Integer.MIN_VALUE;
    private volatile int state;
    private static final AtomicIntegerFieldUpdater<HttpClientConnectionImpl> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(HttpClientConnectionImpl.class, "state");
    private volatile boolean pipelining;

    HttpClientConnectionImpl(ConnectedStreamChannel underlyingChannel, PushBackStreamChannel readChannel, OptionMap options, final HttpClientImpl client) {
        super(client);
        this.options = options;
        this.underlyingChannel = underlyingChannel;
        this.readChannel = readChannel;
        this.bufferPool = client.getBufferPool();
        this.queuingStrategy = HttpRequestQueueStrategy.create(this, options);
        this.closeSetter = ChannelListeners.getDelegatingSetter((ChannelListener.Setter)underlyingChannel.getCloseSetter(), (Channel)((Object)this));
        this.pipelining = this.queuingStrategy.supportsPipelining();
        this.getCloseSetter().set((ChannelListener)new ChannelListener<ConnectedChannel>(){

            public void handleEvent(ConnectedChannel channel) {
                IoUtils.safeClose((Closeable)HttpClientConnectionImpl.this);
                client.connectionClosed(HttpClientConnectionImpl.this);
            }
        });
    }

    ConnectedStreamChannel getChannel() {
        return this.underlyingChannel;
    }

    @Override
    public Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    public SocketAddress getPeerAddress() {
        return this.underlyingChannel.getPeerAddress();
    }

    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return (A)this.underlyingChannel.getPeerAddress(type);
    }

    public ChannelListener.Setter<? extends ConnectedChannel> getCloseSetter() {
        return this.closeSetter;
    }

    public SocketAddress getLocalAddress() {
        return this.underlyingChannel.getLocalAddress();
    }

    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return (A)this.underlyingChannel.getLocalAddress(type);
    }

    public XnioWorker getWorker() {
        return this.underlyingChannel.getWorker();
    }

    public XnioIoThread getIoThread() {
        return this.underlyingChannel.getIoThread();
    }

    public boolean isOpen() {
        return this.underlyingChannel.isOpen();
    }

    public boolean supportsOption(Option<?> option) {
        return this.underlyingChannel.supportsOption(option);
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return (T)this.underlyingChannel.getOption(option);
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return (T)this.underlyingChannel.setOption(option, value);
    }

    @Override
    OptionMap getOptions() {
        return this.options;
    }

    @Override
    public HttpClientRequest createRequest(HttpString method, URI target) {
        return this.internalCreateRequest(method, target, this.pipelining);
    }

    @Override
    public ConnectedStreamChannel performUpgrade() throws IOException {
        int newState;
        int oldState;
        do {
            if (!Bits.allAreSet((int)(oldState = this.state), (int)-536870912)) continue;
            throw new IOException(UndertowClientMessages.MESSAGES.connectionClosed());
        } while (!stateUpdater.compareAndSet(this, oldState, newState = oldState | 0x20000000));
        return new AssembledConnectedStreamChannel((StreamSourceChannel)this.readChannel, (StreamSinkChannel)this.underlyingChannel);
    }

    protected HttpClientRequest internalCreateRequest(HttpString method, URI target, boolean pipelining) {
        if (Bits.allAreSet((int)this.state, (int)0x60000000)) {
            return null;
        }
        return new HttpClientRequestImpl(this, (StreamSinkChannel)this.underlyingChannel, method, target, pipelining);
    }

    @Override
    public void close() throws IOException {
        int newState;
        int oldState;
        do {
            if (!Bits.allAreSet((int)(oldState = this.state), (int)Integer.MIN_VALUE)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldState, newState = oldState | Integer.MIN_VALUE | 0x40000000));
        this.underlyingChannel.close();
    }

    void enqueueRequest(PendingHttpRequest request) {
        int newState;
        int oldState;
        do {
            if (!Bits.anyAreSet((int)(oldState = this.state), (int)-1073741824)) continue;
            request.setFailed(new IOException(UndertowClientMessages.MESSAGES.connectionClosed()));
            return;
        } while (!stateUpdater.compareAndSet(this, oldState, newState = oldState + 1));
        UndertowLogger.CLIENT_LOGGER.tracef("adding new request %s %s", request, request.getRequest());
        this.queuingStrategy.addNewRequest(request);
    }

    void sendingCompleted(PendingHttpRequest request) {
        this.queuingStrategy.requestSent(request);
        UndertowLogger.CLIENT_LOGGER.tracef("request fully sent %s", request);
        int currentState = this.state;
        if (Bits.allAreSet((int)currentState, (int)0x40000000)) {
            try {
                this.underlyingChannel.shutdownWrites();
            }
            catch (IOException e) {
                UndertowLogger.CLIENT_LOGGER.debugf(e, "failed to shutdown writes", new Object[0]);
            }
        }
    }

    void requestCompleted(PendingHttpRequest request) {
        int currentState = stateUpdater.getAndDecrement(this);
        this.queuingStrategy.requestCompleted(request);
        UndertowLogger.CLIENT_LOGGER.tracef("request completed %s", request);
        if (Bits.allAreSet((int)currentState, (int)0x40000000)) {
            try {
                this.close();
            }
            catch (IOException e) {
                UndertowLogger.CLIENT_LOGGER.debugf(e, "failed to close channel", new Object[0]);
            }
        }
    }

    void requestConnectionClose() throws IOException {
        int newState;
        int oldState;
        do {
            if (!Bits.anyAreSet((int)(oldState = this.state), (int)-1073741824)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldState, newState = oldState | 0x40000000));
        UndertowLogger.CLIENT_LOGGER.tracef("request to close the connection", new Object[0]);
        if (newState == 0x40000000) {
            this.close();
        }
    }

    void doSendRequest(final PendingHttpRequest request, boolean fromCallback) {
        int currentState = this.state;
        if (Bits.anyAreSet((int)currentState, (int)-1073741824)) {
            request.setCancelled();
            this.sendingCompleted(request);
            return;
        }
        UndertowLogger.CLIENT_LOGGER.tracef("start sending request %s", request);
        if (fromCallback) {
            this.underlyingChannel.getWriteSetter().set((ChannelListener)new ChannelListener<StreamSinkChannel>(){

                public void handleEvent(StreamSinkChannel channel) {
                    request.startSendingRequest();
                }
            });
            this.underlyingChannel.resumeWrites();
        } else {
            request.startSendingRequest();
        }
    }

    void doReadResponse(PendingHttpRequest request) {
        assert (this.readListener.activeRequest == null);
        UndertowLogger.CLIENT_LOGGER.tracef("start reading response for %s", request);
        this.readListener.activeRequest = request;
        this.readChannel.getReadSetter().set((ChannelListener)this.readListener);
        this.readChannel.resumeReads();
    }

    class ClientReadListener
    implements ChannelListener<PushBackStreamChannel> {
        volatile PendingHttpRequest activeRequest;

        ClientReadListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(PushBackStreamChannel channel) {
            PendingHttpRequest builder = this.activeRequest;
            Pooled pooled = HttpClientConnectionImpl.this.bufferPool.allocate();
            ByteBuffer buffer = (ByteBuffer)pooled.getResource();
            boolean free = true;
            try {
                ResponseParseState state = builder.getParseState();
                do {
                    int res;
                    buffer.clear();
                    try {
                        res = channel.read(buffer);
                    }
                    catch (IOException e) {
                        if (UndertowLogger.CLIENT_LOGGER.isDebugEnabled()) {
                            UndertowLogger.CLIENT_LOGGER.debugf(e, "Connection closed with IOException", new Object[0]);
                        }
                        IoUtils.safeClose((Closeable)channel);
                        if (free) {
                            pooled.free();
                        }
                        return;
                    }
                    if (res == 0) {
                        if (!channel.isReadResumed()) {
                            channel.getReadSetter().set((ChannelListener)this);
                            channel.resumeReads();
                        }
                        return;
                    }
                    if (res == -1) {
                        try {
                            channel.suspendReads();
                            channel.shutdownReads();
                            ConnectedStreamChannel requestChannel = HttpClientConnectionImpl.this.underlyingChannel;
                            requestChannel.shutdownWrites();
                            if (!requestChannel.flush()) {
                                requestChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                                requestChannel.resumeWrites();
                            }
                            builder.setFailed(new IOException(UndertowClientMessages.MESSAGES.connectionClosed()));
                        }
                        catch (IOException e) {
                            if (UndertowLogger.CLIENT_LOGGER.isDebugEnabled()) {
                                UndertowLogger.CLIENT_LOGGER.debugf(e, "Connection closed with IOException when attempting to shut down reads", new Object[0]);
                            }
                            builder.setFailed(e);
                            IoUtils.safeClose((Closeable)channel);
                            if (free) {
                                pooled.free();
                            }
                            return;
                        }
                        return;
                    }
                    buffer.flip();
                    HttpResponseParser.INSTANCE.handle(buffer, state, builder);
                    if (!buffer.hasRemaining()) continue;
                    free = false;
                    channel.unget(pooled);
                } while (!state.isComplete());
                channel.getReadSetter().set(null);
                channel.suspendReads();
                this.activeRequest = null;
                builder.handleResponseComplete(HttpClientConnectionImpl.this, channel);
            }
            catch (Exception e) {
                UndertowLogger.CLIENT_LOGGER.exceptionProcessingRequest(e);
                IoUtils.safeClose((Closeable)HttpClientConnectionImpl.this.underlyingChannel);
            }
            finally {
                if (free) {
                    pooled.free();
                }
            }
        }
    }
}

