/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.UndertowLogger;
import io.undertow.client.HttpClientConnection;
import io.undertow.client.HttpClientRequest;
import io.undertow.client.HttpClientResponse;
import io.undertow.client.HttpContinueNotification;
import io.undertow.conduits.ChunkedStreamSinkConduit;
import io.undertow.conduits.ChunkedStreamSourceConduit;
import io.undertow.conduits.ReadDataStreamSourceConduit;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpContinue;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyClientProvider;
import io.undertow.util.Attachable;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Methods;
import io.undertow.util.SameThreadExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.StreamConnection;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.StreamSourceConduit;

public final class ProxyHandler
implements HttpHandler {
    private final ProxyClientProvider clientProvider;
    private static final IoFuture.HandlingNotifier<HttpClientResponse, HttpServerExchange> RESPONSE_NOTIFIER = new IoFuture.HandlingNotifier<HttpClientResponse, HttpServerExchange>(){

        public void handleCancelled(HttpServerExchange exchange) {
            exchange.setResponseCode(500);
            exchange.endExchange();
        }

        public void handleFailed(IOException exception, HttpServerExchange exchange) {
            exchange.setResponseCode(500);
            exchange.endExchange();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleDone(final HttpClientResponse response, HttpServerExchange exchange) {
            HeaderMap inboundResponseHeaders = response.getResponseHeaders();
            HeaderMap outboundResponseHeaders = exchange.getResponseHeaders();
            exchange.setResponseCode(response.getResponseCode());
            ProxyHandler.copyHeaders(outboundResponseHeaders, inboundResponseHeaders);
            if (exchange.isUpgrade()) {
                exchange.upgradeChannel(new ExchangeCompletionListener(){

                    @Override
                    public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                        ConnectedStreamChannel clientChannel = null;
                        HttpServerConnection connection = (HttpServerConnection)exchange.getConnection();
                        try {
                            clientChannel = response.getRequest().getConnection().performUpgrade();
                            connection.resetChannel();
                            StreamConnection streamConnection = connection.getChannel();
                            if (connection.getExtraBytes() != null) {
                                streamConnection.getSourceChannel().setConduit((StreamSourceConduit)new ReadDataStreamSourceConduit(streamConnection.getSourceChannel().getConduit(), connection));
                            }
                            ChannelListeners.initiateTransfer((long)Long.MAX_VALUE, (StreamSourceChannel)clientChannel, (StreamSinkChannel)streamConnection.getSinkChannel(), (ChannelListener)ChannelListeners.closingChannelListener(), (ChannelListener)ChannelListeners.writeShutdownChannelListener((ChannelListener)ChannelListeners.flushingChannelListener((ChannelListener)ChannelListeners.closingChannelListener(), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler(), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler(), connection.getBufferPool());
                            ChannelListeners.initiateTransfer((long)Long.MAX_VALUE, (StreamSourceChannel)streamConnection.getSourceChannel(), (StreamSinkChannel)clientChannel, (ChannelListener)ChannelListeners.closingChannelListener(), (ChannelListener)ChannelListeners.writeShutdownChannelListener((ChannelListener)ChannelListeners.flushingChannelListener((ChannelListener)ChannelListeners.closingChannelListener(), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler(), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler(), connection.getBufferPool());
                            nextListener.proceed();
                        }
                        catch (IOException e) {
                            IoUtils.safeClose((Closeable)connection.getChannel());
                        }
                    }
                });
            }
            try {
                ChannelListeners.initiateTransfer((long)Long.MAX_VALUE, (StreamSourceChannel)response.readReplyBody(), (StreamSinkChannel)exchange.getResponseChannel(), (ChannelListener)ChannelListeners.closingChannelListener(), (ChannelListener)new HTTPTrailerChannelListener(response.getRequest(), exchange), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler(), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler(), exchange.getConnection().getBufferPool());
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                try {
                    if (!exchange.isResponseStarted()) {
                        exchange.setResponseCode(500);
                    }
                }
                finally {
                    exchange.endExchange();
                }
            }
        }
    };
    private final HttpHandler proxyClientHandler = new HttpHandler(){

        @Override
        public void handleRequest(HttpServerExchange exchange) throws Exception {
            ServerConnection serverConnection = exchange.getConnection();
            HttpClientConnection clientConnection = exchange.getAttachment(ProxyClient.CONNECTION);
            if (clientConnection != null) {
                exchange.dispatch(SameThreadExecutor.INSTANCE, new ProxyAction(clientConnection, exchange, serverConnection));
                return;
            }
            Throwable error = serverConnection.getAttachment(ProxyClient.THROWABLE);
            if (error != null) {
                if (error instanceof Exception) {
                    throw (Exception)error;
                }
                throw new RuntimeException(error);
            }
            exchange.setResponseCode(500);
        }
    };
    private final HttpHandler proxyClientProviderHandler = new HttpHandler(){

        @Override
        public void handleRequest(HttpServerExchange exchange) throws Exception {
            ProxyClient proxyClient = exchange.getAttachment(ProxyClientProvider.CLIENT);
            if (proxyClient != null) {
                proxyClient.getConnection(exchange, ProxyHandler.this.proxyClientHandler, -1L, TimeUnit.MILLISECONDS);
                return;
            }
            Throwable error = exchange.getAttachment(ProxyClientProvider.THROWABLE);
            if (error != null) {
                if (error instanceof Exception) {
                    throw (Exception)error;
                }
                throw new RuntimeException(error);
            }
            exchange.setResponseCode(500);
        }
    };

    public ProxyHandler(ProxyClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        this.clientProvider.createProxyClient(exchange, this.proxyClientProviderHandler, -1L, TimeUnit.MILLISECONDS);
    }

    static void copyHeaders(HeaderMap to, HeaderMap from) {
        long f = from.fastIterateNonEmpty();
        while (f != -1L) {
            HeaderValues values = from.fiCurrent(f);
            to.putAll(values.getHeaderName(), values);
            f = from.fiNextNonEmpty(f);
        }
    }

    private static final class HTTPTrailerChannelListener
    implements ChannelListener<StreamSinkChannel> {
        private final Attachable source;
        private final Attachable target;

        private HTTPTrailerChannelListener(Attachable source, Attachable target) {
            this.source = source;
            this.target = target;
        }

        public void handleEvent(StreamSinkChannel channel) {
            HeaderMap trailers = this.source.getAttachment(ChunkedStreamSourceConduit.TRAILERS);
            if (trailers != null) {
                this.target.putAttachment(ChunkedStreamSinkConduit.TRAILERS, trailers);
            }
            try {
                channel.shutdownWrites();
                if (!channel.flush()) {
                    channel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()));
                    channel.resumeWrites();
                }
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)channel);
            }
        }
    }

    private static class ProxyAction
    implements Runnable {
        private final HttpClientConnection clientConnection;
        private final HttpServerExchange exchange;
        private final ServerConnection serverConnection;

        public ProxyAction(HttpClientConnection clientConnection, HttpServerExchange exchange, ServerConnection serverConnection) {
            this.clientConnection = clientConnection;
            this.exchange = exchange;
            this.serverConnection = serverConnection;
        }

        @Override
        public void run() {
            HttpClientRequest request;
            try {
                String requestURI = this.exchange.getRequestURI();
                String qs = this.exchange.getQueryString();
                if (qs != null && !qs.isEmpty()) {
                    requestURI = requestURI + "?" + qs;
                }
                request = this.clientConnection.createRequest(this.exchange.getRequestMethod(), new URI(requestURI));
            }
            catch (URISyntaxException e) {
                this.exchange.setResponseCode(500);
                this.exchange.endExchange();
                return;
            }
            HeaderMap inboundRequestHeaders = this.exchange.getRequestHeaders();
            HeaderMap outboundRequestHeaders = request.getRequestHeaders();
            ProxyHandler.copyHeaders(outboundRequestHeaders, inboundRequestHeaders);
            long requestContentLength = this.exchange.getRequestContentLength();
            if (HttpContinue.requiresContinueResponse(this.exchange)) {
                request.setContinueHandler(new HttpContinueNotification(){

                    @Override
                    public void handleContinue(final HttpContinueNotification.ContinueContext context) {
                        HttpContinue.sendContinueResponse(ProxyAction.this.exchange, new IoCallback(){

                            @Override
                            public void onComplete(HttpServerExchange exchange, Sender sender) {
                                context.done();
                            }

                            @Override
                            public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                                context.done();
                            }
                        });
                    }
                });
            }
            if (requestContentLength == 0L || this.exchange.getRequestMethod().equals(Methods.GET)) {
                request.writeRequestBody(0L);
            } else {
                ChannelListeners.initiateTransfer((long)Long.MAX_VALUE, (StreamSourceChannel)this.exchange.getRequestChannel(), (StreamSinkChannel)request.writeRequestBody(requestContentLength), (ChannelListener)ChannelListeners.closingChannelListener(), (ChannelListener)new HTTPTrailerChannelListener(this.exchange, request), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler(), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler(), this.exchange.getConnection().getBufferPool());
            }
            IoFuture<HttpClientResponse> futureResponse = request.getResponse();
            futureResponse.addNotifier((IoFuture.Notifier)RESPONSE_NOTIFIER, (Object)this.exchange);
        }
    }
}

