/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.as.weld.WeldModuleResourceLoader;
import org.jboss.modules.Module;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.reflection.Reflections;

public class BeanDeploymentArchiveImpl
implements BeanDeploymentArchive {
    private final Set<String> beanClasses;
    private final Set<BeanDeploymentArchive> beanDeploymentArchives;
    private final BeansXml beansXml;
    private final String id;
    private final ServiceRegistry serviceRegistry;
    private final Module module;
    private final WeldModuleResourceLoader resourceLoader;
    private final Set<EjbDescriptor<?>> ejbDescriptors;
    private final boolean root;
    private final BeanArchiveType beanArchiveType;

    public BeanDeploymentArchiveImpl(Set<String> beanClasses, BeansXml beansXml, Module module, String id, BeanArchiveType beanArchiveType) {
        this(beanClasses, beansXml, module, id, beanArchiveType, false);
    }

    public BeanDeploymentArchiveImpl(Set<String> beanClasses, BeansXml beansXml, Module module, String id, BeanArchiveType beanArchiveType, boolean root) {
        this.beanClasses = new ConcurrentSkipListSet<String>(beanClasses);
        this.beanDeploymentArchives = new CopyOnWriteArraySet<BeanDeploymentArchive>();
        this.beansXml = beansXml;
        this.id = id;
        this.serviceRegistry = new SimpleServiceRegistry();
        this.resourceLoader = new WeldModuleResourceLoader(module);
        this.serviceRegistry.add(ResourceLoader.class, (Service)this.resourceLoader);
        this.module = module;
        this.ejbDescriptors = new HashSet();
        this.beanArchiveType = beanArchiveType;
        this.root = root;
    }

    public void addBeanDeploymentArchive(BeanDeploymentArchive archive) {
        if (archive == this) {
            return;
        }
        this.beanDeploymentArchives.add(archive);
    }

    public void addBeanDeploymentArchives(Collection<? extends BeanDeploymentArchive> archives) {
        for (BeanDeploymentArchive beanDeploymentArchive : archives) {
            if (beanDeploymentArchive == this) continue;
            this.beanDeploymentArchives.add(beanDeploymentArchive);
        }
    }

    public void addBeanClass(String clazz) {
        this.beanClasses.add(clazz);
    }

    public void addBeanClass(Class<?> clazz) {
        this.resourceLoader.addAdditionalClass(clazz);
    }

    public Collection<String> getBeanClasses() {
        return Collections.unmodifiableSet(new HashSet<String>(this.beanClasses));
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return Collections.unmodifiableCollection(new HashSet<BeanDeploymentArchive>(this.beanDeploymentArchives));
    }

    public BeansXml getBeansXml() {
        return this.beansXml;
    }

    public void addEjbDescriptor(EjbDescriptor<?> descriptor) {
        this.ejbDescriptors.add(descriptor);
    }

    public Collection<EjbDescriptor<?>> getEjbs() {
        return Collections.unmodifiableSet(this.ejbDescriptors);
    }

    public String getId() {
        return this.id;
    }

    public ServiceRegistry getServices() {
        return this.serviceRegistry;
    }

    public Module getModule() {
        return this.module;
    }

    public boolean isRoot() {
        return this.root;
    }

    public boolean isAccessible(BeanDeploymentArchive target) {
        if (this == target) {
            return true;
        }
        Iterator beanClasses = target.getBeanClasses().iterator();
        if (!beanClasses.hasNext()) {
            return false;
        }
        if (this.module == null) {
            return target instanceof BeanDeploymentArchiveImpl && ((BeanDeploymentArchiveImpl)Reflections.cast((Object)target)).getModule() == null;
        }
        String targetClass = (String)beanClasses.next();
        try {
            this.module.getClassLoader().loadClass(targetClass);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public BeanArchiveType getBeanArchiveType() {
        return this.beanArchiveType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.beanArchiveType.toString());
        builder.append(" BeanDeploymentArchive (");
        builder.append(this.id);
        builder.append(")");
        return builder.toString();
    }

    public static enum BeanArchiveType {
        IMPLICIT,
        EXPLICIT,
        EXTERNAL,
        SYNTHETIC;

    }
}

