/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.weld.injection.WeldInjectionContext;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class WeldInjectionInterceptor
implements Interceptor {
    final AtomicReference<ManagedReference> targetReference;

    public WeldInjectionInterceptor(AtomicReference<ManagedReference> targetReference) {
        this.targetReference = targetReference;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        WeldInjectionContext injectionContext = (WeldInjectionContext)context.getPrivateData(WeldInjectionContext.class);
        ManagedReference reference = this.targetReference.get();
        if (reference == null) {
            return null;
        }
        injectionContext.inject(reference.getInstance());
        return context.proceed();
    }

    public static class Factory
    implements InterceptorFactory {
        final ComponentConfiguration configuration;

        public Factory(ComponentConfiguration configuration) {
            this.configuration = configuration;
        }

        public Interceptor create(InterceptorFactoryContext context) {
            AtomicReference targetReference = (AtomicReference)context.getContextData().get(BasicComponentInstance.INSTANCE_KEY);
            return new WeldInjectionInterceptor(targetReference);
        }
    }
}

