/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import edu.emory.mathcs.backport.java.util.concurrent.Semaphore;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.conf.Default;
import org.jacorb.notification.engine.AbstractRetryStrategy;
import org.jacorb.notification.engine.PushOperation;
import org.jacorb.notification.engine.PushTaskExecutor;
import org.jacorb.notification.engine.PushTaskExecutorFactory;
import org.jacorb.notification.engine.RetryException;
import org.jacorb.notification.engine.RetryStrategy;
import org.jacorb.notification.engine.RetryStrategyFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.IProxyPushSupplier;
import org.jacorb.notification.servant.AbstractProxySupplier;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.ORB;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.PortableServer.POA;
import org.picocontainer.defaults.DefaultPicoContainer;

public abstract class AbstractProxyPushSupplier
extends AbstractProxySupplier
implements IProxyPushSupplier {
    private static final String NOTIFY_PUSH_FAILED = "notification.proxy.push_failed";
    private final AtomicReference retryStrategyFactory_;
    private final AtomicBoolean enabled_ = new AtomicBoolean(true);
    private final PushTaskExecutor pushTaskExecutor_;
    private final AtomicInteger pushCounter_ = new AtomicInteger(0);
    private final AtomicInteger pushErrors_ = new AtomicInteger(0);
    protected final Semaphore pushSync_ = new Semaphore(1);
    private final PushTaskExecutor.PushTask pushTask_ = new PushTaskExecutor.PushTask(){

        public void doPush() {
            if (AbstractProxyPushSupplier.this.isEnabled()) {
                AbstractProxyPushSupplier.this.tryPushEvent();
            }
        }

        public void cancel() {
        }
    };
    private final PushTaskExecutor.PushTask flushTask_ = new PushTaskExecutor.PushTask(){

        public void doPush() {
            if (AbstractProxyPushSupplier.this.isEnabled()) {
                AbstractProxyPushSupplier.this.flushPendingEvents();
            }
        }

        public void cancel() {
        }
    };

    public AbstractProxyPushSupplier(IAdmin admin, ORB orb, POA poa, Configuration conf, TaskProcessor taskProcessor, PushTaskExecutorFactory pushTaskExecutorFactory, OfferManager offerManager, SubscriptionManager subscriptionManager, ConsumerAdmin consumerAdmin) throws ConfigurationException {
        super(admin, orb, poa, conf, taskProcessor, offerManager, subscriptionManager, consumerAdmin);
        this.pushTaskExecutor_ = pushTaskExecutorFactory.newExecutor(this);
        this.retryStrategyFactory_ = new AtomicReference((Object)this.newRetryStrategyFactory(conf, taskProcessor));
        this.eventTypes_.add(NOTIFY_PUSH_FAILED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tryPushEvent() {
        try {
            boolean _acquired = this.pushSync_.tryAcquire(1000L, TimeUnit.MILLISECONDS);
            if (!_acquired) {
                this.schedulePush();
                return true;
            }
            try {
                boolean bl = this.pushEvent();
                return bl;
            }
            finally {
                this.pushSync_.release();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    protected abstract boolean pushEvent();

    protected void handleFailedPushOperation(PushOperation operation, Exception error) {
        this.logger_.warn("handle failed pushoperation", (Throwable)error);
        if (this.isDestroyed()) {
            operation.dispose();
            return;
        }
        StringWriter out = new StringWriter();
        error.printStackTrace(new PrintWriter(out));
        this.sendNotification(NOTIFY_PUSH_FAILED, "Push Operation failed", out.toString());
        this.pushErrors_.getAndIncrement();
        this.incErrorCounter();
        if (AbstractRetryStrategy.isFatalException(error)) {
            if (this.logger_.isWarnEnabled()) {
                this.logger_.warn("push raised " + error + ": will destroy ProxySupplier, " + "disconnect Consumer", (Throwable)error);
            }
            operation.dispose();
            this.destroy();
        } else if (!this.isRetryAllowed()) {
            this.logger_.warn("no more retries allowed. disconnect consumer");
            operation.dispose();
            this.destroy();
        } else if (!this.isDestroyed()) {
            RetryStrategy _retry = this.newRetryStrategy(this, operation);
            try {
                _retry.retry();
            }
            catch (RetryException e) {
                this.logger_.error("retry failed", (Throwable)e);
                _retry.dispose();
                this.destroy();
            }
        } else {
            throw new IllegalStateException("should not happen");
        }
    }

    private RetryStrategy newRetryStrategy(IProxyPushSupplier pushSupplier, PushOperation pushOperation) {
        return ((RetryStrategyFactory)this.retryStrategyFactory_.get()).newRetryStrategy(pushSupplier, pushOperation);
    }

    private RetryStrategyFactory newRetryStrategyFactory(Configuration config, TaskProcessor taskProcessor) throws ConfigurationException {
        String factoryName = config.getAttribute("jacorb.notification.proxysupplier.retrystrategy_factory", Default.DEFAULT_RETRY_STRATEGY_FACTORY);
        try {
            return this.newRetryStrategyFactory(config, taskProcessor, factoryName);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("jacorb.notification.proxysupplier.retrystrategy_factory", e);
        }
    }

    public void setRetryStrategy(String factoryName) throws ClassNotFoundException {
        RetryStrategyFactory factory = this.newRetryStrategyFactory(this.config_, this.getTaskProcessor(), factoryName);
        this.retryStrategyFactory_.set((Object)factory);
        this.logger_.info("set RetryStrategyFactory: " + factoryName);
    }

    public String getRetryStrategy() {
        return this.retryStrategyFactory_.get().getClass().getName();
    }

    private RetryStrategyFactory newRetryStrategyFactory(Configuration config, TaskProcessor taskProcessor, String factoryName) throws ClassNotFoundException {
        Class factoryClazz = ObjectUtil.classForName(factoryName);
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.registerComponentInstance(TaskProcessor.class, (Object)taskProcessor);
        pico.registerComponentImplementation(RetryStrategyFactory.class, factoryClazz);
        pico.registerComponentInstance((Object)config);
        return (RetryStrategyFactory)pico.getComponentInstance(RetryStrategyFactory.class);
    }

    public final void schedulePush() {
        if (this.isEnabled()) {
            this.scheduleTask(this.pushTask_);
        }
    }

    public void scheduleFlush() {
        if (this.isEnabled()) {
            this.scheduleTask(this.flushTask_);
        }
    }

    public final void scheduleTask(PushTaskExecutor.PushTask pushTask) {
        if (!this.isDestroyed() && !this.isSuspended()) {
            this.pushTaskExecutor_.executePush(pushTask);
        }
    }

    public void flushPendingEvents() {
        while (this.tryPushEvent()) {
        }
    }

    public final void messageQueued() {
        if (this.isEnabled()) {
            this.schedulePush();
        }
    }

    public void resetErrorCounter() {
        super.resetErrorCounter();
        this.pushCounter_.getAndIncrement();
        this.enableDelivery();
    }

    public void disableDelivery() {
        boolean _wasEnabled = this.enabled_.getAndSet(false);
        if (_wasEnabled) {
            this.logger_.warn("disabled delivery to ProxySupplier temporarily");
        }
    }

    protected boolean isEnabled() {
        return this.enabled_.get();
    }

    private void enableDelivery() {
        boolean _wasEnabled = this.enabled_.getAndSet(true);
        if (!_wasEnabled) {
            this.logger_.debug("enabled delivery to ProxySupplier");
        }
    }

    public int getPushOperationCount() {
        return this.pushCounter_.get();
    }

    public int getPushErrorCount() {
        return this.pushErrors_.get();
    }

    public int getAveragePushDuration() {
        return (int)this.getCost() / this.getPushOperationCount();
    }
}

