/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.session;

import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.wildfly.clustering.web.session.ImmutableSession;

public class ImmutableHttpSessionAdapter
implements HttpSession {
    private final ImmutableSession session;

    public ImmutableHttpSessionAdapter(ImmutableSession session) {
        this.session = session;
    }

    public long getCreationTime() {
        return this.session.getMetaData().getCreationTime().getTime();
    }

    public String getId() {
        return this.session.getId();
    }

    public long getLastAccessedTime() {
        return this.session.getMetaData().getLastAccessedTime().getTime();
    }

    public ServletContext getServletContext() {
        return this.session.getContext().getServletContext();
    }

    public void setMaxInactiveInterval(int interval) {
        throw new UnsupportedOperationException();
    }

    public int getMaxInactiveInterval() {
        return (int)this.session.getMetaData().getMaxInactiveInterval(TimeUnit.SECONDS);
    }

    public Object getAttribute(String name) {
        return this.session.getAttributes().getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.session.getAttributes().getAttributeNames());
    }

    public void setAttribute(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    public void removeAttribute(String name) {
        throw new UnsupportedOperationException();
    }

    public void invalidate() {
        throw new UnsupportedOperationException();
    }

    public boolean isNew() {
        return this.session.getMetaData().isNew();
    }

    @Deprecated
    public String[] getValueNames() {
        return Collections.list(this.getAttributeNames()).toArray(new String[0]);
    }

    @Deprecated
    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    @Deprecated
    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    @Deprecated
    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        return new HttpSessionContext(){

            public Enumeration<String> getIds() {
                return Collections.enumeration(Collections.emptyList());
            }

            public HttpSession getSession(String sessionId) {
                return null;
            }
        };
    }
}

