/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.config;

import java.util.ArrayList;
import java.util.List;
import org.jboss.wsf.spi.metadata.config.AbstractCommonConfig;
import org.jboss.wsf.spi.metadata.config.ClientConfig;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.config.EndpointConfig;

public class ConfigRoot {
    private List<ClientConfig> clientConfigList = new ArrayList<ClientConfig>();
    private List<EndpointConfig> endpointConfigList = new ArrayList<EndpointConfig>();

    public List<ClientConfig> getClientConfig() {
        return this.clientConfigList;
    }

    public void addClientConfig(ClientConfig clientConfig) {
        this.clientConfigList.add(clientConfig);
    }

    public void addEndpointConfig(EndpointConfig endpointConfig) {
        this.endpointConfigList.add(endpointConfig);
    }

    public void setClientConfig(List<ClientConfig> clientConfig) {
        this.clientConfigList = clientConfig;
    }

    public List<EndpointConfig> getEndpointConfig() {
        return this.endpointConfigList;
    }

    public void setEndpointConfig(List<EndpointConfig> endpointConfig) {
        this.endpointConfigList = endpointConfig;
    }

    public ClientConfig getClientConfigByName(String configName) {
        ClientConfig config = null;
        for (ClientConfig aux : this.clientConfigList) {
            if (!aux.getConfigName().equals(configName)) continue;
            config = aux;
            break;
        }
        if (config == null && this.clientConfigList.size() == 1) {
            config = this.clientConfigList.get(0);
        }
        return config;
    }

    public EndpointConfig getEndpointConfigByName(String configName) {
        EndpointConfig config = null;
        for (EndpointConfig aux : this.endpointConfigList) {
            if (!aux.getConfigName().equals(configName)) continue;
            config = aux;
            break;
        }
        if (config == null && this.endpointConfigList.size() == 1) {
            config = this.endpointConfigList.get(0);
        }
        return config;
    }

    public CommonConfig getConfigByName(String name) {
        AbstractCommonConfig config = this.getClientConfigByName(name);
        if (null == config) {
            config = this.getEndpointConfigByName(name);
        }
        return config;
    }
}

