/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.constraint;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.constraint.AbstractConstraint;
import org.jboss.as.controller.access.constraint.Constraint;
import org.jboss.as.controller.access.constraint.ConstraintFactory;
import org.jboss.as.controller.access.constraint.ScopingConstraint;
import org.jboss.as.controller.access.rbac.StandardRole;

public class HostEffectConstraint
extends AbstractConstraint
implements ScopingConstraint {
    public static final ConstraintFactory FACTORY = new Factory();
    public static final HostEffectConstraint GLOBAL = new HostEffectConstraint();
    private final boolean global;
    private volatile Set<String> specific = new LinkedHashSet<String>();

    private HostEffectConstraint() {
        this.global = true;
    }

    private HostEffectConstraint(Set<String> allowed) {
        this.global = false;
        this.specific.addAll(allowed);
    }

    public HostEffectConstraint(List<String> allowed) {
        this.global = false;
        this.specific.addAll(allowed);
    }

    public void setAllowedHosts(List<String> allowed) {
        assert (!this.global) : "constraint is global";
        this.specific = new LinkedHashSet<String>(allowed);
    }

    @Override
    public boolean violates(Constraint other) {
        if (other instanceof HostEffectConstraint) {
            HostEffectConstraint hec = (HostEffectConstraint)other;
            return this.global && !hec.global || !hec.specific.containsAll(this.specific);
        }
        return false;
    }

    @Override
    protected int internalCompare(AbstractConstraint other) {
        return this.equals(other) ? 0 : -1;
    }

    private static class Factory
    implements ConstraintFactory {
        private Factory() {
        }

        @Override
        public Constraint getStandardUserConstraint(StandardRole role, Action.ActionEffect actionEffect) {
            return GLOBAL;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetAttribute target) {
            return this.getRequiredConstraint(target.getHosts());
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetResource target) {
            return this.getRequiredConstraint(target.getHosts());
        }

        private Constraint getRequiredConstraint(Set<String> hosts) {
            if (hosts == null || hosts.isEmpty()) {
                return GLOBAL;
            }
            return new HostEffectConstraint(hosts);
        }
    }
}

