/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.NoSuchResourceException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.UnauthorizedException;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.FilteredData;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.global.ReadAttributeHandler;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class ReadResourceHandler
extends GlobalOperationHandlers.AbstractMultiTargetHandler
implements OperationStepHandler {
    private static final SimpleAttributeDefinition ATTRIBUTES_ONLY = new SimpleAttributeDefinitionBuilder("attributes-only", ModelType.BOOLEAN).setAllowNull(true).setDefaultValue(new ModelNode(false)).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-resource", ControllerResolver.getResolver("global")).setParameters(GlobalOperationHandlers.RECURSIVE, GlobalOperationHandlers.RECURSIVE_DEPTH, GlobalOperationHandlers.PROXIES, GlobalOperationHandlers.INCLUDE_RUNTIME, GlobalOperationHandlers.INCLUDE_DEFAULTS, ATTRIBUTES_ONLY, GlobalOperationHandlers.INCLUDE_ALIASES).setReadOnly().setRuntimeOnly().setReplyType(ModelType.OBJECT).build();
    public static final OperationStepHandler INSTANCE = new ReadResourceHandler();
    private final ParametersValidator validator = new ParametersValidator(){

        @Override
        public void validate(ModelNode operation) throws OperationFailedException {
            super.validate(operation);
            if (operation.hasDefined("attributes-only")) {
                if (operation.hasDefined("recursive")) {
                    throw ControllerMessages.MESSAGES.cannotHaveBothParameters("attributes-only", "recursive");
                }
                if (operation.hasDefined("recursive-depth")) {
                    throw ControllerMessages.MESSAGES.cannotHaveBothParameters("attributes-only", "recursive-depth");
                }
            }
        }
    };
    private final FilteredData filteredData;
    private final OperationStepHandler overrideHandler;

    public ReadResourceHandler() {
        this(null, null);
    }

    ReadResourceHandler(FilteredData filteredData, OperationStepHandler overrideHandler) {
        this.validator.registerValidator("recursive", new ModelTypeValidator(ModelType.BOOLEAN, true));
        this.validator.registerValidator("recursive-depth", new ModelTypeValidator(ModelType.INT, true));
        this.validator.registerValidator("include-runtime", new ModelTypeValidator(ModelType.BOOLEAN, true));
        this.validator.registerValidator("proxies", new ModelTypeValidator(ModelType.BOOLEAN, true));
        this.validator.registerValidator("include-defaults", new ModelTypeValidator(ModelType.BOOLEAN, true));
        this.validator.registerValidator("attributes-only", new ModelTypeValidator(ModelType.BOOLEAN, true));
        this.filteredData = filteredData;
        this.overrideHandler = overrideHandler;
    }

    @Override
    void doExecute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (this.filteredData == null) {
            this.doExecuteInternal(context, operation);
        } else {
            try {
                if (this.overrideHandler == null) {
                    this.doExecuteInternal(context, operation);
                } else {
                    this.overrideHandler.execute(context, operation);
                }
            }
            catch (NoSuchResourceException nsre) {
                PathAddress pa = PathAddress.pathAddress(operation.get("address"));
                this.filteredData.addAccessRestrictedResource(pa);
                context.getResult().set(new ModelNode());
                context.stepCompleted();
            }
            catch (UnauthorizedException ue) {
                PathAddress pa = PathAddress.pathAddress(operation.get("address"));
                this.filteredData.addReadRestrictedResource(pa);
                context.getResult().set(new ModelNode());
                context.stepCompleted();
            }
        }
    }

    void doExecuteInternal(OperationContext context, ModelNode operation) throws OperationFailedException {
        Locale locale;
        DescriptionProvider descriptionProvider;
        ModelNode nodeDescription;
        Map childrenByType;
        this.validator.validate(operation);
        String opName = operation.require("operation").asString();
        PathAddress address = PathAddress.pathAddress(operation.get("address"));
        int recursiveDepth = operation.get("recursive-depth").asInt(0);
        boolean recursive = recursiveDepth > 0 || operation.get("recursive").asBoolean(false);
        boolean queryRuntime = operation.get("include-runtime").asBoolean(false);
        boolean proxies = operation.get("proxies").asBoolean(false);
        boolean aliases = operation.get("include-aliases").asBoolean(false);
        boolean defaults = operation.get("include-defaults").asBoolean(true);
        boolean attributesOnly = operation.get("attributes-only").asBoolean(false);
        HashSet<String> nonExistentChildTypes = new HashSet<String>();
        HashMap<String, ModelNode> directChildren = new HashMap<String, ModelNode>();
        HashMap<String, ModelNode> metrics = queryRuntime ? new HashMap<String, ModelNode>() : Collections.emptyMap();
        HashMap<String, ModelNode> otherAttributes = new HashMap<String, ModelNode>();
        LinkedHashMap<PathElement, ModelNode> childResources = recursive ? new LinkedHashMap<PathElement, ModelNode>() : Collections.emptyMap();
        FilteredData localFilteredData = this.filteredData == null ? new FilteredData(address) : this.filteredData;
        ReadResourceAssemblyHandler assemblyHandler = new ReadResourceAssemblyHandler(address, metrics, otherAttributes, directChildren, childResources, nonExistentChildTypes, localFilteredData);
        context.addStep(assemblyHandler, queryRuntime ? OperationContext.Stage.VERIFY : OperationContext.Stage.MODEL, true);
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        Resource resource = ReadResourceHandler.nullSafeReadResource(context, registry);
        Map<Object, Object> map = childrenByType = registry != null ? GlobalOperationHandlers.getChildAddresses(context, address, registry, resource, null) : Collections.emptyMap();
        if (!attributesOnly) {
            for (Map.Entry entry : childrenByType.entrySet()) {
                String childType = (String)entry.getKey();
                nonExistentChildTypes.add(childType);
                for (String child : (Set)entry.getValue()) {
                    PathElement childPE = PathElement.pathElement(childType, child);
                    PathAddress absoluteChildAddr = address.append(childPE);
                    ModelNode rrOp = Util.createEmptyOperation("read-resource", absoluteChildAddr);
                    PathAddress relativeAddr = PathAddress.pathAddress(childPE);
                    if (recursive) {
                        boolean getChild;
                        ImmutableManagementResourceRegistration childReg = registry.getSubModel(relativeAddr);
                        if (childReg == null) {
                            throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.noChildRegistry(childType, child)));
                        }
                        boolean proxy = childReg.isRemote();
                        boolean runtimeResource = childReg.isRuntimeOnly();
                        boolean bl = getChild = !runtimeResource || queryRuntime && !proxy || proxies && proxy;
                        if (!aliases && childReg.isAlias()) {
                            nonExistentChildTypes.remove(childType);
                            getChild = false;
                        }
                        if (!getChild) continue;
                        nonExistentChildTypes.remove(childType);
                        int newDepth = recursiveDepth > 0 ? recursiveDepth - 1 : 0;
                        rrOp.get("recursive").set(operation.get("recursive"));
                        rrOp.get("recursive-depth").set(newDepth);
                        rrOp.get("proxies").set(proxies);
                        rrOp.get("include-runtime").set(queryRuntime);
                        rrOp.get("include-aliases").set(aliases);
                        rrOp.get("include-defaults").set(defaults);
                        ModelNode rrRsp = new ModelNode();
                        childResources.put(childPE, rrRsp);
                        OperationStepHandler overrideHandler = childReg.getOperationHandler(PathAddress.EMPTY_ADDRESS, opName);
                        if (overrideHandler != null && overrideHandler.getClass() == this.getClass()) {
                            overrideHandler = null;
                        }
                        ReadResourceHandler rrHandler = new ReadResourceHandler(localFilteredData, overrideHandler);
                        context.addStep(rrRsp, rrOp, rrHandler, OperationContext.Stage.MODEL, true);
                        continue;
                    }
                    AuthorizationResult ar = context.authorize(rrOp, EnumSet.of(Action.ActionEffect.ADDRESS));
                    if (ar.getDecision() == AuthorizationResult.Decision.DENY) {
                        localFilteredData.addAccessRestrictedResource(absoluteChildAddr);
                        continue;
                    }
                    ModelNode childMap = (ModelNode)directChildren.get(childType);
                    if (childMap == null) {
                        nonExistentChildTypes.remove(childType);
                        childMap = new ModelNode();
                        childMap.setEmptyObject();
                        directChildren.put(childType, childMap);
                    }
                    childMap.get(child);
                }
            }
        }
        Set<String> attributeNames = registry != null ? registry.getAttributeNames(PathAddress.EMPTY_ADDRESS) : Collections.emptySet();
        for (String attributeName : attributeNames) {
            AttributeAccess access = registry.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName);
            if (!aliases && access.getFlags().contains((Object)AttributeAccess.Flag.ALIAS) || !queryRuntime && access.getStorageType() != AttributeAccess.Storage.CONFIGURATION) continue;
            HashMap<String, ModelNode> responseMap = access.getAccessType() == AttributeAccess.AccessType.METRIC ? metrics : otherAttributes;
            this.addReadAttributeStep(context, address, defaults, localFilteredData, registry, attributeName, responseMap);
        }
        ModelNode model = resource.getModel();
        if (model.isDefined()) {
            for (String key : model.keys()) {
                if (otherAttributes.containsKey(key) || childrenByType.containsKey(key) || metrics.containsKey(key)) continue;
                this.addReadAttributeStep(context, address, defaults, localFilteredData, registry, key, otherAttributes);
            }
        }
        if (defaults && (nodeDescription = (descriptionProvider = registry.getModelDescription(PathAddress.EMPTY_ADDRESS)).getModelDescription(locale = GlobalOperationHandlers.getLocale(context, operation))).isDefined() && nodeDescription.hasDefined("attributes")) {
            for (String key : nodeDescription.get("attributes").keys()) {
                if (childrenByType.containsKey(key) || otherAttributes.containsKey(key) || metrics.containsKey(key) || !nodeDescription.get("attributes").hasDefined(key) || !nodeDescription.get(new String[]{"attributes", key}).hasDefined("default")) continue;
                this.addReadAttributeStep(context, address, defaults, localFilteredData, registry, key, otherAttributes);
            }
        }
        context.stepCompleted();
    }

    private void addReadAttributeStep(OperationContext context, PathAddress address, boolean defaults, FilteredData localFilteredData, ImmutableManagementResourceRegistration registry, String attributeName, Map<String, ModelNode> responseMap) {
        OperationStepHandler overrideHandler = registry.getOperationHandler(PathAddress.EMPTY_ADDRESS, "read-attribute");
        if (overrideHandler != null && overrideHandler == ReadAttributeHandler.INSTANCE) {
            overrideHandler = null;
        }
        ReadAttributeHandler readAttributeHandler = new ReadAttributeHandler(localFilteredData, overrideHandler);
        ModelNode attributeOperation = Util.getReadAttributeOperation(address, attributeName);
        attributeOperation.get("include-defaults").set(defaults);
        ModelNode attrResponse = new ModelNode();
        responseMap.put(attributeName, attrResponse);
        context.addStep(attrResponse, attributeOperation, readAttributeHandler, OperationContext.Stage.MODEL, true);
    }

    private static Resource nullSafeReadResource(OperationContext context, ImmutableManagementResourceRegistration registry) {
        Resource result;
        if (registry != null && registry.isRuntimeOnly()) {
            try {
                result = context.readResource(PathAddress.EMPTY_ADDRESS, true);
            }
            catch (RuntimeException e) {
                result = PlaceholderResource.INSTANCE;
            }
        } else {
            result = context.readResource(PathAddress.EMPTY_ADDRESS, true);
        }
        return result;
    }

    private static class ReadResourceAssemblyHandler
    implements OperationStepHandler {
        private final PathAddress address;
        private final Map<String, ModelNode> directChildren;
        private final Map<String, ModelNode> metrics;
        private final Map<String, ModelNode> otherAttributes;
        private final Map<PathElement, ModelNode> childResources;
        private final Set<String> nonExistentChildTypes;
        private final FilteredData filteredData;

        private ReadResourceAssemblyHandler(PathAddress address, Map<String, ModelNode> metrics, Map<String, ModelNode> otherAttributes, Map<String, ModelNode> directChildren, Map<PathElement, ModelNode> childResources, Set<String> nonExistentChildTypes, FilteredData filteredData) {
            this.address = address;
            this.metrics = metrics;
            this.otherAttributes = otherAttributes;
            this.directChildren = directChildren;
            this.childResources = childResources;
            this.nonExistentChildTypes = nonExistentChildTypes;
            this.filteredData = filteredData;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode value;
            TreeMap<String, ModelNode> sortedAttributes = new TreeMap<String, ModelNode>();
            TreeMap<Object, ModelNode> sortedChildren = new TreeMap<Object, ModelNode>();
            boolean failed = false;
            for (Map.Entry<String, ModelNode> entry : this.otherAttributes.entrySet()) {
                value = entry.getValue();
                if (!value.has("failure-description")) {
                    sortedAttributes.put(entry.getKey(), value.get("result"));
                    continue;
                }
                if (!value.hasDefined("failure-description")) continue;
                context.getFailureDescription().set(value.get("failure-description"));
                failed = true;
                break;
            }
            if (!failed) {
                for (Map.Entry<Object, ModelNode> entry : this.childResources.entrySet()) {
                    PathElement path = (PathElement)entry.getKey();
                    ModelNode value2 = entry.getValue();
                    if (!value2.has("failure-description")) {
                        ModelNode childTypeNode = (ModelNode)sortedChildren.get(path.getKey());
                        if (childTypeNode == null) {
                            childTypeNode = new ModelNode();
                            sortedChildren.put(path.getKey(), childTypeNode);
                        }
                        childTypeNode.get(path.getValue()).set(value2.get("result"));
                        continue;
                    }
                    if (failed || !value2.hasDefined("failure-description")) continue;
                    context.getFailureDescription().set(value2.get("failure-description"));
                    failed = true;
                }
            }
            if (!failed) {
                for (Map.Entry<Object, ModelNode> entry : this.directChildren.entrySet()) {
                    sortedChildren.put(entry.getKey(), entry.getValue());
                }
                for (String string : this.nonExistentChildTypes) {
                    sortedChildren.put(string, new ModelNode());
                }
                for (Map.Entry entry : this.metrics.entrySet()) {
                    value = (ModelNode)entry.getValue();
                    if (value.has("failure-description")) continue;
                    sortedAttributes.put((String)entry.getKey(), value.get("result"));
                }
                ModelNode result = context.getResult();
                result.setEmptyObject();
                for (Map.Entry entry : sortedAttributes.entrySet()) {
                    result.get((String)entry.getKey()).set((ModelNode)entry.getValue());
                }
                for (Map.Entry entry : sortedChildren.entrySet()) {
                    if (!((ModelNode)entry.getValue()).isDefined()) {
                        result.get((String)entry.getKey()).set((ModelNode)entry.getValue());
                        continue;
                    }
                    ModelNode childTypeNode = new ModelNode();
                    for (Property property : ((ModelNode)entry.getValue()).asPropertyList()) {
                        PathElement pe = PathElement.pathElement((String)entry.getKey(), property.getName());
                        if (this.filteredData.isFilteredResource(this.address, pe)) continue;
                        childTypeNode.get(property.getName()).set(property.getValue());
                    }
                    result.get((String)entry.getKey()).set(childTypeNode);
                }
                if (this.filteredData.hasFilteredData()) {
                    context.getResponseHeaders().get("access-control").set(this.filteredData.toModelNode());
                }
            }
            context.stepCompleted();
        }
    }
}

