/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.constraint.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.jdr.CommonAttributes;
import org.jboss.as.jdr.JdrReport;
import org.jboss.as.jdr.JdrReportCollector;
import org.jboss.as.jdr.JdrReportExtension;
import org.jboss.as.jdr.JdrReportService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceRegistry;

public class JdrReportRequestHandler
implements OperationStepHandler {
    private static final String OPERATION_NAME = "generate-jdr-report";
    static final JdrReportRequestHandler INSTANCE = new JdrReportRequestHandler();
    static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("generate-jdr-report", (ResourceDescriptionResolver)JdrReportExtension.getResourceDescriptionResolver(new String[0])).setReplyParameters(new AttributeDefinition[]{CommonAttributes.START_TIME, CommonAttributes.END_TIME, CommonAttributes.REPORT_LOCATION}).setReadOnly().setRuntimeOnly().addAccessConstraint((AccessConstraintDefinition)JdrReportExtension.JDR_SENSITIVITY_DEF).build();
    private final ParametersValidator validator = new ParametersValidator();

    private JdrReportRequestHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validate(operation);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceRegistry registry = context.getServiceRegistry(false);
                JdrReportCollector jdrCollector = (JdrReportCollector)JdrReportCollector.class.cast(registry.getRequiredService(JdrReportService.SERVICE_NAME).getValue());
                ModelNode response = context.getResult();
                JdrReport report = jdrCollector.collect();
                if (report.getStartTime() != null) {
                    response.get("start-time").set(report.getStartTime().toString());
                }
                if (report.getEndTime() != null) {
                    response.get("end-time").set(report.getEndTime().toString());
                }
                response.get("report-location").set(report.getLocation());
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

