/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan;

import java.util.Arrays;
import java.util.Currency;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.wildfly.clustering.annotation.Immutable;
import org.wildfly.clustering.web.infinispan.Mutator;

public class CacheMutator<K, V>
implements Mutator {
    private static List<Class<?>> IMMUTABLE_TYPES = Arrays.asList(Boolean.class, Character.class, Currency.class, Enum.class, Locale.class, Number.class, String.class, TimeZone.class, UUID.class);
    private final Cache<K, V> cache;
    private final CacheInvoker invoker;
    private final K id;
    private final V value;
    private final Set<Flag> flags;
    private final AtomicBoolean mutated = new AtomicBoolean(false);

    public CacheMutator(Cache<K, V> cache, CacheInvoker invoker, K id, V value, Flag ... flags) {
        this.cache = cache;
        this.invoker = invoker;
        this.id = id;
        this.value = value;
        this.flags = EnumSet.of(Flag.IGNORE_RETURN_VALUES, flags);
    }

    @Override
    public void mutate() {
        if (this.mutated.compareAndSet(false, true)) {
            this.invoker.invoke(this.cache, new Mutator.MutateOperation<K, V>(this.id, this.value), this.flags.toArray(new Flag[this.flags.size()]));
        }
    }

    public static boolean isMutable(Object object) {
        if (object == null) {
            return false;
        }
        for (Class<?> immutableClass : IMMUTABLE_TYPES) {
            if (!immutableClass.isInstance(object)) continue;
            return false;
        }
        return !object.getClass().isAnnotationPresent(Immutable.class);
    }
}

