/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.resolvers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.resolvers.ModelNodeResolver;
import org.jboss.dmr.ModelNode;

public class SizeResolver
implements ModelNodeResolver<String> {
    private static final Pattern SIZE_PATTERN = Pattern.compile("(\\d+)([kKmMgGbBtT])?");
    public static final SizeResolver INSTANCE = new SizeResolver();

    @Override
    public String resolveValue(OperationContext context, ModelNode value) throws OperationFailedException {
        return String.valueOf(this.parseSize(value));
    }

    public long parseSize(ModelNode value) throws OperationFailedException {
        Matcher matcher = SIZE_PATTERN.matcher(value.asString());
        if (!matcher.matches()) {
            throw Logging.createOperationFailure(LoggingMessages.MESSAGES.invalidSize(value.asString()));
        }
        long qty = Long.parseLong(matcher.group(1), 10);
        String chr = matcher.group(2);
        if (chr != null) {
            switch (chr.charAt(0)) {
                case 'B': 
                case 'b': {
                    break;
                }
                case 'K': 
                case 'k': {
                    qty <<= 10;
                    break;
                }
                case 'M': 
                case 'm': {
                    qty <<= 20;
                    break;
                }
                case 'G': 
                case 'g': {
                    qty <<= 30;
                    break;
                }
                case 'T': 
                case 't': {
                    qty <<= 40;
                    break;
                }
                default: {
                    throw Logging.createOperationFailure(LoggingMessages.MESSAGES.invalidSize(value.asString()));
                }
            }
        }
        return qty;
    }
}

