/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.metadata.internal;

import java.util.ArrayList;
import java.util.List;
import org.jboss.osgi.metadata.ActivationPolicyMetaData;
import org.jboss.osgi.metadata.internal.AbstractActivationPolicyMetaData;
import org.jboss.osgi.metadata.internal.AbstractValueCreator;

class ActivationPolicyMDValueCreator
extends AbstractValueCreator<ActivationPolicyMetaData> {
    private static final String INCLUDE = "include:=";
    private static final String EXCLUDE = "exclude:=";

    public ActivationPolicyMDValueCreator() {
        super(true);
    }

    @Override
    protected ActivationPolicyMetaData useString(String attibute) {
        AbstractActivationPolicyMetaData aap = new AbstractActivationPolicyMetaData();
        String[] split = attibute.split(";");
        aap.setType(split[0]);
        if (split.length > 1) {
            this.readDirective(aap, split[1].trim());
        }
        if (split.length > 2) {
            this.readDirective(aap, split[2].trim());
        }
        return aap;
    }

    protected void readDirective(AbstractActivationPolicyMetaData aap, String directive) {
        if (directive.startsWith(INCLUDE)) {
            List<String> list = this.getPackageList(INCLUDE, directive);
            aap.setIncludes(list);
        } else if (directive.startsWith(EXCLUDE)) {
            List<String> list = this.getPackageList(EXCLUDE, directive);
            aap.setExcludes(list);
        }
    }

    private List<String> getPackageList(String prefix, String directive) {
        if ((directive = directive.substring(prefix.length())).startsWith("\"") && directive.endsWith("\"")) {
            directive = directive.substring(1, directive.length() - 1);
        }
        if (directive.startsWith("'") && directive.endsWith("'")) {
            directive = directive.substring(1, directive.length() - 1);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String packname : directive.split(",")) {
            result.add(packname.trim());
        }
        return result;
    }
}

