/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.constraint.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.constraint.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.jacorb.SSLConfigValue;
import org.jboss.as.jacorb.SecurityAllowedValues;
import org.jboss.as.jacorb.TransactionsAllowedValues;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class JacORBSubsystemDefinitions {
    private static final ModelNode DEFAULT_DISABLED_PROPERTY = new ModelNode().set("off");
    private static final ModelNode DEFAULT_ENABLED_PROPERTY = new ModelNode().set("on");
    private static final ParameterValidator SSL_CONFIG_VALIDATOR = new EnumValidator(SSLConfigValue.class, true, false);
    private static final ParameterValidator ON_OFF_VALIDATOR = new EnumValidator(TransactionsAllowedValues.class, true, false, (Enum[])new TransactionsAllowedValues[]{TransactionsAllowedValues.ON, TransactionsAllowedValues.OFF});
    static final SensitivityClassification JACORB_SECURITY = new SensitivityClassification("jacorb", "jacorb-security", false, false, true);
    static final SensitiveTargetAccessConstraintDefinition JACORB_SECURITY_DEF = new SensitiveTargetAccessConstraintDefinition(JACORB_SECURITY);
    public static final SimpleAttributeDefinition ORB_NAME = new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, true).setDefaultValue(new ModelNode().set("JBoss")).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition ORB_PRINT_VERSION = new SimpleAttributeDefinitionBuilder("print-version", ModelType.STRING, true).setDefaultValue(DEFAULT_DISABLED_PROPERTY).setValidator(ON_OFF_VALIDATOR).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition ORB_USE_IMR = new SimpleAttributeDefinitionBuilder("use-imr", ModelType.STRING, true).setDefaultValue(DEFAULT_DISABLED_PROPERTY).setValidator(ON_OFF_VALIDATOR).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition ORB_USE_BOM = new SimpleAttributeDefinitionBuilder("use-bom", ModelType.STRING, true).setDefaultValue(DEFAULT_DISABLED_PROPERTY).setValidator(ON_OFF_VALIDATOR).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition ORB_CACHE_TYPECODES = new SimpleAttributeDefinitionBuilder("cache-typecodes", ModelType.STRING, true).setDefaultValue(DEFAULT_DISABLED_PROPERTY).setValidator(ON_OFF_VALIDATOR).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition ORB_CACHE_POA_NAMES = new SimpleAttributeDefinitionBuilder("cache-poa-names", ModelType.STRING, true).setDefaultValue(DEFAULT_DISABLED_PROPERTY).setValidator(ON_OFF_VALIDATOR).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition ORB_GIOP_MINOR_VERSION = new SimpleAttributeDefinitionBuilder("giop-minor-version", ModelType.INT, true).setDefaultValue(new ModelNode().set(2)).setValidator((ParameterValidator)new IntRangeValidator(0, 2, true, false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition ORB_SOCKET_BINDING = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("socket-binding", ModelType.STRING, true).setDefaultValue(new ModelNode().set("jacorb")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).build();
    public static final SimpleAttributeDefinition ORB_SSL_SOCKET_BINDING = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ssl-socket-binding", ModelType.STRING, true).setDefaultValue(new ModelNode().set("jacorb-ssl")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).build();
    public static final SimpleAttributeDefinition ORB_CONN_RETRIES = new SimpleAttributeDefinitionBuilder("retries", ModelType.INT, true).setDefaultValue(new ModelNode().set(5)).setValidator((ParameterValidator)new IntRangeValidator(0, 50, true, false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition ORB_CONN_RETRY_INTERVAL = new SimpleAttributeDefinitionBuilder("retry-interval", ModelType.INT, true).setDefaultValue(new ModelNode().set(500)).setValidator((ParameterValidator)new IntRangeValidator(0, Integer.MAX_VALUE, true, false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition ORB_CONN_CLIENT_TIMEOUT = new SimpleAttributeDefinitionBuilder("client-timeout", ModelType.INT, true).setDefaultValue(new ModelNode().set(0)).setValidator((ParameterValidator)new IntRangeValidator(0, Integer.MAX_VALUE, true, false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition ORB_CONN_SERVER_TIMEOUT = new SimpleAttributeDefinitionBuilder("server-timeout", ModelType.INT, true).setDefaultValue(new ModelNode().set(0)).setValidator((ParameterValidator)new IntRangeValidator(0, Integer.MAX_VALUE, true, false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition ORB_CONN_MAX_SERVER_CONNECTIONS = new SimpleAttributeDefinitionBuilder("max-server-connections", ModelType.INT, true).setDefaultValue(new ModelNode().set(Integer.MAX_VALUE)).setValidator((ParameterValidator)new IntRangeValidator(0, Integer.MAX_VALUE, true, false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition ORB_CONN_MAX_MANAGED_BUF_SIZE = new SimpleAttributeDefinitionBuilder("max-managed-buf-size", ModelType.INT, true).setDefaultValue(new ModelNode().set(24)).setValidator((ParameterValidator)new IntRangeValidator(0, 64, true, false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition ORB_CONN_OUTBUF_SIZE = new SimpleAttributeDefinitionBuilder("outbuf-size", ModelType.INT, true).setDefaultValue(new ModelNode().set(2048)).setValidator((ParameterValidator)new IntRangeValidator(0, 65536, true, false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition ORB_CONN_OUTBUF_CACHE_TIMEOUT = new SimpleAttributeDefinitionBuilder("outbuf-cache-timeout", ModelType.INT, true).setDefaultValue(new ModelNode().set(-1)).setValidator((ParameterValidator)new IntRangeValidator(-1, Integer.MAX_VALUE, true, false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition ORB_INIT_SECURITY = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security", ModelType.STRING, true).setDefaultValue(DEFAULT_DISABLED_PROPERTY).setValidator((ParameterValidator)new EnumValidator(SecurityAllowedValues.class, true, false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).addAccessConstraint((AccessConstraintDefinition)JACORB_SECURITY_DEF)).build();
    public static final SimpleAttributeDefinition ORB_INIT_TX = new SimpleAttributeDefinitionBuilder("transactions", ModelType.STRING, true).setDefaultValue(DEFAULT_DISABLED_PROPERTY).setValidator((ParameterValidator)new EnumValidator(TransactionsAllowedValues.class, true, false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition POA_MONITORING = new SimpleAttributeDefinitionBuilder("monitoring", ModelType.STRING, true).setDefaultValue(DEFAULT_DISABLED_PROPERTY).setValidator(ON_OFF_VALIDATOR).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition POA_QUEUE_WAIT = new SimpleAttributeDefinitionBuilder("queue-wait", ModelType.STRING, true).setDefaultValue(DEFAULT_DISABLED_PROPERTY).setValidator(ON_OFF_VALIDATOR).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition POA_QUEUE_MIN = new SimpleAttributeDefinitionBuilder("queue-min", ModelType.INT, true).setDefaultValue(new ModelNode().set(10)).setValidator((ParameterValidator)new IntRangeValidator(1, 100, true, false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition POA_QUEUE_MAX = new SimpleAttributeDefinitionBuilder("queue-max", ModelType.INT, true).setDefaultValue(new ModelNode().set(100)).setValidator((ParameterValidator)new IntRangeValidator(1, 200, true, false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition POA_REQUEST_PROC_POOL_SIZE = new SimpleAttributeDefinitionBuilder("pool-size", ModelType.INT, true).setDefaultValue(new ModelNode().set(5)).setValidator((ParameterValidator)new IntRangeValidator(1, 100, true, false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition POA_REQUEST_PROC_MAX_THREADS = new SimpleAttributeDefinitionBuilder("max-threads", ModelType.INT, true).setDefaultValue(new ModelNode().set(32)).setValidator((ParameterValidator)new IntRangeValidator(5, 150, true, false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition NAMING_ROOT_CONTEXT = new SimpleAttributeDefinitionBuilder("root-context", ModelType.STRING, true).setDefaultValue(new ModelNode().set("JBoss/Naming/root")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition NAMING_EXPORT_CORBALOC = new SimpleAttributeDefinitionBuilder("export-corbaloc", ModelType.STRING, true).setDefaultValue(DEFAULT_ENABLED_PROPERTY).setValidator(ON_OFF_VALIDATOR).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition INTEROP_SUN = new SimpleAttributeDefinitionBuilder("sun", ModelType.STRING, true).setDefaultValue(DEFAULT_ENABLED_PROPERTY).setValidator(ON_OFF_VALIDATOR).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition INTEROP_COMET = new SimpleAttributeDefinitionBuilder("comet", ModelType.STRING, true).setDefaultValue(DEFAULT_DISABLED_PROPERTY).setValidator(ON_OFF_VALIDATOR).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition INTEROP_IONA = new SimpleAttributeDefinitionBuilder("iona", ModelType.STRING, true).setDefaultValue(DEFAULT_DISABLED_PROPERTY).setValidator(ON_OFF_VALIDATOR).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition INTEROP_CHUNK_RMI_VALUETYPES = new SimpleAttributeDefinitionBuilder("chunk-custom-rmi-valuetypes", ModelType.STRING, true).setDefaultValue(DEFAULT_ENABLED_PROPERTY).setValidator(ON_OFF_VALIDATOR).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition INTEROP_LAX_BOOLEAN_ENCODING = new SimpleAttributeDefinitionBuilder("lax-boolean-encoding", ModelType.STRING, true).setDefaultValue(DEFAULT_DISABLED_PROPERTY).setValidator(ON_OFF_VALIDATOR).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition INTEROP_INDIRECT_ENCODING_DISABLE = new SimpleAttributeDefinitionBuilder("indirection-encoding-disable", ModelType.STRING, true).setDefaultValue(DEFAULT_DISABLED_PROPERTY).setValidator(ON_OFF_VALIDATOR).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition INTEROP_STRICT_CHECK_ON_TC_CREATION = new SimpleAttributeDefinitionBuilder("strict-check-on-tc-creation", ModelType.STRING, true).setDefaultValue(DEFAULT_DISABLED_PROPERTY).setValidator(ON_OFF_VALIDATOR).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition SECURITY_SUPPORT_SSL = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("support-ssl", ModelType.STRING, true).setDefaultValue(DEFAULT_DISABLED_PROPERTY).setValidator(ON_OFF_VALIDATOR).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).addAccessConstraint((AccessConstraintDefinition)JACORB_SECURITY_DEF)).build();
    public static final SimpleAttributeDefinition SECURITY_SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).addAccessConstraint((AccessConstraintDefinition)JACORB_SECURITY_DEF)).build();
    public static final SimpleAttributeDefinition SECURITY_ADD_COMPONENT_INTERCEPTOR = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("add-component-via-interceptor", ModelType.STRING, true).setDefaultValue(DEFAULT_ENABLED_PROPERTY).setValidator(ON_OFF_VALIDATOR).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).addAccessConstraint((AccessConstraintDefinition)JACORB_SECURITY_DEF)).build();
    public static final SimpleAttributeDefinition SECURITY_CLIENT_SUPPORTS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-supports", ModelType.STRING, true).setDefaultValue(new ModelNode().set(SSLConfigValue.MUTUALAUTH.toString())).setValidator(SSL_CONFIG_VALIDATOR).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).addAccessConstraint((AccessConstraintDefinition)JACORB_SECURITY_DEF)).build();
    public static final SimpleAttributeDefinition SECURITY_CLIENT_REQUIRES = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-requires", ModelType.STRING, true).setDefaultValue(new ModelNode().set(SSLConfigValue.NONE.toString())).setValidator(SSL_CONFIG_VALIDATOR).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).addAccessConstraint((AccessConstraintDefinition)JACORB_SECURITY_DEF)).build();
    public static final SimpleAttributeDefinition SECURITY_SERVER_SUPPORTS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("server-supports", ModelType.STRING, true).setDefaultValue(new ModelNode().set(SSLConfigValue.MUTUALAUTH.toString())).setValidator(SSL_CONFIG_VALIDATOR).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).addAccessConstraint((AccessConstraintDefinition)JACORB_SECURITY_DEF)).build();
    public static final SimpleAttributeDefinition SECURITY_SERVER_REQUIRES = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("server-requires", ModelType.STRING, true).setDefaultValue(new ModelNode().set(SSLConfigValue.NONE.toString())).setValidator(SSL_CONFIG_VALIDATOR).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).addAccessConstraint((AccessConstraintDefinition)JACORB_SECURITY_DEF)).build();
    public static final PropertiesAttributeDefinition PROPERTIES = ((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("properties", true).setAllowExpression(true)).build();
    static final List<SimpleAttributeDefinition> ORB_ATTRIBUTES = Arrays.asList(ORB_NAME, ORB_PRINT_VERSION, ORB_USE_IMR, ORB_USE_BOM, ORB_CACHE_TYPECODES, ORB_CACHE_POA_NAMES, ORB_GIOP_MINOR_VERSION, ORB_SOCKET_BINDING, ORB_SSL_SOCKET_BINDING);
    static final List<SimpleAttributeDefinition> ORB_CONN_ATTRIBUTES = Arrays.asList(ORB_CONN_RETRIES, ORB_CONN_RETRY_INTERVAL, ORB_CONN_CLIENT_TIMEOUT, ORB_CONN_SERVER_TIMEOUT, ORB_CONN_MAX_SERVER_CONNECTIONS, ORB_CONN_MAX_MANAGED_BUF_SIZE, ORB_CONN_OUTBUF_SIZE, ORB_CONN_OUTBUF_CACHE_TIMEOUT);
    static final List<SimpleAttributeDefinition> ORB_INIT_ATTRIBUTES = Arrays.asList(ORB_INIT_SECURITY, ORB_INIT_TX);
    static final List<SimpleAttributeDefinition> POA_ATTRIBUTES = Arrays.asList(POA_MONITORING, POA_QUEUE_WAIT, POA_QUEUE_MIN, POA_QUEUE_MAX);
    static final List<SimpleAttributeDefinition> POA_RP_ATTRIBUTES = Arrays.asList(POA_REQUEST_PROC_POOL_SIZE, POA_REQUEST_PROC_MAX_THREADS);
    static final List<SimpleAttributeDefinition> NAMING_ATTRIBUTES = Arrays.asList(NAMING_ROOT_CONTEXT, NAMING_EXPORT_CORBALOC);
    static final List<SimpleAttributeDefinition> INTEROP_ATTRIBUTES = Arrays.asList(INTEROP_SUN, INTEROP_COMET, INTEROP_IONA, INTEROP_CHUNK_RMI_VALUETYPES, INTEROP_LAX_BOOLEAN_ENCODING, INTEROP_INDIRECT_ENCODING_DISABLE, INTEROP_STRICT_CHECK_ON_TC_CREATION);
    static final List<SimpleAttributeDefinition> SECURITY_ATTRIBUTES = Arrays.asList(SECURITY_SUPPORT_SSL, SECURITY_SECURITY_DOMAIN, SECURITY_ADD_COMPONENT_INTERCEPTOR, SECURITY_CLIENT_SUPPORTS, SECURITY_CLIENT_REQUIRES, SECURITY_SERVER_SUPPORTS, SECURITY_SERVER_REQUIRES);
    static final List<SimpleAttributeDefinition> SSL_CONFIG_ATTRIBUTES = Arrays.asList(SECURITY_CLIENT_SUPPORTS, SECURITY_CLIENT_REQUIRES, SECURITY_SERVER_SUPPORTS, SECURITY_SERVER_REQUIRES);
    static final List<AttributeDefinition> SUBSYSTEM_ATTRIBUTES = new ArrayList<AttributeDefinition>();
    static final Map<String, AttributeDefinition> ATTRIBUTES_BY_NAME;

    JacORBSubsystemDefinitions() {
    }

    public static AttributeDefinition valueOf(String attributeNAme) {
        return ATTRIBUTES_BY_NAME.get(attributeNAme);
    }

    static {
        SUBSYSTEM_ATTRIBUTES.addAll(ORB_ATTRIBUTES);
        SUBSYSTEM_ATTRIBUTES.addAll(ORB_CONN_ATTRIBUTES);
        SUBSYSTEM_ATTRIBUTES.addAll(ORB_INIT_ATTRIBUTES);
        SUBSYSTEM_ATTRIBUTES.addAll(POA_ATTRIBUTES);
        SUBSYSTEM_ATTRIBUTES.addAll(POA_RP_ATTRIBUTES);
        SUBSYSTEM_ATTRIBUTES.addAll(NAMING_ATTRIBUTES);
        SUBSYSTEM_ATTRIBUTES.addAll(INTEROP_ATTRIBUTES);
        SUBSYSTEM_ATTRIBUTES.addAll(SECURITY_ATTRIBUTES);
        SUBSYSTEM_ATTRIBUTES.add((AttributeDefinition)PROPERTIES);
        HashMap<String, AttributeDefinition> map = new HashMap<String, AttributeDefinition>();
        for (AttributeDefinition attribute : SUBSYSTEM_ATTRIBUTES) {
            map.put(attribute.getName(), attribute);
        }
        ATTRIBUTES_BY_NAME = map;
    }
}

