/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.List;
import org.infinispan.CacheException;
import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.configuration.cache.CacheStoreConfiguration;
import org.infinispan.configuration.cache.CompatibilityModeConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.configuration.cache.CustomInterceptorsConfiguration;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.interceptors.ActivationInterceptor;
import org.infinispan.interceptors.BatchingInterceptor;
import org.infinispan.interceptors.CacheLoaderInterceptor;
import org.infinispan.interceptors.CacheMgmtInterceptor;
import org.infinispan.interceptors.CacheStoreInterceptor;
import org.infinispan.interceptors.CallInterceptor;
import org.infinispan.interceptors.ClusteredActivationInterceptor;
import org.infinispan.interceptors.ClusteredCacheLoaderInterceptor;
import org.infinispan.interceptors.DeadlockDetectingInterceptor;
import org.infinispan.interceptors.DefensiveMarshalledValueInterceptor;
import org.infinispan.interceptors.DistCacheStoreInterceptor;
import org.infinispan.interceptors.EntryWrappingInterceptor;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.InvalidationInterceptor;
import org.infinispan.interceptors.InvocationContextInterceptor;
import org.infinispan.interceptors.IsMarshallableInterceptor;
import org.infinispan.interceptors.MarshalledValueInterceptor;
import org.infinispan.interceptors.NotificationInterceptor;
import org.infinispan.interceptors.PassivationInterceptor;
import org.infinispan.interceptors.TxInterceptor;
import org.infinispan.interceptors.VersionedEntryWrappingInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.compat.TypeConverterInterceptor;
import org.infinispan.interceptors.distribution.L1NonTxInterceptor;
import org.infinispan.interceptors.distribution.NonTxDistributionInterceptor;
import org.infinispan.interceptors.distribution.TxDistributionInterceptor;
import org.infinispan.interceptors.distribution.VersionedDistributionInterceptor;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;
import org.infinispan.interceptors.locking.OptimisticLockingInterceptor;
import org.infinispan.interceptors.locking.PessimisticLockingInterceptor;
import org.infinispan.interceptors.totalorder.TotalOrderDistributionInterceptor;
import org.infinispan.interceptors.totalorder.TotalOrderInterceptor;
import org.infinispan.interceptors.totalorder.TotalOrderStateTransferInterceptor;
import org.infinispan.interceptors.totalorder.TotalOrderVersionedDistributionInterceptor;
import org.infinispan.interceptors.totalorder.TotalOrderVersionedEntryWrappingInterceptor;
import org.infinispan.interceptors.xsite.NonTransactionalBackupInterceptor;
import org.infinispan.interceptors.xsite.OptimisticBackupInterceptor;
import org.infinispan.interceptors.xsite.PessimisticBackupInterceptor;
import org.infinispan.statetransfer.StateTransferInterceptor;
import org.infinispan.statetransfer.TransactionSynchronizerInterceptor;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.ReflectionUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@DefaultFactoryFor(classes={InterceptorChain.class})
public class InterceptorChainFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    private static final Log log = LogFactory.getLog(InterceptorChainFactory.class);

    private CommandInterceptor createInterceptor(CommandInterceptor interceptor, Class<? extends CommandInterceptor> interceptorType) {
        CommandInterceptor chainedInterceptor = this.componentRegistry.getComponent(interceptorType);
        if (chainedInterceptor == null) {
            chainedInterceptor = interceptor;
            this.register(interceptorType, chainedInterceptor);
        } else {
            chainedInterceptor.setNext(null);
        }
        return chainedInterceptor;
    }

    private void register(Class<? extends CommandInterceptor> clazz, CommandInterceptor chainedInterceptor) {
        try {
            this.componentRegistry.registerComponent((Object)chainedInterceptor, clazz);
        }
        catch (RuntimeException e) {
            log.warn("Problems creating interceptor " + clazz);
            throw e;
        }
    }

    private boolean isUsingMarshalledValues(Configuration c) {
        return c.storeAsBinary().enabled() && (c.storeAsBinary().storeKeysAsBinary() || c.storeAsBinary().storeValuesAsBinary());
    }

    public InterceptorChain buildInterceptorChain() {
        boolean needsVersionAwareComponents = this.configuration.transaction().transactionMode().isTransactional() && Configurations.isVersioningEnabled(this.configuration);
        InterceptorChain interceptorChain = new InterceptorChain(this.componentRegistry.getComponentMetadataRepo());
        this.componentRegistry.registerComponent((Object)interceptorChain, InterceptorChain.class);
        boolean invocationBatching = this.configuration.invocationBatching().enabled();
        boolean isTotalOrder = this.configuration.transaction().transactionProtocol().isTotalOrder();
        if (invocationBatching) {
            interceptorChain.setFirstInChain(this.createInterceptor(new BatchingInterceptor(), BatchingInterceptor.class));
        } else {
            interceptorChain.setFirstInChain(this.createInterceptor(new InvocationContextInterceptor(), InvocationContextInterceptor.class));
        }
        CompatibilityModeConfiguration compatibility = this.configuration.compatibility();
        if (compatibility.enabled()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new TypeConverterInterceptor(compatibility.marshaller()), TypeConverterInterceptor.class), false);
        }
        if (this.isUsingMarshalledValues(this.configuration) || this.configuration.clustering().async().asyncMarshalling() || this.configuration.clustering().async().useReplQueue() || this.hasAsyncStore()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new IsMarshallableInterceptor(), IsMarshallableInterceptor.class), false);
        }
        if (invocationBatching) {
            interceptorChain.appendInterceptor(this.createInterceptor(new InvocationContextInterceptor(), InvocationContextInterceptor.class), false);
        }
        interceptorChain.appendInterceptor(this.createInterceptor(new CacheMgmtInterceptor(), CacheMgmtInterceptor.class), false);
        if (this.configuration.clustering().cacheMode().isDistributed() || this.configuration.clustering().cacheMode().isReplicated()) {
            if (isTotalOrder) {
                interceptorChain.appendInterceptor(this.createInterceptor(new TotalOrderStateTransferInterceptor(), TotalOrderStateTransferInterceptor.class), false);
            } else {
                interceptorChain.appendInterceptor(this.createInterceptor(new StateTransferInterceptor(), StateTransferInterceptor.class), false);
            }
            interceptorChain.appendInterceptor(this.createInterceptor(new TransactionSynchronizerInterceptor(), TransactionSynchronizerInterceptor.class), false);
        }
        if (isTotalOrder) {
            interceptorChain.appendInterceptor(this.createInterceptor(new TotalOrderInterceptor(), TotalOrderInterceptor.class), false);
        }
        if (this.configuration.transaction().transactionMode().isTransactional()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new TxInterceptor(), TxInterceptor.class), false);
        }
        if (this.isUsingMarshalledValues(this.configuration)) {
            CommandInterceptor interceptor = this.configuration.storeAsBinary().defensive() ? this.createInterceptor(new DefensiveMarshalledValueInterceptor(), DefensiveMarshalledValueInterceptor.class) : this.createInterceptor(new MarshalledValueInterceptor(), MarshalledValueInterceptor.class);
            interceptorChain.appendInterceptor(interceptor, false);
        }
        interceptorChain.appendInterceptor(this.createInterceptor(new NotificationInterceptor(), NotificationInterceptor.class), false);
        if (this.configuration.transaction().useEagerLocking()) {
            this.configuration.transaction().lockingMode(LockingMode.PESSIMISTIC);
        }
        if (!isTotalOrder) {
            if (this.configuration.transaction().transactionMode().isTransactional()) {
                if (this.configuration.transaction().lockingMode() == LockingMode.PESSIMISTIC) {
                    interceptorChain.appendInterceptor(this.createInterceptor(new PessimisticLockingInterceptor(), PessimisticLockingInterceptor.class), false);
                } else {
                    interceptorChain.appendInterceptor(this.createInterceptor(new OptimisticLockingInterceptor(), OptimisticLockingInterceptor.class), false);
                }
            } else {
                interceptorChain.appendInterceptor(this.createInterceptor(new NonTransactionalLockingInterceptor(), NonTransactionalLockingInterceptor.class), false);
            }
        }
        if (this.configuration.sites().hasEnabledBackups() && !this.configuration.sites().disableBackups()) {
            if (this.configuration.transaction().transactionMode() == TransactionMode.TRANSACTIONAL) {
                if (this.configuration.transaction().lockingMode() == LockingMode.OPTIMISTIC) {
                    interceptorChain.appendInterceptor(this.createInterceptor(new OptimisticBackupInterceptor(), OptimisticBackupInterceptor.class), false);
                } else {
                    interceptorChain.appendInterceptor(this.createInterceptor(new PessimisticBackupInterceptor(), PessimisticBackupInterceptor.class), false);
                }
            } else {
                interceptorChain.appendInterceptor(this.createInterceptor(new NonTransactionalBackupInterceptor(), NonTransactionalBackupInterceptor.class), false);
            }
        }
        if (needsVersionAwareComponents && this.configuration.clustering().cacheMode().isClustered()) {
            if (isTotalOrder) {
                interceptorChain.appendInterceptor(this.createInterceptor(new TotalOrderVersionedEntryWrappingInterceptor(), TotalOrderVersionedEntryWrappingInterceptor.class), false);
            } else {
                interceptorChain.appendInterceptor(this.createInterceptor(new VersionedEntryWrappingInterceptor(), VersionedEntryWrappingInterceptor.class), false);
            }
        } else {
            interceptorChain.appendInterceptor(this.createInterceptor(new EntryWrappingInterceptor(), EntryWrappingInterceptor.class), false);
        }
        if (this.configuration.loaders().usingCacheLoaders()) {
            if (this.configuration.loaders().passivation()) {
                if (this.configuration.clustering().cacheMode().isClustered()) {
                    interceptorChain.appendInterceptor(this.createInterceptor(new ClusteredActivationInterceptor(), ClusteredActivationInterceptor.class), false);
                } else {
                    interceptorChain.appendInterceptor(this.createInterceptor(new ActivationInterceptor(), ActivationInterceptor.class), false);
                }
                interceptorChain.appendInterceptor(this.createInterceptor(new PassivationInterceptor(), PassivationInterceptor.class), false);
            } else {
                if (this.configuration.clustering().cacheMode().isClustered()) {
                    interceptorChain.appendInterceptor(this.createInterceptor(new ClusteredCacheLoaderInterceptor(), ClusteredCacheLoaderInterceptor.class), false);
                } else {
                    interceptorChain.appendInterceptor(this.createInterceptor(new CacheLoaderInterceptor(), CacheLoaderInterceptor.class), false);
                }
                switch (this.configuration.clustering().cacheMode()) {
                    case DIST_SYNC: 
                    case DIST_ASYNC: 
                    case REPL_SYNC: 
                    case REPL_ASYNC: {
                        interceptorChain.appendInterceptor(this.createInterceptor(new DistCacheStoreInterceptor(), DistCacheStoreInterceptor.class), false);
                        break;
                    }
                    default: {
                        interceptorChain.appendInterceptor(this.createInterceptor(new CacheStoreInterceptor(), CacheStoreInterceptor.class), false);
                    }
                }
            }
        }
        if (this.configuration.deadlockDetection().enabled() && !isTotalOrder) {
            interceptorChain.appendInterceptor(this.createInterceptor(new DeadlockDetectingInterceptor(), DeadlockDetectingInterceptor.class), false);
        }
        if (this.configuration.clustering().l1().enabled() && !this.configuration.transaction().transactionMode().isTransactional()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new L1NonTxInterceptor(), L1NonTxInterceptor.class), false);
        }
        switch (this.configuration.clustering().cacheMode()) {
            case INVALIDATION_SYNC: 
            case INVALIDATION_ASYNC: {
                interceptorChain.appendInterceptor(this.createInterceptor(new InvalidationInterceptor(), InvalidationInterceptor.class), false);
                break;
            }
            case DIST_SYNC: 
            case REPL_SYNC: {
                if (needsVersionAwareComponents) {
                    if (isTotalOrder) {
                        interceptorChain.appendInterceptor(this.createInterceptor(new TotalOrderVersionedDistributionInterceptor(), TotalOrderVersionedDistributionInterceptor.class), false);
                        break;
                    }
                    interceptorChain.appendInterceptor(this.createInterceptor(new VersionedDistributionInterceptor(), VersionedDistributionInterceptor.class), false);
                    break;
                }
            }
            case DIST_ASYNC: 
            case REPL_ASYNC: {
                if (this.configuration.transaction().transactionMode().isTransactional()) {
                    if (isTotalOrder) {
                        interceptorChain.appendInterceptor(this.createInterceptor(new TotalOrderDistributionInterceptor(), TotalOrderDistributionInterceptor.class), false);
                        break;
                    }
                    interceptorChain.appendInterceptor(this.createInterceptor(new TxDistributionInterceptor(), TxDistributionInterceptor.class), false);
                    break;
                }
                interceptorChain.appendInterceptor(this.createInterceptor(new NonTxDistributionInterceptor(), NonTxDistributionInterceptor.class), false);
                break;
            }
        }
        CommandInterceptor callInterceptor = this.createInterceptor(new CallInterceptor(), CallInterceptor.class);
        interceptorChain.appendInterceptor(callInterceptor, false);
        log.trace("Finished building default interceptor chain.");
        this.buildCustomInterceptors(interceptorChain, this.configuration.customInterceptors());
        return interceptorChain;
    }

    private void buildCustomInterceptors(InterceptorChain interceptorChain, CustomInterceptorsConfiguration customInterceptors) {
        for (InterceptorConfiguration config : customInterceptors.interceptors()) {
            List<CommandInterceptor> withClassName;
            if (interceptorChain.containsInterceptorType(config.interceptor().getClass())) continue;
            CommandInterceptor customInterceptor = config.interceptor();
            ReflectionUtil.applyProperties(customInterceptor, config.properties());
            this.register(customInterceptor.getClass(), customInterceptor);
            if (config.first()) {
                interceptorChain.addInterceptor(customInterceptor, 0);
                continue;
            }
            if (config.last()) {
                interceptorChain.appendInterceptor(customInterceptor, true);
                continue;
            }
            if (config.index() >= 0) {
                interceptorChain.addInterceptor(customInterceptor, config.index());
                continue;
            }
            if (config.after() != null) {
                withClassName = interceptorChain.getInterceptorsWithClass(config.after());
                if (withClassName.isEmpty()) {
                    throw new ConfigurationException("Cannot add after class: " + config.after() + " as no such interceptor exists in the default chain");
                }
                interceptorChain.addInterceptorAfter(customInterceptor, withClassName.get(0).getClass());
                continue;
            }
            if (config.before() == null) continue;
            withClassName = interceptorChain.getInterceptorsWithClass(config.before());
            if (withClassName.isEmpty()) {
                throw new ConfigurationException("Cannot add before class: " + config.after() + " as no such interceptor exists in the default chain");
            }
            interceptorChain.addInterceptorBefore(customInterceptor, withClassName.get(0).getClass());
        }
    }

    private boolean hasAsyncStore() {
        List<CacheLoaderConfiguration> loaderConfigs = this.configuration.loaders().cacheLoaders();
        for (CacheLoaderConfiguration loaderConfig : loaderConfigs) {
            if (!(loaderConfig instanceof CacheStoreConfiguration) || !((CacheStoreConfiguration)loaderConfig).async().enabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T construct(Class<T> componentType) {
        try {
            return componentType.cast(this.buildInterceptorChain());
        }
        catch (CacheException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to build interceptor chain", e);
        }
    }

    public static InterceptorChainFactory getInstance(ComponentRegistry componentRegistry, Configuration configuration) {
        InterceptorChainFactory icf = new InterceptorChainFactory();
        icf.componentRegistry = componentRegistry;
        icf.configuration = configuration;
        return icf;
    }
}

