/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Map;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.CacheStoreInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DistCacheStoreInterceptor
extends CacheStoreInterceptor {
    private DistributionManager dm;
    private Transport transport;
    private Address address;
    private static final Log log = LogFactory.getLog(DistCacheStoreInterceptor.class);
    private boolean isUsingLockDelegation;
    private ClusteringDependentLogic cdl;

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void inject(DistributionManager dm, Transport transport, ClusteringDependentLogic cdl) {
        this.dm = dm;
        this.transport = transport;
        this.cdl = cdl;
    }

    @Start(priority=25)
    private void setAddress() {
        this.address = this.transport.getAddress();
        this.isUsingLockDelegation = !this.cacheConfiguration.transaction().transactionMode().isTransactional();
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        Object key = command.getKey();
        if (!this.isStoreEnabled(command) || ctx.isInTxScope() || !command.isSuccessful()) {
            return returnValue;
        }
        if (!this.isProperWriter(ctx, command, command.getKey())) {
            return returnValue;
        }
        InternalCacheEntry se = this.getStoredEntry(key, ctx);
        this.store.store(se);
        log.tracef("Stored entry %s under key %s", se, key);
        if (this.getStatisticsEnabled()) {
            this.cacheStores.incrementAndGet();
        }
        return returnValue;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (!this.isStoreEnabled(command) || ctx.isInTxScope()) {
            return returnValue;
        }
        Map<Object, Object> map = command.getMap();
        int count = 0;
        for (Object key : map.keySet()) {
            if (this.isUsingLockDelegation && command.isForwarded() && !this.dm.getPrimaryLocation(key).equals(ctx.getOrigin()) || !this.isProperWriter(ctx, command, key)) continue;
            InternalCacheEntry se = this.getStoredEntry(key, ctx);
            this.store.store(se);
            log.tracef("Stored entry %s under key %s", se, key);
            ++count;
        }
        if (this.getStatisticsEnabled()) {
            this.cacheStores.getAndAdd(count);
        }
        return returnValue;
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        Object key = command.getKey();
        if (!this.isStoreEnabled(command) || ctx.isInTxScope() || !command.isSuccessful()) {
            return retval;
        }
        if (!this.isProperWriter(ctx, command, key)) {
            return retval;
        }
        boolean resp = this.store.remove(key);
        log.tracef("Removed entry under key %s and got response %s from CacheStore", key, resp);
        return retval;
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        Object key = command.getKey();
        if (!this.isStoreEnabled(command) || ctx.isInTxScope() || !command.isSuccessful()) {
            return returnValue;
        }
        if (!this.isProperWriter(ctx, command, command.getKey())) {
            return returnValue;
        }
        InternalCacheEntry se = this.getStoredEntry(key, ctx);
        this.store.store(se);
        log.tracef("Stored entry %s under key %s", se, key);
        if (this.getStatisticsEnabled()) {
            this.cacheStores.incrementAndGet();
        }
        return returnValue;
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (this.isStoreEnabled()) {
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace("Transactional so don't put stuff in the cache store yet.");
            }
            this.prepareCacheLoader(ctx, command.getGlobalTransaction(), ctx, command.isOnePhaseCommit());
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (this.isStoreEnabled(command) && !ctx.isInTxScope() && this.isProperWriterForClear(ctx)) {
            this.clearCacheStore();
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    protected boolean isProperWriter(InvocationContext ctx, FlagAffectedCommand command, Object key) {
        if (command.hasFlag(Flag.SKIP_OWNERSHIP_CHECK)) {
            return true;
        }
        if (this.loaderConfig.shared()) {
            if (!this.dm.getPrimaryLocation(key).equals(this.address)) {
                log.tracef("Skipping cache store since the cache loader is shared and the caller is not the first owner of the key %s", key);
                return false;
            }
        } else {
            if (this.isUsingLockDelegation && !command.hasFlag(Flag.CACHE_MODE_LOCAL) && ctx.isOriginLocal() && !this.dm.getPrimaryLocation(key).equals(this.address)) {
                log.tracef("Skipping cache store on the originator because it is not the primary owner of key %s", key);
                return false;
            }
            if (!this.dm.getWriteConsistentHash().isKeyLocalToNode(this.address, key)) {
                log.tracef("Skipping cache store since the key is not local: %s", key);
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean isProperWriterForClear(InvocationContext ctx) {
        return !this.loaderConfig.shared() || ctx.isOriginLocal();
    }
}

