/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.schemagen;

import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.PersistenceException;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.dialect.spi.DatabaseInfoDialectResolver;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolver;
import org.hibernate.engine.jdbc.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jpa.SchemaGenAction;
import org.hibernate.jpa.SchemaGenSource;
import org.hibernate.jpa.internal.schemagen.GenerationSource;
import org.hibernate.jpa.internal.schemagen.GenerationSourceFromMetadata;
import org.hibernate.jpa.internal.schemagen.GenerationSourceFromScript;
import org.hibernate.jpa.internal.schemagen.GenerationTarget;
import org.hibernate.jpa.internal.schemagen.GenerationTargetToDatabase;
import org.hibernate.jpa.internal.schemagen.GenerationTargetToScript;
import org.hibernate.jpa.internal.schemagen.JdbcConnectionContext;
import org.hibernate.jpa.internal.schemagen.ScriptSourceInput;
import org.hibernate.jpa.internal.schemagen.ScriptSourceInputFromFile;
import org.hibernate.jpa.internal.schemagen.ScriptSourceInputFromReader;
import org.hibernate.jpa.internal.schemagen.ScriptSourceInputFromUrl;
import org.hibernate.jpa.internal.schemagen.ScriptTargetOutput;
import org.hibernate.jpa.internal.schemagen.ScriptTargetOutputToFile;
import org.hibernate.jpa.internal.schemagen.ScriptTargetOutputToUrl;
import org.hibernate.jpa.internal.schemagen.ScriptTargetOutputToWriter;
import org.hibernate.mapping.Table;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.ImportSqlCommandExtractor;
import org.jboss.logging.Logger;

public class JpaSchemaGenerator {
    private static final Logger log = Logger.getLogger(JpaSchemaGenerator.class);

    private JpaSchemaGenerator() {
    }

    public static void performGeneration(Configuration hibernateConfiguration, ServiceRegistry serviceRegistry) {
        new Generation(serviceRegistry).execute(hibernateConfiguration);
    }

    private static JdbcConnectionContext determineAppropriateJdbcConnectionContext(Configuration hibernateConfiguration, ServiceRegistry serviceRegistry) {
        SqlStatementLogger sqlStatementLogger = ((JdbcServices)serviceRegistry.getService(JdbcServices.class)).getSqlStatementLogger();
        Connection providedConnection = (Connection)hibernateConfiguration.getProperties().get("javax.persistence.schema-generation-connection");
        if (providedConnection != null) {
            return new JdbcConnectionContext(new ProvidedJdbcConnectionAccess(providedConnection), sqlStatementLogger);
        }
        ConnectionProvider connectionProvider = (ConnectionProvider)serviceRegistry.getService(ConnectionProvider.class);
        if (connectionProvider != null) {
            return new JdbcConnectionContext(new ConnectionProviderJdbcConnectionAccess(connectionProvider), sqlStatementLogger);
        }
        return new JdbcConnectionContext(null, sqlStatementLogger){

            @Override
            public Connection getJdbcConnection() {
                throw new PersistenceException("No connection information supplied");
            }
        };
    }

    private static Dialect determineDialect(JdbcConnectionContext jdbcConnectionContext, Configuration hibernateConfiguration, ServiceRegistry serviceRegistry) {
        final String explicitDbName = hibernateConfiguration.getProperty("javax.persistence.database-product-name");
        final String explicitDbMajor = hibernateConfiguration.getProperty("javax.persistence.database-major-version");
        final String explicitDbMinor = hibernateConfiguration.getProperty("javax.persistence.database-minor-version");
        if (StringHelper.isNotEmpty((String)explicitDbName)) {
            ((DatabaseInfoDialectResolver)serviceRegistry.getService(DatabaseInfoDialectResolver.class)).resolve(new DatabaseInfoDialectResolver.DatabaseInfo(){

                public String getDatabaseName() {
                    return explicitDbName;
                }

                public int getDatabaseMajorVersion() {
                    return StringHelper.isEmpty((String)explicitDbMajor) ? -9999 : Integer.parseInt(explicitDbMajor);
                }

                public int getDatabaseMinorVersion() {
                    return StringHelper.isEmpty((String)explicitDbMinor) ? -9999 : Integer.parseInt(explicitDbMinor);
                }
            });
        }
        return JpaSchemaGenerator.buildDialect(hibernateConfiguration, serviceRegistry, jdbcConnectionContext);
    }

    private static Dialect buildDialect(Configuration hibernateConfiguration, ServiceRegistry serviceRegistry, JdbcConnectionContext jdbcConnectionContext) {
        String dialectName = hibernateConfiguration.getProperty("hibernate.dialect");
        if (dialectName != null) {
            return JpaSchemaGenerator.constructDialect(dialectName, serviceRegistry);
        }
        return JpaSchemaGenerator.determineDialectBasedOnJdbcMetadata(jdbcConnectionContext, serviceRegistry);
    }

    private static Dialect constructDialect(String dialectName, ServiceRegistry serviceRegistry) {
        StrategySelector strategySelector = (StrategySelector)serviceRegistry.getService(StrategySelector.class);
        try {
            Dialect dialect = (Dialect)strategySelector.resolveStrategy(Dialect.class, (Object)dialectName);
            if (dialect == null) {
                throw new HibernateException("Unable to construct requested dialect [" + dialectName + "]");
            }
            return dialect;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HibernateException("Unable to construct requested dialect [" + dialectName + "]", (Throwable)e);
        }
    }

    private static Dialect determineDialectBasedOnJdbcMetadata(JdbcConnectionContext jdbcConnectionContext, ServiceRegistry serviceRegistry) {
        DialectResolver dialectResolver = (DialectResolver)serviceRegistry.getService(DialectResolver.class);
        try {
            DatabaseMetaData databaseMetaData = jdbcConnectionContext.getJdbcConnection().getMetaData();
            Dialect dialect = dialectResolver.resolveDialect(databaseMetaData);
            if (dialect == null) {
                throw new HibernateException("Unable to determine Dialect to use [name=" + databaseMetaData.getDatabaseProductName() + ", majorVersion=" + databaseMetaData.getDatabaseMajorVersion() + "]; user must register resolver or explicitly set 'hibernate.dialect'");
            }
            return dialect;
        }
        catch (SQLException sqlException) {
            throw new HibernateException("Unable to access java.sql.DatabaseMetaData to determine appropriate Dialect to use", (Throwable)sqlException);
        }
    }

    private static void doGeneration(List<GenerationSource> createSourceList, List<GenerationSource> dropSourceList, List<GenerationTarget> targets) {
        for (GenerationTarget target : targets) {
            for (GenerationSource source : dropSourceList) {
                target.acceptDropCommands(source.getCommands());
            }
            for (GenerationSource source : createSourceList) {
                target.acceptCreateCommands(source.getCommands());
            }
        }
    }

    private static void releaseSources(List<GenerationSource> generationSourceList) {
        for (GenerationSource source : generationSourceList) {
            try {
                source.release();
            }
            catch (Exception e) {
                log.debug((Object)("Problem releasing generation source : " + e.toString()));
            }
        }
    }

    private static void releaseTargets(List<GenerationTarget> generationTargetList) {
        for (GenerationTarget target : generationTargetList) {
            try {
                target.release();
            }
            catch (Exception e) {
                log.debug((Object)("Problem releasing generation target : " + e.toString()));
            }
        }
    }

    private static void releaseJdbcConnectionContext(JdbcConnectionContext jdbcConnectionContext) {
        try {
            jdbcConnectionContext.release();
        }
        catch (Exception e) {
            log.debug((Object)"Unable to release JDBC connection after generation");
        }
    }

    private static class ConnectionProviderJdbcConnectionAccess
    implements JdbcConnectionAccess {
        private final ConnectionProvider connectionProvider;
        private final Connection jdbcConnection;
        private final boolean wasInitiallyAutoCommit;

        private ConnectionProviderJdbcConnectionAccess(ConnectionProvider connectionProvider) {
            boolean wasInitiallyAutoCommit;
            block6: {
                this.connectionProvider = connectionProvider;
                try {
                    this.jdbcConnection = connectionProvider.getConnection();
                }
                catch (SQLException e) {
                    throw new PersistenceException("Unable to obtain JDBC Connection", (Throwable)e);
                }
                try {
                    wasInitiallyAutoCommit = this.jdbcConnection.getAutoCommit();
                    if (wasInitiallyAutoCommit) break block6;
                    try {
                        this.jdbcConnection.setAutoCommit(true);
                    }
                    catch (SQLException e) {
                        throw new PersistenceException(String.format("Could not set provided connection [%s] to auto-commit mode (needed for schema generation)", this.jdbcConnection), (Throwable)e);
                    }
                }
                catch (SQLException ignore) {
                    wasInitiallyAutoCommit = false;
                }
            }
            log.debugf("wasInitiallyAutoCommit=%s", (Object)wasInitiallyAutoCommit);
            this.wasInitiallyAutoCommit = wasInitiallyAutoCommit;
        }

        public Connection obtainConnection() throws SQLException {
            return this.jdbcConnection;
        }

        public void releaseConnection(Connection connection) throws SQLException {
            if (connection != this.jdbcConnection) {
                throw new PersistenceException(String.format("Connection [%s] passed back to %s was not the one obtained [%s] from it", connection, ConnectionProviderJdbcConnectionAccess.class.getName(), this.jdbcConnection));
            }
            if (!this.wasInitiallyAutoCommit) {
                try {
                    if (this.jdbcConnection.getAutoCommit()) {
                        this.jdbcConnection.setAutoCommit(false);
                    }
                }
                catch (SQLException e) {
                    log.info((Object)"Was unable to reset JDBC connection to no longer be in auto-commit mode");
                }
            }
            this.connectionProvider.closeConnection(this.jdbcConnection);
        }

        public boolean supportsAggressiveRelease() {
            return false;
        }
    }

    private static class ProvidedJdbcConnectionAccess
    implements JdbcConnectionAccess {
        private final Connection jdbcConnection;
        private final boolean wasInitiallyAutoCommit;

        private ProvidedJdbcConnectionAccess(Connection jdbcConnection) {
            boolean wasInitiallyAutoCommit;
            block4: {
                this.jdbcConnection = jdbcConnection;
                try {
                    wasInitiallyAutoCommit = jdbcConnection.getAutoCommit();
                    if (wasInitiallyAutoCommit) break block4;
                    try {
                        jdbcConnection.setAutoCommit(true);
                    }
                    catch (SQLException e) {
                        throw new PersistenceException(String.format("Could not set provided connection [%s] to auto-commit mode (needed for schema generation)", jdbcConnection), (Throwable)e);
                    }
                }
                catch (SQLException ignore) {
                    wasInitiallyAutoCommit = false;
                }
            }
            log.debugf("wasInitiallyAutoCommit=%s", (Object)wasInitiallyAutoCommit);
            this.wasInitiallyAutoCommit = wasInitiallyAutoCommit;
        }

        public Connection obtainConnection() throws SQLException {
            return this.jdbcConnection;
        }

        public void releaseConnection(Connection connection) throws SQLException {
            if (!this.wasInitiallyAutoCommit) {
                try {
                    if (this.jdbcConnection.getAutoCommit()) {
                        this.jdbcConnection.setAutoCommit(false);
                    }
                }
                catch (SQLException e) {
                    log.info((Object)"Was unable to reset JDBC connection to no longer be in auto-commit mode");
                }
            }
        }

        public boolean supportsAggressiveRelease() {
            return false;
        }
    }

    private static class ImportScriptSource
    implements GenerationSource {
        private final ScriptSourceInput sourceReader;
        private final ImportSqlCommandExtractor scriptCommandExtractor;

        public ImportScriptSource(ScriptSourceInput sourceReader, ImportSqlCommandExtractor scriptCommandExtractor) {
            this.sourceReader = sourceReader;
            this.scriptCommandExtractor = scriptCommandExtractor;
        }

        @Override
        public Iterable<String> getCommands() {
            return this.sourceReader.read(this.scriptCommandExtractor);
        }

        @Override
        public void release() {
            this.sourceReader.release();
        }
    }

    private static class CreateSchemaCommandSource
    implements GenerationSource {
        private final List<String> commands;

        private CreateSchemaCommandSource(Configuration hibernateConfiguration, Dialect dialect) {
            HashSet<String> schemas = new HashSet<String>();
            Iterator tables = hibernateConfiguration.getTableMappings();
            while (tables.hasNext()) {
                Table table = (Table)tables.next();
                schemas.add(table.getSchema());
            }
            if (schemas.isEmpty()) {
                this.commands = Collections.emptyList();
                return;
            }
            this.commands = new ArrayList<String>();
            for (String schema : schemas) {
                this.commands.add(dialect.getCreateSchemaCommand(schema));
            }
        }

        @Override
        public Iterable<String> getCommands() {
            return this.commands;
        }

        @Override
        public void release() {
        }
    }

    public static class Generation {
        private final ServiceRegistry serviceRegistry;
        private final ImportSqlCommandExtractor scriptCommandExtractor;
        private final ClassLoaderService classLoaderService;

        public Generation(ServiceRegistry serviceRegistry) {
            this.serviceRegistry = serviceRegistry;
            this.scriptCommandExtractor = (ImportSqlCommandExtractor)serviceRegistry.getService(ImportSqlCommandExtractor.class);
            this.classLoaderService = (ClassLoaderService)serviceRegistry.getService(ClassLoaderService.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Configuration hibernateConfiguration) {
            SchemaGenAction databaseAction = SchemaGenAction.interpret(hibernateConfiguration.getProperty("javax.persistence.schema-generation.database.action"));
            SchemaGenAction scriptsAction = SchemaGenAction.interpret(hibernateConfiguration.getProperty("javax.persistence.schema-generation.scripts.action"));
            if (databaseAction == SchemaGenAction.NONE && scriptsAction == SchemaGenAction.NONE) {
                log.debug((Object)"No actions specified; doing nothing");
                return;
            }
            JdbcConnectionContext jdbcConnectionContext = JpaSchemaGenerator.determineAppropriateJdbcConnectionContext(hibernateConfiguration, this.serviceRegistry);
            try {
                Dialect dialect = JpaSchemaGenerator.determineDialect(jdbcConnectionContext, hibernateConfiguration, this.serviceRegistry);
                List<Object> createSourceList = databaseAction.includesCreate() || scriptsAction.includesCreate() ? this.buildCreateSourceList(hibernateConfiguration, dialect) : Collections.emptyList();
                List<Object> dropSourceList = databaseAction.includesDrop() || scriptsAction.includesDrop() ? this.buildDropSourceList(hibernateConfiguration, dialect) : Collections.emptyList();
                GenerationTargetToDatabase databaseTarget = new GenerationTargetToDatabase(jdbcConnectionContext, databaseAction);
                Object createScriptTargetSetting = hibernateConfiguration.getProperties().get("javax.persistence.schema-generation.scripts.create-target");
                Object dropScriptTargetSetting = hibernateConfiguration.getProperties().get("javax.persistence.schema-generation.scripts.drop-target");
                GenerationTargetToScript scriptsTarget = new GenerationTargetToScript(this.interpretScriptTargetSetting(createScriptTargetSetting, scriptsAction.includesCreate(), "javax.persistence.schema-generation.scripts.create-target"), this.interpretScriptTargetSetting(dropScriptTargetSetting, scriptsAction.includesDrop(), "javax.persistence.schema-generation.scripts.drop-target"), scriptsAction);
                List<GenerationTarget> targets = Arrays.asList(databaseTarget, scriptsTarget);
                String hbm2ddl = hibernateConfiguration.getProperty("hibernate.hbm2ddl.auto");
                if (StringHelper.isNotEmpty((String)hbm2ddl)) {
                    log.warnf("Hibernate hbm2ddl-auto setting was specified [%s] in combination with JPA schema-generation; combination will likely cause trouble", (Object)hbm2ddl);
                }
                try {
                    JpaSchemaGenerator.doGeneration(createSourceList, dropSourceList, targets);
                }
                finally {
                    JpaSchemaGenerator.releaseTargets(targets);
                    JpaSchemaGenerator.releaseSources(createSourceList);
                    JpaSchemaGenerator.releaseSources(dropSourceList);
                }
            }
            finally {
                JpaSchemaGenerator.releaseJdbcConnectionContext(jdbcConnectionContext);
            }
        }

        private ScriptTargetOutput interpretScriptTargetSetting(Object scriptTargetSetting, boolean actionIndicatedScripting, String settingName) {
            if (actionIndicatedScripting) {
                if (scriptTargetSetting == null) {
                    throw new PersistenceException("Scripting was requested, but no target was specified");
                }
                if (Writer.class.isInstance(scriptTargetSetting)) {
                    return new ScriptTargetOutputToWriter((Writer)scriptTargetSetting);
                }
                String scriptTargetSettingString = scriptTargetSetting.toString();
                try {
                    URL url = new URL(scriptTargetSettingString);
                    return new ScriptTargetOutputToUrl(url);
                }
                catch (MalformedURLException ignore) {
                    return new ScriptTargetOutputToFile(new File(scriptTargetSettingString));
                }
            }
            if (scriptTargetSetting != null) {
                log.debugf("Value was specified for '%s' [%s], but scripting action was not requested", (Object)settingName, scriptTargetSetting);
            }
            return NoOpScriptTargetOutput.INSTANCE;
        }

        private List<GenerationSource> buildCreateSourceList(Configuration hibernateConfiguration, Dialect dialect) {
            ScriptSourceInput scriptSourceInput;
            boolean includesScripts;
            ArrayList<GenerationSource> generationSourceList = new ArrayList<GenerationSource>();
            boolean createSchemas = ConfigurationHelper.getBoolean((String)"javax.persistence.create-database-schemas", (Map)hibernateConfiguration.getProperties(), (boolean)false);
            if (createSchemas) {
                generationSourceList.add(new CreateSchemaCommandSource(hibernateConfiguration, dialect));
            }
            SchemaGenSource sourceType = SchemaGenSource.interpret(hibernateConfiguration.getProperty("javax.persistence.schema-generation.create-source"));
            Object createScriptSourceSetting = hibernateConfiguration.getProperties().get("javax.persistence.schema-generation.create-script-source");
            if (sourceType == null) {
                sourceType = createScriptSourceSetting != null ? SchemaGenSource.SCRIPT : SchemaGenSource.METADATA;
            }
            boolean bl = includesScripts = sourceType != SchemaGenSource.METADATA;
            if (includesScripts && createScriptSourceSetting == null) {
                throw new PersistenceException("Schema generation configuration indicated to include CREATE scripts, but no script was specified");
            }
            ScriptSourceInput scriptSourceInput2 = scriptSourceInput = includesScripts ? this.interpretScriptSourceSetting(createScriptSourceSetting) : null;
            if (sourceType == SchemaGenSource.METADATA) {
                generationSourceList.add(new GenerationSourceFromMetadata(hibernateConfiguration, dialect, true));
            } else if (sourceType == SchemaGenSource.SCRIPT) {
                generationSourceList.add(new GenerationSourceFromScript(scriptSourceInput, this.scriptCommandExtractor));
            } else if (sourceType == SchemaGenSource.METADATA_THEN_SCRIPT) {
                generationSourceList.add(new GenerationSourceFromMetadata(hibernateConfiguration, dialect, true));
                generationSourceList.add(new GenerationSourceFromScript(scriptSourceInput, this.scriptCommandExtractor));
            } else if (sourceType == SchemaGenSource.SCRIPT_THEN_METADATA) {
                generationSourceList.add(new GenerationSourceFromScript(scriptSourceInput, this.scriptCommandExtractor));
                generationSourceList.add(new GenerationSourceFromMetadata(hibernateConfiguration, dialect, true));
            }
            Object importScriptSetting = hibernateConfiguration.getProperties().get("javax.persistence.sql-load-script-source");
            if (importScriptSetting != null) {
                ScriptSourceInput importScriptInput = this.interpretScriptSourceSetting(importScriptSetting);
                generationSourceList.add(new ImportScriptSource(importScriptInput, this.scriptCommandExtractor));
            }
            return generationSourceList;
        }

        private ScriptSourceInput interpretScriptSourceSetting(Object scriptSourceSetting) {
            if (Reader.class.isInstance(scriptSourceSetting)) {
                return new ScriptSourceInputFromReader((Reader)scriptSourceSetting);
            }
            String scriptSourceSettingString = scriptSourceSetting.toString();
            log.debugf("Attempting to resolve script source setting : %s", (Object)scriptSourceSettingString);
            log.trace((Object)"Trying as URL...");
            URL url = this.classLoaderService.locateResource(scriptSourceSettingString);
            if (url != null) {
                return new ScriptSourceInputFromUrl(url);
            }
            File file = new File(scriptSourceSettingString);
            return new ScriptSourceInputFromFile(file);
        }

        private List<GenerationSource> buildDropSourceList(Configuration hibernateConfiguration, Dialect dialect) {
            ScriptSourceInput scriptSourceInput;
            boolean includesScripts;
            ArrayList<GenerationSource> generationSourceList = new ArrayList<GenerationSource>();
            SchemaGenSource sourceType = SchemaGenSource.interpret(hibernateConfiguration.getProperty("javax.persistence.schema-generation.drop-source"));
            Object dropScriptSourceSetting = hibernateConfiguration.getProperties().get("javax.persistence.schema-generation.drop-script-source");
            if (sourceType == null) {
                sourceType = dropScriptSourceSetting != null ? SchemaGenSource.SCRIPT : SchemaGenSource.METADATA;
            }
            boolean bl = includesScripts = sourceType != SchemaGenSource.METADATA;
            if (includesScripts && dropScriptSourceSetting == null) {
                throw new PersistenceException("Schema generation configuration indicated to include CREATE scripts, but no script was specified");
            }
            ScriptSourceInput scriptSourceInput2 = scriptSourceInput = includesScripts ? this.interpretScriptSourceSetting(dropScriptSourceSetting) : null;
            if (sourceType == SchemaGenSource.METADATA) {
                generationSourceList.add(new GenerationSourceFromMetadata(hibernateConfiguration, dialect, false));
            } else if (sourceType == SchemaGenSource.SCRIPT) {
                generationSourceList.add(new GenerationSourceFromScript(scriptSourceInput, this.scriptCommandExtractor));
            } else if (sourceType == SchemaGenSource.METADATA_THEN_SCRIPT) {
                generationSourceList.add(new GenerationSourceFromMetadata(hibernateConfiguration, dialect, false));
                generationSourceList.add(new GenerationSourceFromScript(scriptSourceInput, this.scriptCommandExtractor));
            } else if (sourceType == SchemaGenSource.SCRIPT_THEN_METADATA) {
                generationSourceList.add(new GenerationSourceFromScript(scriptSourceInput, this.scriptCommandExtractor));
                generationSourceList.add(new GenerationSourceFromMetadata(hibernateConfiguration, dialect, false));
            }
            return generationSourceList;
        }

        private static class NoOpScriptTargetOutput
        implements ScriptTargetOutput {
            public static final NoOpScriptTargetOutput INSTANCE = new NoOpScriptTargetOutput();

            private NoOpScriptTargetOutput() {
            }

            @Override
            public void accept(String command) {
            }

            @Override
            public void release() {
            }
        }
    }
}

