/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.listener;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ManagedConnection;
import javax.transaction.SystemException;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.connectionmanager.listener.ConnectionCacheListener;
import org.jboss.jca.core.api.connectionmanager.pool.FlushMode;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionState;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.logging.Messages;

public abstract class AbstractConnectionListener
implements ConnectionListener {
    private final CoreLogger log;
    protected boolean trace;
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private final ConnectionManager cm;
    private final ManagedConnection managedConnection;
    private final Pool pool;
    private final ManagedConnectionPool managedConnectionPool;
    private FlushStrategy flushStrategy;
    private ConnectionState state = ConnectionState.NORMAL;
    protected CopyOnWriteArrayList<Object> connectionHandles = new CopyOnWriteArrayList();
    private final AtomicBoolean trackByTx = new AtomicBoolean(false);
    private long lastUse;
    private long lastValidated;
    private boolean enlisted;

    protected AbstractConnectionListener(ConnectionManager cm, ManagedConnection managedConnection, Pool pool, ManagedConnectionPool mcp, FlushStrategy flushStrategy) {
        this.cm = cm;
        this.managedConnection = managedConnection;
        this.pool = pool;
        this.managedConnectionPool = mcp;
        this.flushStrategy = flushStrategy;
        this.log = this.getLogger();
        this.trace = this.log.isTraceEnabled();
        this.lastUse = System.currentTimeMillis();
        this.enlisted = false;
    }

    protected CachedConnectionManager getCachedConnectionManager() {
        return this.cm.getCachedConnectionManager();
    }

    protected ConnectionManager getConnectionManager() {
        return this.cm;
    }

    protected abstract CoreLogger getLogger();

    @Override
    public int getNumberOfConnections() {
        return this.connectionHandles.size();
    }

    @Override
    public boolean isEnlisted() {
        return this.enlisted;
    }

    void setEnlisted(boolean v) {
        this.enlisted = v;
    }

    @Override
    public void delist() throws ResourceException {
    }

    @Override
    public void enlist() throws SystemException {
    }

    @Override
    public ManagedConnectionPool getManagedConnectionPool() {
        return this.managedConnectionPool;
    }

    @Override
    public long getLastValidatedTime() {
        return this.lastValidated;
    }

    public ManagedConnection getManagedConnection() {
        return this.managedConnection;
    }

    @Override
    public Pool getPool() {
        return this.pool;
    }

    @Override
    public ConnectionState getState() {
        return this.state;
    }

    @Override
    public boolean isManagedConnectionFree() {
        return this.connectionHandles.isEmpty();
    }

    @Override
    public boolean isTimedOut(long timeout) {
        return this.lastUse < timeout;
    }

    @Override
    public boolean isTrackByTx() {
        return this.trackByTx.get();
    }

    @Override
    public void registerConnection(Object handle) {
        if (handle != null) {
            this.connectionHandles.add(handle);
        } else {
            this.log.registeredNullHandleManagedConnection(this.managedConnection);
        }
    }

    @Override
    public void setLastValidatedTime(long lastValidated) {
        this.lastValidated = lastValidated;
    }

    @Override
    public void setState(ConnectionState newState) {
        this.state = newState;
    }

    @Override
    public void setTrackByTx(boolean trackByTx) {
        this.trackByTx.set(trackByTx);
    }

    @Override
    public void tidyup() throws ResourceException {
    }

    @Override
    public void unregisterConnection(Object handle) {
        if (handle != null) {
            if (!this.connectionHandles.remove(handle)) {
                this.log.unregisteredHandleNotRegistered(handle, this.managedConnection);
            }
        } else {
            this.log.unregisteredNullHandleManagedConnection(this.managedConnection);
        }
        if (this.trace) {
            this.log.trace("unregisterConnection: " + this.connectionHandles.size() + " handles left");
        }
    }

    @Override
    public void unregisterConnections() {
        if (this.getCachedConnectionManager() != null) {
            for (Object handle : this.connectionHandles) {
                this.getCachedConnectionManager().unregisterConnection((ConnectionCacheListener)this.getConnectionManager(), handle);
            }
        }
        this.connectionHandles.clear();
    }

    @Override
    public void used() {
        this.lastUse = System.currentTimeMillis();
    }

    public void connectionClosed(ConnectionEvent event) {
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        if (this.state == ConnectionState.NORMAL) {
            if (event != null) {
                Exception cause = event.getException();
                if (cause == null) {
                    cause = new Exception("No exception was reported");
                }
                this.log.connectionErrorOccured(this, cause);
            } else {
                Exception cause = new Exception("No exception was reported");
                this.log.unknownConnectionErrorOccured(this, cause);
            }
        }
        try {
            this.unregisterConnections();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (event != null && event.getSource() != this.getManagedConnection()) {
            this.log.notifiedErrorDifferentManagedConnection();
        }
        this.getConnectionManager().returnManagedConnection(this, true);
        if (this.flushStrategy == FlushStrategy.FAILING_CONNECTION_ONLY) {
            this.managedConnectionPool.prefill();
        } else if (this.flushStrategy == FlushStrategy.INVALID_IDLE_CONNECTIONS) {
            this.managedConnectionPool.flush(FlushMode.INVALID);
        } else if (this.flushStrategy == FlushStrategy.IDLE_CONNECTIONS) {
            this.managedConnectionPool.flush(FlushMode.IDLE);
        } else if (this.flushStrategy == FlushStrategy.GRACEFULLY) {
            this.managedConnectionPool.flush(FlushMode.GRACEFULLY);
        } else if (this.flushStrategy == FlushStrategy.ENTIRE_POOL) {
            this.managedConnectionPool.flush(FlushMode.ALL);
        } else if (this.flushStrategy == FlushStrategy.ALL_INVALID_IDLE_CONNECTIONS) {
            this.pool.flush(FlushMode.INVALID);
        } else if (this.flushStrategy == FlushStrategy.ALL_IDLE_CONNECTIONS) {
            this.pool.flush(FlushMode.IDLE);
        } else if (this.flushStrategy == FlushStrategy.ALL_GRACEFULLY) {
            this.pool.flush(FlushMode.GRACEFULLY);
        } else if (this.flushStrategy == FlushStrategy.ALL_CONNECTIONS) {
            this.pool.flush(FlushMode.ALL);
        }
    }

    @Override
    public boolean controls(ManagedConnection mc, Object connection) {
        return this.managedConnection.equals(mc) && (connection == null || this.connectionHandles.contains(connection));
    }

    @Override
    public void dissociate() throws ResourceException {
    }

    public void localTransactionCommitted(ConnectionEvent event) {
    }

    public void localTransactionRolledback(ConnectionEvent event) {
    }

    public void localTransactionStarted(ConnectionEvent event) {
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        if (!(o instanceof AbstractConnectionListener)) {
            throw new ClassCastException(bundle.notCorrectTypeWhenClassCast(o.getClass().getName()));
        }
        AbstractConnectionListener acl = (AbstractConnectionListener)o;
        if (this.lastUse < acl.lastUse) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(this.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(this)));
        buffer.append("[state=");
        if (this.state.equals((Object)ConnectionState.NORMAL)) {
            buffer.append("NORMAL");
        } else if (this.state.equals((Object)ConnectionState.DESTROY)) {
            buffer.append("DESTROY");
        } else if (this.state.equals((Object)ConnectionState.DESTROYED)) {
            buffer.append("DESTROYED");
        } else {
            buffer.append("UNKNOWN?");
        }
        buffer.append(" managed connection=").append(this.managedConnection);
        buffer.append(" connection handles=").append(this.connectionHandles.size());
        buffer.append(" lastUse=").append(this.lastUse);
        buffer.append(" trackByTx=").append(this.trackByTx.get());
        buffer.append(" pool=").append(this.pool);
        buffer.append(" mcp=").append(this.managedConnectionPool);
        this.toString(buffer);
        buffer.append(']');
        return buffer.toString();
    }

    protected void toString(StringBuffer buffer) {
    }
}

