/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.strategy;

import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.RetryableUnavailableException;
import javax.security.auth.Subject;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.pool.AbstractPool;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.connectionmanager.pool.strategy.ReauthKey;
import org.jboss.logging.Logger;

public class ReauthPool
extends AbstractPool {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)ReauthPool.class.getName());
    private int maxPoolSize;

    public ReauthPool(ManagedConnectionFactory mcf, PoolConfiguration pc, boolean noTxSeparatePools, boolean sharable) {
        super(mcf, pc, noTxSeparatePools, sharable);
        this.maxPoolSize = pc.getMaxSize();
    }

    @Override
    protected synchronized Object getKey(Subject subject, ConnectionRequestInfo cri, boolean separateNoTx) throws ResourceException {
        ManagedConnectionPool ownMcp;
        ReauthKey key = new ReauthKey(subject, cri, separateNoTx);
        int activeCount = this.getActiveCount();
        if (activeCount >= this.maxPoolSize && (ownMcp = this.getManagedConnectionPool(key, subject, cri)).getStatistics().getIdleCount() == 0) {
            ManagedConnectionPool mcp = this.getTargetManagedConnectionPool(ownMcp);
            if (mcp == null) {
                throw new RetryableUnavailableException();
            }
            ConnectionListener cl = mcp.removeConnectionListener();
            if (cl == null) {
                throw new RetryableUnavailableException();
            }
            ownMcp.addConnectionListener(cl);
            if (mcp.isEmpty()) {
                super.emptyManagedConnectionPool(mcp);
            }
        }
        return key;
    }

    @Override
    public void emptyManagedConnectionPool(ManagedConnectionPool pool) {
    }

    @Override
    public boolean testConnection() {
        return false;
    }

    @Override
    public boolean testConnection(ConnectionRequestInfo cri, Subject subject) {
        return this.internalTestConnection(cri, subject);
    }

    @Override
    public CoreLogger getLogger() {
        return log;
    }

    private int getActiveCount() {
        int result = 0;
        for (ManagedConnectionPool mcp : this.getManagedConnectionPools().values()) {
            result += mcp.getStatistics().getActiveCount();
        }
        return result;
    }

    private ManagedConnectionPool getTargetManagedConnectionPool(ManagedConnectionPool exclude) {
        ManagedConnectionPool mcp = null;
        long lastUsed = Long.MAX_VALUE;
        for (ManagedConnectionPool m : this.getManagedConnectionPools().values()) {
            if (lastUsed <= m.getLastUsed() || m.getStatistics().getIdleCount() <= 0 || exclude != null && m == exclude) continue;
            mcp = m;
            lastUsed = m.getLastUsed();
        }
        return mcp;
    }
}

