/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.impl;

import java.io.Serializable;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.Identifiable;
import org.jboss.as.ejb3.cache.spi.BackingCache;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntry;
import org.jboss.as.ejb3.cache.spi.impl.AbstractCache;
import org.jboss.as.ejb3.cache.spi.impl.GroupCreationContext;

public class SimpleCache<K extends Serializable, V extends Cacheable<K>, E extends BackingCacheEntry<K, V>>
extends AbstractCache<K, V, E> {
    private final boolean strictGroups;

    public SimpleCache(BackingCache<K, V, E> backingCache, boolean strictGroups) {
        super(backingCache);
        this.strictGroups = strictGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V create() {
        boolean outer = false;
        GroupCreationContext groupContext = GroupCreationContext.getGroupCreationContext();
        if (groupContext != null) {
            if (groupContext.isStrict() || this.strictGroups && groupContext.getEntries().size() > 0) {
                throw EjbMessages.MESSAGES.incompatibleCaches();
            }
        } else {
            GroupCreationContext.startGroupCreationContext(this.strictGroups);
            outer = true;
        }
        try {
            Identifiable identifiable = super.create();
            return (V)identifiable;
        }
        finally {
            if (outer) {
                GroupCreationContext.clearGroupCreationContext();
            }
        }
    }
}

