/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.cache.CacheFactory;
import org.jboss.as.ejb3.cache.CacheInfo;
import org.jboss.as.ejb3.cache.impl.factory.NonPassivatingCacheFactory;
import org.jboss.as.ejb3.component.DefaultAccessTimeoutService;
import org.jboss.as.ejb3.component.InvokeMethodOnTargetInterceptor;
import org.jboss.as.ejb3.component.interceptors.CurrentInvocationContextInterceptor;
import org.jboss.as.ejb3.component.session.SessionBeanComponentCreateService;
import org.jboss.as.ejb3.component.stateful.EJBClientContextIdentifierObjectTable;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulRemoveInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionBeanClassTable;
import org.jboss.as.ejb3.component.stateful.StatefulSessionBeanSerializabilityChecker;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.ejb3.component.stateful.StatefulSessionSynchronizationInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.ejb3.deployment.ApplicationExceptions;
import org.jboss.ejb.client.SessionID;
import org.jboss.invocation.ContextClassLoaderInterceptor;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.SerializabilityChecker;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class StatefulSessionComponentCreateService
extends SessionBeanComponentCreateService {
    private static final int CURRENT_MARSHALLING_VERSION = 1;
    private final InterceptorFactory afterBegin;
    private final Method afterBeginMethod;
    private final InterceptorFactory afterCompletion;
    private final Method afterCompletionMethod;
    private final InterceptorFactory beforeCompletion;
    private final Method beforeCompletionMethod;
    private final InterceptorFactory prePassivate;
    private final InterceptorFactory postActivate;
    private final StatefulTimeoutInfo statefulTimeout;
    private final CacheInfo cache;
    private final ClassLoader loader;
    private final Map<Integer, MarshallingConfiguration> marshallingConfigurations;
    private final InjectedValue<DefaultAccessTimeoutService> defaultAccessTimeoutService = new InjectedValue();
    private final InterceptorFactory ejb2XRemoveMethod;
    private final PassivationCheckInjectedValue cacheFactory = new PassivationCheckInjectedValue((InjectedValue<CacheFactory>)new InjectedValue());
    private final Set<Object> serializableInterceptorContextKeys;
    private final boolean passivationCapable;

    public StatefulSessionComponentCreateService(ComponentConfiguration componentConfiguration, ApplicationExceptions ejbJarConfiguration) {
        super(componentConfiguration, ejbJarConfiguration);
        StatefulComponentDescription componentDescription = (StatefulComponentDescription)componentConfiguration.getComponentDescription();
        ClassLoader classLoader = componentConfiguration.getModuleClassLoader();
        ImmediateInterceptorFactory tcclInterceptorFactory = new ImmediateInterceptorFactory((Interceptor)new ContextClassLoaderInterceptor(classLoader));
        InterceptorFactory namespaceContextInterceptorFactory = componentConfiguration.getNamespaceContextInterceptorFactory();
        this.afterBeginMethod = componentDescription.getAfterBegin();
        this.afterBegin = this.afterBeginMethod != null ? Interceptors.getChainedInterceptorFactory((InterceptorFactory[])new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, CurrentInvocationContextInterceptor.FACTORY, StatefulSessionComponentCreateService.invokeMethodOnTarget(this.afterBeginMethod)}) : null;
        this.afterCompletionMethod = componentDescription.getAfterCompletion();
        this.afterCompletion = this.afterCompletionMethod != null ? Interceptors.getChainedInterceptorFactory((InterceptorFactory[])new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, CurrentInvocationContextInterceptor.FACTORY, StatefulSessionComponentCreateService.invokeMethodOnTarget(this.afterCompletionMethod)}) : null;
        this.beforeCompletionMethod = componentDescription.getBeforeCompletion();
        this.beforeCompletion = this.beforeCompletionMethod != null ? Interceptors.getChainedInterceptorFactory((InterceptorFactory[])new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, CurrentInvocationContextInterceptor.FACTORY, StatefulSessionComponentCreateService.invokeMethodOnTarget(this.beforeCompletionMethod)}) : null;
        this.prePassivate = Interceptors.getChainedInterceptorFactory((Collection)componentConfiguration.getPrePassivateInterceptors());
        this.postActivate = Interceptors.getChainedInterceptorFactory((Collection)componentConfiguration.getPostActivateInterceptors());
        this.statefulTimeout = componentDescription.getStatefulTimeout();
        this.ejb2XRemoveMethod = Interceptors.getChainedInterceptorFactory((InterceptorFactory[])new InterceptorFactory[]{StatefulSessionSynchronizationInterceptor.factory(componentDescription.getTransactionManagementType()), new ImmediateInterceptorFactory((Interceptor)new StatefulRemoveInterceptor(false)), Interceptors.getTerminalInterceptorFactory()});
        this.cache = componentDescription.getCache();
        this.loader = componentConfiguration.getModuleClassLoader();
        MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
        marshallingConfiguration.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)componentConfiguration.getModuleLoader()));
        marshallingConfiguration.setSerializabilityChecker((SerializabilityChecker)new StatefulSessionBeanSerializabilityChecker(componentConfiguration.getComponentClass()));
        marshallingConfiguration.setClassTable((ClassTable)new StatefulSessionBeanClassTable());
        marshallingConfiguration.setObjectTable((ObjectTable)new EJBClientContextIdentifierObjectTable());
        this.marshallingConfigurations = Collections.singletonMap(1, marshallingConfiguration);
        this.serializableInterceptorContextKeys = componentConfiguration.getInterceptorContextKeys();
        this.passivationCapable = componentDescription.isPassivationApplicable();
    }

    private static InterceptorFactory invokeMethodOnTarget(Method method) {
        method.setAccessible(true);
        return InvokeMethodOnTargetInterceptor.factory(method);
    }

    protected BasicComponent createComponent() {
        return new StatefulSessionComponent(this);
    }

    public InterceptorFactory getAfterBegin() {
        return this.afterBegin;
    }

    public InterceptorFactory getAfterCompletion() {
        return this.afterCompletion;
    }

    public InterceptorFactory getBeforeCompletion() {
        return this.beforeCompletion;
    }

    public InterceptorFactory getPrePassivate() {
        return this.prePassivate;
    }

    public InterceptorFactory getPostActivate() {
        return this.postActivate;
    }

    public Method getAfterBeginMethod() {
        return this.afterBeginMethod;
    }

    public Method getAfterCompletionMethod() {
        return this.afterCompletionMethod;
    }

    public Method getBeforeCompletionMethod() {
        return this.beforeCompletionMethod;
    }

    public StatefulTimeoutInfo getStatefulTimeout() {
        return this.statefulTimeout;
    }

    public CacheInfo getCache() {
        return this.cache;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public int getCurrentMarshallingVersion() {
        return 1;
    }

    public Map<Integer, MarshallingConfiguration> getMarshallingConfigurations() {
        return this.marshallingConfigurations;
    }

    public DefaultAccessTimeoutService getDefaultAccessTimeoutService() {
        return (DefaultAccessTimeoutService)this.defaultAccessTimeoutService.getValue();
    }

    Injector<DefaultAccessTimeoutService> getDefaultAccessTimeoutInjector() {
        return this.defaultAccessTimeoutService;
    }

    public InterceptorFactory getEjb2XRemoveMethod() {
        return this.ejb2XRemoveMethod;
    }

    public Set<Object> getSerializableInterceptorContextKeys() {
        return this.serializableInterceptorContextKeys;
    }

    public CacheFactory<SessionID, StatefulSessionComponentInstance> getCacheFactory() {
        return this.cacheFactory.getValue();
    }

    Injector<CacheFactory> getCacheFactoryInjector() {
        return this.cacheFactory;
    }

    boolean isPassivationCapable() {
        return this.passivationCapable;
    }

    private class PassivationCheckInjectedValue
    implements Injector<CacheFactory>,
    Value<CacheFactory> {
        private final InjectedValue<CacheFactory> delegate;

        PassivationCheckInjectedValue(InjectedValue<CacheFactory> delegate) {
            this.delegate = delegate;
        }

        public void inject(CacheFactory value) throws InjectionException {
            if (!StatefulSessionComponentCreateService.this.passivationCapable && !(value instanceof NonPassivatingCacheFactory)) {
                throw EjbMessages.MESSAGES.requiresNonPassivatingCacheFactory(StatefulSessionComponentCreateService.this.getComponentName(), value);
            }
            this.delegate.inject((Object)value);
        }

        public void uninject() {
            this.delegate.uninject();
        }

        public CacheFactory getValue() throws IllegalStateException, IllegalArgumentException {
            return (CacheFactory)this.delegate.getValue();
        }
    }
}

