/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming.namemanager;

import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jacorb.naming.namemanager.ContextNode;
import org.jacorb.naming.namemanager.NSTableCellRenderer;
import org.jacorb.naming.namemanager.NSTableModel;
import org.omg.CosNaming.NameComponent;

public class NSTable
extends JTable {
    private ContextNode current;
    private NSTableCellRenderer nsRenderer;

    public NSTable() {
        super(new NSTableModel());
        this.setShowGrid(false);
        this.setAutoCreateColumnsFromModel(false);
        this.setDoubleBuffered(true);
        this.setCellSelectionEnabled(false);
        this.setColumnSelectionAllowed(false);
        this.nsRenderer = new NSTableCellRenderer();
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        String type = (String)this.getValueAt(row, 2);
        if (type.startsWith("IDL:omg.org/CosNaming/NamingContext")) {
            return this.nsRenderer;
        }
        return super.getCellRenderer(row, column);
    }

    public ContextNode currentSource() {
        return this.current;
    }

    public void setData(Vector newData, ContextNode currentSource) {
        this.current = currentSource;
        ((NSTableModel)super.getModel()).setDataVector(newData);
    }

    public synchronized void unbind() {
        int row = this.getSelectedRow();
        if (row > -1) {
            try {
                NameComponent[] ncs = new NameComponent[]{new NameComponent((String)this.getValueAt(row, 0), (String)this.getValueAt(row, 1))};
                this.current.unbind(ncs);
                this.update();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void update() {
        if (this.current != null) {
            this.current.display();
        }
    }
}

