/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.DefaultCategoryFactory;
import org.apache.log4j.JBossLevelMapping;
import org.apache.log4j.JBossLogManagerFacade;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.or.ObjectRenderer;
import org.apache.log4j.or.RendererMap;
import org.apache.log4j.spi.HierarchyEventListener;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RendererSupport;
import org.apache.log4j.spi.ThrowableRenderer;
import org.apache.log4j.spi.ThrowableRendererSupport;

public class Hierarchy
implements LoggerRepository,
RendererSupport,
ThrowableRendererSupport {
    private final LoggerFactory defaultFactory;
    private final org.jboss.logmanager.Logger jblmRootLogger;
    private final Set<HierarchyEventListener> listeners = new CopyOnWriteArraySet<HierarchyEventListener>();
    private final RendererMap rendererMap;
    private ThrowableRenderer throwableRenderer = null;

    public Hierarchy(Logger root) {
        this.jblmRootLogger = JBossLogManagerFacade.getJBossRootLogger();
        this.jblmRootLogger.setLevel(JBossLevelMapping.getLevelFor(root.getLevel()));
        this.defaultFactory = new DefaultCategoryFactory();
        this.rendererMap = new RendererMap();
    }

    public void addRenderer(Class classToRender, ObjectRenderer or) {
        this.rendererMap.put(classToRender, or);
    }

    @Override
    public void addHierarchyEventListener(HierarchyEventListener listener) {
        if (!this.listeners.add(listener)) {
            LogLog.warn("Ignoring attempt to add an existent listener.");
        }
    }

    public void clear() {
    }

    @Override
    public void emitNoAppenderWarning(Category cat) {
    }

    @Override
    public Logger exists(String name) {
        return JBossLogManagerFacade.exists(name);
    }

    @Override
    public void setThreshold(String levelStr) {
        Level l = Level.toLevel(levelStr, null);
        if (l != null) {
            this.setThreshold(l);
        } else {
            LogLog.warn("Could not convert [" + levelStr + "] to Level.");
        }
    }

    @Override
    public void setThreshold(Level l) {
        if (l != null) {
            JBossLogManagerFacade.getJBossRootLogger().setLevel(JBossLevelMapping.getLevelFor(l));
        }
    }

    @Override
    public void fireAddAppenderEvent(Category logger, Appender appender) {
        for (HierarchyEventListener listener : this.listeners) {
            listener.addAppenderEvent(logger, appender);
        }
    }

    void fireRemoveAppenderEvent(Category logger, Appender appender) {
        for (HierarchyEventListener listener : this.listeners) {
            listener.removeAppenderEvent(logger, appender);
        }
    }

    @Override
    public Level getThreshold() {
        return JBossLevelMapping.getPriorityFor(JBossLogManagerFacade.getJBossRootLogger().getLevel());
    }

    @Override
    public Logger getLogger(String name) {
        return this.getLogger(name, this.defaultFactory);
    }

    @Override
    public Logger getLogger(String name, LoggerFactory factory) {
        return JBossLogManagerFacade.getLogger(this, name, factory);
    }

    @Override
    public Enumeration getCurrentLoggers() {
        return Collections.enumeration(JBossLogManagerFacade.getLoggers());
    }

    @Override
    public Enumeration getCurrentCategories() {
        return this.getCurrentLoggers();
    }

    @Override
    public RendererMap getRendererMap() {
        return this.rendererMap;
    }

    @Override
    public Logger getRootLogger() {
        return JBossLogManagerFacade.getLogger(this.jblmRootLogger);
    }

    @Override
    public boolean isDisabled(int level) {
        return JBossLevelMapping.getPriorityFor(JBossLogManagerFacade.getJBossRootLogger().getLevel()).toInt() > level;
    }

    @Deprecated
    public void overrideAsNeeded(String override) {
    }

    @Override
    public void resetConfiguration() {
    }

    @Deprecated
    public void setDisableOverride(String override) {
    }

    @Override
    public void setRenderer(Class renderedClass, ObjectRenderer renderer) {
        this.rendererMap.put(renderedClass, renderer);
    }

    @Override
    public void setThrowableRenderer(ThrowableRenderer renderer) {
        this.throwableRenderer = renderer;
    }

    @Override
    public ThrowableRenderer getThrowableRenderer() {
        return this.throwableRenderer;
    }

    @Override
    public void shutdown() {
    }
}

