/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.generator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.jboss.as.patching.HashUtils;
import org.jboss.as.patching.generator.DistributionContentItem;
import org.jboss.as.patching.generator.PatchGenerator;

class DistributionItemFileImpl
extends DistributionContentItem {
    private final File file;
    private final Set<DistributionContentItem> children;
    private byte[] cachedMetadataHash = null;

    protected DistributionItemFileImpl(File file, DistributionContentItem parent) {
        this(file, parent, file.getName());
    }

    protected DistributionItemFileImpl(File file, DistributionContentItem parent, String name) {
        super(parent, name);
        this.file = file;
        this.children = file.isDirectory() ? new TreeSet<DistributionContentItem>() : NO_CHILDREN;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public byte[] getMetadataHash() {
        try {
            if (this.cachedMetadataHash == null) {
                this.cachedMetadataHash = HashUtils.hashFile(this.file);
            }
            return this.cachedMetadataHash;
        }
        catch (IOException e) {
            throw PatchGenerator.processingError(e, "failed to generate hash", new Object[0]);
        }
    }

    @Override
    public byte[] getComparisonHash() {
        String name = this.file.getName();
        try {
            if (name.endsWith(".jar")) {
                return DistributionItemFileImpl.internalJarComparison(this.file);
            }
            return this.getMetadataHash();
        }
        catch (Exception e) {
            throw PatchGenerator.processingError(e, "failed to generate hash", new Object[0]);
        }
    }

    @Override
    public boolean isLeaf() {
        return this.file.isFile();
    }

    public Set<DistributionContentItem> getChildren() {
        return this.children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] internalJarComparison(File file) throws NoSuchAlgorithmException, IOException {
        MessageDigest jarDigest = MessageDigest.getInstance("SHA1");
        MessageDigest digest = MessageDigest.getInstance("SHA1");
        try (JarInputStream in = new JarInputStream(new BufferedInputStream(new FileInputStream(file)));){
            JarEntry entry;
            while ((entry = in.getNextJarEntry()) != null) {
                int l;
                String name;
                if (entry.isDirectory() || (name = entry.getName()).startsWith("META-INF/") && (name.endsWith(".SF") || name.endsWith(".DSA")) || name.equals("META-INF/INDEX.LIST") || name.startsWith("META-INF/maven/") && name.endsWith("/pom.properties")) continue;
                digest.reset();
                byte[] buf = new byte[4096];
                while ((l = in.read(buf)) > 0) {
                    digest.update(buf, 0, l);
                }
                byte[] d = digest.digest();
                jarDigest.update(d);
            }
        }
        return jarDigest.digest();
    }
}

