/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.generator;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.jboss.as.patching.generator.Distribution;
import org.jboss.as.patching.generator.DistributionContentItem;
import org.jboss.as.patching.generator.DistributionModuleItem;
import org.jboss.as.patching.generator.PatchGenerator;
import org.jboss.as.patching.metadata.ModificationBuilderTarget;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchBuilder;
import org.jboss.as.patching.metadata.PatchElementBuilder;

abstract class PatchBuilderWrapper
extends PatchBuilder {
    protected PatchBuilderWrapper() {
    }

    abstract PatchElementBuilder modifyLayer(String var1, boolean var2);

    protected Patch compare(Distribution base, Distribution updated) {
        PatchBuilderWrapper.compare(this, base, updated);
        return this.build();
    }

    protected PatchElementBuilder addLayer(String layer) {
        throw PatchGenerator.processingError("invalid layer configuration for %s", layer);
    }

    protected PatchElementBuilder modifyLayer(String layer) {
        return this.modifyLayer(layer, false);
    }

    protected PatchElementBuilder removeLayer(String layer) {
        throw PatchGenerator.processingError("invalid layer configuration for %s", layer);
    }

    protected PatchElementBuilder addAddOn(String layer) {
        throw PatchGenerator.processingError("invalid add-on configuration for %s", layer);
    }

    protected PatchElementBuilder modifyAddOn(String layer) {
        return this.modifyLayer(layer, true);
    }

    protected PatchElementBuilder removeAddOn(String layer) {
        throw PatchGenerator.processingError("invalid add-on configuration for %s", layer);
    }

    static void compare(PatchBuilderWrapper builder, Distribution original, Distribution updated) {
        Distribution.ProcessedLayer updatedLayer;
        PatchElementBuilder elementBuilder;
        Distribution.ProcessedLayer originalLayer;
        DistributionContentItem or = original.getRoot();
        DistributionContentItem nr = updated.getRoot();
        PatchBuilderWrapper.compareMiscFiles(builder, or, nr);
        LinkedHashSet<String> originalLayers = new LinkedHashSet<String>(original.getLayers());
        LinkedHashSet<String> updatedLayers = new LinkedHashSet<String>(updated.getLayers());
        for (String layer : originalLayers) {
            originalLayer = original.getLayer(layer);
            if (updatedLayers.remove(layer)) {
                elementBuilder = builder.modifyLayer(layer);
                updatedLayer = updated.getLayer(layer);
            } else {
                elementBuilder = builder.removeLayer(layer);
                updatedLayer = null;
            }
            PatchBuilderWrapper.compareLayer(elementBuilder, originalLayer, updatedLayer);
        }
        for (String layer : updatedLayers) {
            originalLayer = null;
            updatedLayer = updated.getLayer(layer);
            elementBuilder = builder.addLayer(layer);
            PatchBuilderWrapper.compareLayer(elementBuilder, originalLayer, updatedLayer);
        }
        LinkedHashSet<String> originalAddOns = new LinkedHashSet<String>(original.getAddOns());
        LinkedHashSet<String> updatedAddOns = new LinkedHashSet<String>(updated.getAddOns());
        for (String addOn : originalAddOns) {
            Distribution.ProcessedLayer updatedLayer2;
            PatchElementBuilder elementBuilder2;
            Distribution.ProcessedLayer originalLayer2 = original.getAddOn(addOn);
            if (updatedAddOns.remove(addOn)) {
                elementBuilder2 = builder.modifyAddOn(addOn);
                updatedLayer2 = updated.getAddOn(addOn);
            } else {
                elementBuilder2 = builder.removeAddOn(addOn);
                updatedLayer2 = null;
            }
            PatchBuilderWrapper.compareLayer(elementBuilder2, originalLayer2, updatedLayer2);
        }
        for (String addOn : updatedAddOns) {
            elementBuilder = builder.addAddOn(addOn);
            PatchBuilderWrapper.compareLayer(elementBuilder, null, updated.getAddOn(addOn));
        }
    }

    static void compareLayer(PatchElementBuilder elementBuilder, Distribution.ProcessedLayer originalLayer, Distribution.ProcessedLayer updatedLayer) {
        PatchBuilderWrapper.compareModuleItems(elementBuilder, originalLayer.getModules(), updatedLayer.getModules(), false);
        PatchBuilderWrapper.compareModuleItems(elementBuilder, originalLayer.getBundles(), updatedLayer.getBundles(), true);
    }

    static void compareModuleItems(PatchElementBuilder elementBuilder, Collection<DistributionModuleItem> original, Collection<DistributionModuleItem> updated, boolean bundle2) {
        HashMap<String, DistributionModuleItem> modules = new HashMap<String, DistributionModuleItem>();
        for (DistributionModuleItem item : updated) {
            modules.put(item.getFullModuleName(), item);
        }
        for (DistributionModuleItem o : original) {
            DistributionModuleItem n = (DistributionModuleItem)modules.remove(o.getFullModuleName());
            if (n == null) {
                if (bundle2) {
                    elementBuilder.removeBundle(o.getName(), o.getSlot(), o.getMetadataHash());
                    continue;
                }
                elementBuilder.removeModule(o.getName(), o.getSlot(), o.getMetadataHash());
                continue;
            }
            if (Arrays.equals(n.getComparisonHash(), o.getComparisonHash())) continue;
            if (bundle2) {
                elementBuilder.modifyBundle(n.getName(), n.getSlot(), o.getMetadataHash(), n.getMetadataHash());
                continue;
            }
            elementBuilder.modifyModule(n.getName(), n.getSlot(), o.getMetadataHash(), n.getMetadataHash());
        }
        for (DistributionModuleItem item : modules.values()) {
            if (bundle2) {
                elementBuilder.addBundle(item.getName(), item.getSlot(), item.getMetadataHash());
                continue;
            }
            elementBuilder.addModule(item.getName(), item.getSlot(), item.getMetadataHash());
        }
    }

    static void compareMiscFiles(ModificationBuilderTarget<?> builder, DistributionContentItem o, DistributionContentItem n) {
        if (o == null && n == null) {
            return;
        }
        if (o != null && n == null) {
            builder.removeFile(o.getName(), o.getParent().getPathAsList(), o.getMetadataHash(), !o.isLeaf());
        } else if (o == null && n != null) {
            boolean directory;
            boolean bl = directory = !n.isLeaf();
            if (directory) {
                for (DistributionContentItem child : n.getChildren()) {
                    PatchBuilderWrapper.compareMiscFiles(builder, null, child);
                }
            } else {
                builder.addFile(n.getName(), n.getParent().getPathAsList(), n.getMetadataHash(), directory);
            }
        } else {
            if (!n.equals(o)) {
                throw PatchGenerator.processingError("TODO", new Object[0]);
            }
            if (n.isLeaf() != o.isLeaf()) {
                throw PatchGenerator.processingError("TODO", new Object[0]);
            }
            if (n.isLeaf() && !Arrays.equals(o.getComparisonHash(), n.getComparisonHash())) {
                builder.modifyFile(n.getName(), n.getParent().getPathAsList(), o.getMetadataHash(), n.getMetadataHash(), !n.isLeaf());
            } else {
                Collection<DistributionContentItem> nc = n.getChildren();
                HashMap<String, DistributionContentItem> children = new HashMap<String, DistributionContentItem>();
                for (DistributionContentItem child : nc) {
                    children.put(child.getName(), child);
                }
                for (DistributionContentItem child : o.getChildren()) {
                    DistributionContentItem item = (DistributionContentItem)children.remove(child.getName());
                    PatchBuilderWrapper.compareMiscFiles(builder, child, item);
                }
                for (DistributionContentItem child : children.values()) {
                    PatchBuilderWrapper.compareMiscFiles(builder, null, child);
                }
            }
        }
    }
}

