/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.metadata;

import org.jboss.as.patching.PatchMessages;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.ModificationBuilderTarget;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchBuilder;
import org.jboss.as.patching.metadata.PatchElement;
import org.jboss.as.patching.metadata.impl.IncompatibleWithCallback;
import org.jboss.as.patching.metadata.impl.PatchElementImpl;
import org.jboss.as.patching.metadata.impl.PatchElementProviderImpl;
import org.jboss.as.patching.metadata.impl.RequiresCallback;

public class PatchElementBuilder
extends ModificationBuilderTarget<PatchElementBuilder>
implements PatchBuilder.PatchElementHolder,
RequiresCallback,
IncompatibleWithCallback {
    private final String patchId;
    private final PatchElementImpl element;
    private PatchElementProviderImpl provider;
    private final PatchBuilder parent;

    protected PatchElementBuilder(String patchId, String layerName, boolean addOn, PatchBuilder parent) {
        this.patchId = patchId;
        this.provider = new PatchElementProviderImpl(layerName, addOn);
        this.element = new PatchElementImpl(patchId);
        this.element.setProvider(this.provider);
        this.parent = parent;
    }

    PatchElementProviderImpl getProvider() {
        return this.provider;
    }

    public PatchElementBuilder setDescription(String description) {
        this.element.setDescription(description);
        return this;
    }

    @Override
    protected PatchElementBuilder internalAddModification(ContentModification modification) {
        this.element.addContentModification(modification);
        return this.returnThis();
    }

    @Override
    public IncompatibleWithCallback incompatibleWith(String patchID) {
        this.provider.incompatibleWith(patchID);
        return this.returnThis();
    }

    @Override
    public PatchElementBuilder require(String id) {
        this.provider.require(id);
        return this.returnThis();
    }

    public PatchElementBuilder upgrade() {
        this.provider.upgrade();
        return this.returnThis();
    }

    public PatchElementBuilder oneOffPatch() {
        this.provider.oneOffPatch();
        return this.returnThis();
    }

    @Override
    public PatchElement createElement(Patch.PatchType patchType) {
        assert (this.patchId != null);
        assert (this.provider != null);
        if (patchType != this.getProvider().getPatchType()) {
            throw PatchMessages.MESSAGES.patchTypesDontMatch();
        }
        return this.element;
    }

    public PatchBuilder getParent() {
        return this.parent;
    }

    @Override
    protected PatchElementBuilder returnThis() {
        return this;
    }
}

