/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.runner.ContentItemFilter;
import org.jboss.as.patching.runner.Location;
import org.jboss.as.patching.runner.PatchingTaskContext;

class PatchingTasks {
    PatchingTasks() {
    }

    static void rollback(String patchId, Collection<ContentModification> originalPatch, Collection<ContentModification> rollbackPatch, Map<Location, ContentTaskDefinition> modifications, ContentItemFilter filter, PatchingTaskContext.Mode mode) {
        HashMap<Location, ContentModification> originalModifications = new HashMap<Location, ContentModification>();
        for (ContentModification modification : originalPatch) {
            originalModifications.put(new Location(modification.getItem()), modification);
        }
        for (ContentModification modification : rollbackPatch) {
            byte[] originalTarget;
            byte[] originalContent;
            ContentItem item = modification.getItem();
            if (!filter.accepts(item)) continue;
            Location location = new Location(item);
            ContentModification original = (ContentModification)originalModifications.remove(location);
            ContentEntry contentEntry = new ContentEntry(patchId, modification);
            ContentTaskDefinition definition = modifications.get(location);
            if (definition == null) {
                definition = new ContentTaskDefinition(location, contentEntry);
                modifications.put(location, definition);
            } else {
                ContentEntry previous;
                byte[] hash;
                boolean strict = true;
                if (strict && !Arrays.equals(hash = (previous = definition.getTarget()).getItem().getContentHash(), contentEntry.getTargetHash())) {
                    throw new IllegalStateException();
                }
                definition.setTarget(contentEntry);
            }
            if (original == null || mode == PatchingTaskContext.Mode.ROLLBACK) continue;
            byte[] currentContent = modification.getTargetHash();
            if (!Arrays.equals(currentContent, originalContent = original.getItem().getContentHash())) {
                definition.addConflict(contentEntry);
                continue;
            }
            byte[] backupItem = item.getContentHash();
            if (Arrays.equals(backupItem, originalTarget = original.getTargetHash())) continue;
            definition.addConflict(contentEntry);
        }
    }

    static void apply(String patchId, Collection<ContentModification> modifications, Map<Location, ContentTaskDefinition> definitions) {
        PatchingTasks.apply(patchId, modifications, definitions, ContentItemFilter.ALL);
    }

    static void apply(String patchId, Collection<ContentModification> modifications, Map<Location, ContentTaskDefinition> definitions, ContentItemFilter filter) {
        for (ContentModification modification : modifications) {
            ContentItem item = modification.getItem();
            if (!filter.accepts(item)) continue;
            Location location = new Location(item);
            ContentEntry contentEntry = new ContentEntry(patchId, modification);
            ContentTaskDefinition definition = definitions.get(location);
            if (definition == null) {
                definition = new ContentTaskDefinition(location, contentEntry);
                definitions.put(location, definition);
            }
            definition.setTarget(contentEntry);
        }
    }

    static class ContentEntry {
        final String patchId;
        final ContentModification modification;

        ContentEntry(String patchId, ContentModification modification) {
            this.patchId = patchId;
            this.modification = modification;
        }

        public String getPatchId() {
            return this.patchId;
        }

        public ContentModification getModification() {
            return this.modification;
        }

        public ContentItem getItem() {
            return this.modification.getItem();
        }

        public byte[] getTargetHash() {
            return this.modification.getTargetHash();
        }
    }

    static class ContentTaskDefinition {
        private final Location location;
        private final ContentEntry latest;
        private ContentEntry target;
        private final List<ContentEntry> conflicts = new ArrayList<ContentEntry>();

        ContentTaskDefinition(Location location, ContentEntry latest) {
            this.location = location;
            this.latest = latest;
            this.target = latest;
        }

        public Location getLocation() {
            return this.location;
        }

        public ContentEntry getLatest() {
            return this.latest;
        }

        public ContentEntry getTarget() {
            return this.target;
        }

        public boolean hasConflicts() {
            return !this.conflicts.isEmpty();
        }

        public List<ContentEntry> getConflicts() {
            return this.conflicts;
        }

        void setTarget(ContentEntry entry) {
            this.target = entry;
        }

        void addConflict(ContentEntry entry) {
            this.conflicts.add(entry);
        }
    }
}

