/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.RawProtobufMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.impl.ProtoStreamReaderImpl;
import org.infinispan.protostream.impl.ProtoStreamWriterImpl;
import org.infinispan.protostream.impl.SerializationContextImpl;

public class ProtobufUtil {
    private static final int wrappedDouble = 1;
    private static final int wrappedFloat = 2;
    private static final int wrappedInt64 = 3;
    private static final int wrappedUInt64 = 4;
    private static final int wrappedInt32 = 5;
    private static final int wrappedFixed64 = 6;
    private static final int wrappedFixed32 = 7;
    private static final int wrappedBool = 8;
    private static final int wrappedString = 9;
    private static final int wrappedBytes = 10;
    private static final int wrappedUInt32 = 11;
    private static final int wrappedSFixed32 = 12;
    private static final int wrappedSFixed64 = 13;
    private static final int wrappedSInt32 = 14;
    private static final int wrappedSInt64 = 15;
    private static final int wrappedDescriptorFullName = 16;
    private static final int wrappedMessageBytes = 17;
    private static final int wrappedEnum = 18;

    public static SerializationContext newSerializationContext() {
        return new SerializationContextImpl();
    }

    public static <A> void writeTo(SerializationContext ctx, CodedOutputStream out, A t) throws IOException {
        if (t == null) {
            throw new IllegalArgumentException("Object to marshall cannot be null");
        }
        ProtoStreamWriterImpl writer = new ProtoStreamWriterImpl(ctx);
        writer.write(out, t);
    }

    public static void writeTo(SerializationContext ctx, OutputStream out, Object t) throws IOException {
        ProtobufUtil.writeTo(ctx, CodedOutputStream.newInstance((OutputStream)out), t);
    }

    public static byte[] toByteArray(SerializationContext ctx, Object t) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ProtobufUtil.writeTo(ctx, baos, t);
        return baos.toByteArray();
    }

    public static <A> A readFrom(SerializationContext ctx, CodedInputStream in, Class<A> clazz) throws IOException {
        ProtoStreamReaderImpl reader = new ProtoStreamReaderImpl(ctx);
        return reader.read(in, clazz);
    }

    public static <A> A readFrom(SerializationContext ctx, InputStream in, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, CodedInputStream.newInstance((InputStream)in), clazz);
    }

    public static <A> A fromByteArray(SerializationContext ctx, byte[] bytes, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, new ByteArrayInputStream(bytes), clazz);
    }

    public static <A> A fromByteArray(SerializationContext ctx, byte[] bytes, int offset, int length, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, new ByteArrayInputStream(bytes, offset, length), clazz);
    }

    public static byte[] toWrappedByteArray(SerializationContext ctx, Object t) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CodedOutputStream out = CodedOutputStream.newInstance((OutputStream)baos);
        ProtobufUtil.toWrappedByteArray(ctx, out, t);
        return baos.toByteArray();
    }

    public static void toWrappedByteArray(SerializationContext ctx, CodedOutputStream out, Object t) throws IOException {
        if (t == null) {
            return;
        }
        if (t instanceof String) {
            out.writeString(9, (String)t);
        } else if (t instanceof Long) {
            out.writeInt64(3, ((Long)t).longValue());
        } else if (t instanceof Integer) {
            out.writeInt32(5, ((Integer)t).intValue());
        } else if (t instanceof Double) {
            out.writeDouble(1, ((Double)t).doubleValue());
        } else if (t instanceof Float) {
            out.writeFloat(2, ((Float)t).floatValue());
        } else if (t instanceof Boolean) {
            out.writeBool(8, ((Boolean)t).booleanValue());
        } else if (t instanceof byte[]) {
            byte[] bytes = (byte[])t;
            out.writeTag(10, 2);
            out.writeRawVarint32(bytes.length);
            out.writeRawBytes(bytes);
        } else if (t instanceof Enum) {
            EnumMarshaller enumMarshaller = (EnumMarshaller)ctx.getMarshaller(t.getClass());
            out.writeString(16, enumMarshaller.getTypeName());
            out.writeEnum(18, enumMarshaller.encode((Enum)t));
        } else {
            BaseMarshaller<?> marshaller = ctx.getMarshaller(t.getClass());
            out.writeString(16, marshaller.getTypeName());
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ProtoStreamWriterImpl writer = new ProtoStreamWriterImpl(ctx);
            writer.write(CodedOutputStream.newInstance((OutputStream)buffer), t);
            out.writeTag(17, 2);
            out.writeRawVarint32(buffer.size());
            out.writeRawBytes(buffer.toByteArray());
        }
        out.flush();
    }

    public static Object fromWrappedByteArray(SerializationContext ctx, byte[] bytes) throws IOException {
        return ProtobufUtil.fromWrappedByteArray(ctx, bytes, 0, bytes.length);
    }

    public static Object fromWrappedByteArray(SerializationContext ctx, byte[] bytes, int offset, int length) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes, offset, length);
        CodedInputStream in = CodedInputStream.newInstance((InputStream)bais);
        return ProtobufUtil.fromWrappedByteArray(ctx, in);
    }

    public static Object fromWrappedByteArray(SerializationContext ctx, CodedInputStream in) throws IOException {
        int tag;
        String descriptorFullName = null;
        int enumValue = -1;
        byte[] messageBytes = null;
        Object value = null;
        int readTags = 0;
        block20: while ((tag = in.readTag()) != 0) {
            ++readTags;
            switch (tag) {
                case 130: {
                    descriptorFullName = in.readString();
                    continue block20;
                }
                case 144: {
                    enumValue = in.readEnum();
                    continue block20;
                }
                case 138: {
                    messageBytes = in.readBytes().toByteArray();
                    continue block20;
                }
                case 74: {
                    value = in.readString();
                    continue block20;
                }
                case 82: {
                    value = in.readBytes().toByteArray();
                    continue block20;
                }
                case 64: {
                    value = in.readBool();
                    continue block20;
                }
                case 9: {
                    value = in.readDouble();
                    continue block20;
                }
                case 21: {
                    value = Float.valueOf(in.readFloat());
                    continue block20;
                }
                case 61: {
                    value = in.readFixed32();
                    continue block20;
                }
                case 101: {
                    value = in.readSFixed32();
                    continue block20;
                }
                case 49: {
                    value = in.readFixed64();
                    continue block20;
                }
                case 105: {
                    value = in.readSFixed64();
                    continue block20;
                }
                case 24: {
                    value = in.readInt64();
                    continue block20;
                }
                case 32: {
                    value = in.readUInt64();
                    continue block20;
                }
                case 120: {
                    value = in.readSInt64();
                    continue block20;
                }
                case 40: {
                    value = in.readInt32();
                    continue block20;
                }
                case 88: {
                    value = in.readUInt32();
                    continue block20;
                }
                case 112: {
                    value = in.readSInt32();
                    continue block20;
                }
            }
            throw new IllegalStateException("Unexpected tag : " + tag);
        }
        if (value == null && descriptorFullName == null && messageBytes == null) {
            return null;
        }
        if (value != null) {
            if (readTags == 1) {
                return value;
            }
            throw new IOException("Invalid message encoding.");
        }
        if (descriptorFullName == null || readTags != 2) {
            throw new IOException("Invalid message encoding.");
        }
        if (messageBytes != null) {
            BaseMarshaller marshaller = ctx.getMarshaller(descriptorFullName);
            ByteArrayInputStream bais2 = new ByteArrayInputStream(messageBytes);
            CodedInputStream in2 = CodedInputStream.newInstance((InputStream)bais2);
            if (marshaller instanceof MessageMarshaller) {
                ProtoStreamReaderImpl reader = new ProtoStreamReaderImpl(ctx);
                return reader.read(in2, (MessageMarshaller)marshaller);
            }
            return ((RawProtobufMarshaller)marshaller).readFrom(ctx, in2);
        }
        EnumMarshaller enumMarshaller = (EnumMarshaller)ctx.getMarshaller(descriptorFullName);
        return enumMarshaller.decode(enumValue);
    }
}

