/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.impl.WrappedMessageMarshaller;

public final class SerializationContextImpl
implements SerializationContext {
    private Map<String, Descriptors.FileDescriptor> fileDescriptors = new ConcurrentHashMap<String, Descriptors.FileDescriptor>();
    private Map<String, Descriptors.Descriptor> messageDescriptors = new ConcurrentHashMap<String, Descriptors.Descriptor>();
    private Map<String, Descriptors.EnumDescriptor> enumDescriptors = new ConcurrentHashMap<String, Descriptors.EnumDescriptor>();
    private Map<Class<?>, BaseMarshaller<?>> marshallersByClass = new ConcurrentHashMap();
    private Map<String, BaseMarshaller<?>> marshallersByName = new ConcurrentHashMap();

    public SerializationContextImpl() {
        try {
            this.registerProtofile("/message-wrapping.protobin");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new RuntimeException(e);
        }
        this.registerMarshaller(WrappedMessage.class, new WrappedMessageMarshaller());
    }

    private Descriptors.FileDescriptor[] resolveDeps(List<String> dependencyList, Map<String, Descriptors.FileDescriptor> map) {
        ArrayList<Descriptors.FileDescriptor> deps = new ArrayList<Descriptors.FileDescriptor>();
        for (String fname : dependencyList) {
            if (map.containsKey(fname)) {
                deps.add(map.get(fname));
                continue;
            }
            if (!DescriptorProtos.getDescriptor().getName().equals(fname)) continue;
            deps.add(DescriptorProtos.getDescriptor());
        }
        return deps.toArray(new Descriptors.FileDescriptor[deps.size()]);
    }

    @Override
    public void registerProtofile(InputStream in) throws IOException, Descriptors.DescriptorValidationException {
        DescriptorProtos.FileDescriptorSet descriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)in);
        for (DescriptorProtos.FileDescriptorProto fdp : descriptorSet.getFileList()) {
            Descriptors.FileDescriptor[] deps = this.resolveDeps(fdp.getDependencyList(), this.fileDescriptors);
            Descriptors.FileDescriptor fd = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fdp, (Descriptors.FileDescriptor[])deps);
            this.registerProtofile(fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerProtofile(String classpathResource) throws IOException, Descriptors.DescriptorValidationException {
        InputStream in = this.getClass().getResourceAsStream(classpathResource);
        if (in == null) {
            throw new IOException("Resource \"" + classpathResource + "\" does not exist");
        }
        try {
            this.registerProtofile(in);
        }
        finally {
            in.close();
        }
    }

    @Override
    public void registerProtofile(Descriptors.FileDescriptor fileDescriptor) {
        this.fileDescriptors.put(fileDescriptor.getName(), fileDescriptor);
        this.registerMessageDescriptors(fileDescriptor.getMessageTypes());
        this.registerEnumDescriptors(fileDescriptor.getEnumTypes());
    }

    private void registerMessageDescriptors(List<Descriptors.Descriptor> messageTypes) {
        for (Descriptors.Descriptor d : messageTypes) {
            this.messageDescriptors.put(d.getFullName(), d);
            this.registerMessageDescriptors(d.getNestedTypes());
            this.registerEnumDescriptors(d.getEnumTypes());
        }
    }

    private void registerEnumDescriptors(List<Descriptors.EnumDescriptor> enumTypes) {
        for (Descriptors.EnumDescriptor e : enumTypes) {
            this.enumDescriptors.put(e.getFullName(), e);
        }
    }

    @Override
    public Descriptors.Descriptor getMessageDescriptor(String fullName) {
        Descriptors.Descriptor descriptor = this.messageDescriptors.get(fullName);
        if (descriptor == null) {
            throw new IllegalArgumentException("Message descriptor not found : " + fullName);
        }
        return descriptor;
    }

    @Override
    public Descriptors.EnumDescriptor getEnumDescriptor(String fullName) {
        Descriptors.EnumDescriptor descriptor = this.enumDescriptors.get(fullName);
        if (descriptor == null) {
            throw new IllegalArgumentException("Enum descriptor not found : " + fullName);
        }
        return descriptor;
    }

    @Override
    public <T> void registerMarshaller(Class<? extends T> clazz, BaseMarshaller<T> marshaller) {
        if (marshaller instanceof EnumMarshaller) {
            this.getEnumDescriptor(marshaller.getTypeName());
        } else {
            this.getMessageDescriptor(marshaller.getTypeName());
        }
        this.marshallersByClass.put(clazz, marshaller);
        this.marshallersByName.put(marshaller.getTypeName(), marshaller);
    }

    @Override
    public boolean canMarshall(Class clazz) {
        return this.marshallersByClass.containsKey(clazz);
    }

    @Override
    public boolean canMarshall(String descriptorFullName) {
        return this.messageDescriptors.containsKey(descriptorFullName) || this.enumDescriptors.containsKey(descriptorFullName);
    }

    @Override
    public <T> BaseMarshaller<T> getMarshaller(String descriptorFullName) {
        BaseMarshaller<?> marshaller = this.marshallersByName.get(descriptorFullName);
        if (marshaller == null) {
            throw new IllegalArgumentException("No marshaller registered for " + descriptorFullName);
        }
        return marshaller;
    }

    @Override
    public <T> BaseMarshaller<T> getMarshaller(Class<T> clazz) {
        BaseMarshaller<?> marshaller = this.marshallersByClass.get(clazz);
        if (marshaller == null) {
            throw new IllegalArgumentException("No marshaller registered for " + clazz);
        }
        return marshaller;
    }
}

