/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.job.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jberet.util.BatchLogger;

public final class ExceptionClassFilter
implements Serializable {
    private static final long serialVersionUID = -6174512038188933722L;
    private final List<String> include = new ArrayList<String>();
    private final List<String> exclude = new ArrayList<String>();

    ExceptionClassFilter() {
    }

    public List<String> getInclude() {
        return this.include;
    }

    public List<String> getExclude() {
        return this.exclude;
    }

    void addInclude(String includeClass) {
        if (includeClass != null && includeClass.length() > 0) {
            this.include.add(includeClass);
        }
    }

    void addExclude(String excludeClass) {
        if (excludeClass != null && excludeClass.length() > 0) {
            this.exclude.add(excludeClass);
        }
    }

    public boolean matches(Class<? extends Throwable> clazz) {
        if (this.include.isEmpty()) {
            return false;
        }
        if (this.exclude.isEmpty()) {
            return this.matches(clazz, this.include);
        }
        if (!this.matches(clazz, this.include)) {
            return false;
        }
        return !this.matches(clazz, this.exclude);
    }

    private boolean matches(Class<? extends Throwable> clazz, List<String> filterClasses) {
        for (String s : filterClasses) {
            try {
                Class<? extends Throwable> c = Class.forName(s, true, clazz.getClassLoader());
                if (!c.isAssignableFrom(clazz)) continue;
                return true;
            }
            catch (ClassNotFoundException e) {
                BatchLogger.LOGGER.invalidExceptionClassFilter(e, s);
            }
        }
        return false;
    }
}

