/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import org.jberet.runtime.AbstractExecution;
import org.jberet.runtime.metric.StepMetrics;
import org.jberet.util.BatchLogger;

public final class StepExecutionImpl
extends AbstractExecution
implements StepExecution,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private long id;
    private final String stepName;
    private Serializable persistentUserData;
    private Serializable readerCheckpointInfo;
    private Serializable writerCheckpointInfo;
    private Exception exception;
    private final StepMetrics stepMetrics = new StepMetrics();
    int startCount;
    private int numOfPartitions;
    private List<Integer> partitionPropertiesIndex;
    private List<Serializable> partitionPersistentUserData;
    private List<Serializable> partitionReaderCheckpointInfo;
    private List<Serializable> partitionWriterCheckpointInfo;

    public StepExecutionImpl(String stepName) {
        this.stepName = stepName;
        this.startTime = System.currentTimeMillis();
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public StepExecutionImpl clone() throws CloneNotSupportedException {
        StepExecutionImpl result = null;
        try {
            result = (StepExecutionImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            BatchLogger.LOGGER.failToClone(e, this, "", this.stepName);
        }
        result.numOfPartitions = 0;
        result.partitionPropertiesIndex = null;
        return result;
    }

    public int getStartCount() {
        return this.startCount;
    }

    public void incrementStartCount() {
        ++this.startCount;
    }

    public void setStartCount(int startCount) {
        this.startCount = startCount;
    }

    public long getStepExecutionId() {
        return this.id;
    }

    public String getStepName() {
        return this.stepName;
    }

    public Serializable getPersistentUserData() {
        return this.persistentUserData;
    }

    public void setPersistentUserData(Serializable persistentUserData) {
        this.persistentUserData = persistentUserData;
    }

    public Metric[] getMetrics() {
        return this.stepMetrics.getMetrics();
    }

    public StepMetrics getStepMetrics() {
        return this.stepMetrics;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public void setBatchStatus(BatchStatus batchStatus) {
        super.setBatchStatus(batchStatus);
        if (batchStatus == BatchStatus.COMPLETED || batchStatus == BatchStatus.FAILED || batchStatus == BatchStatus.STOPPED) {
            this.endTime = System.currentTimeMillis();
        }
    }

    public Serializable getReaderCheckpointInfo() {
        return this.readerCheckpointInfo;
    }

    public void setReaderCheckpointInfo(Serializable readerCheckpointInfo) {
        this.readerCheckpointInfo = readerCheckpointInfo;
    }

    public Serializable getWriterCheckpointInfo() {
        return this.writerCheckpointInfo;
    }

    public void setWriterCheckpointInfo(Serializable writerCheckpointInfo) {
        this.writerCheckpointInfo = writerCheckpointInfo;
    }

    public int getNumOfPartitions() {
        return this.numOfPartitions;
    }

    public void setNumOfPartitions(int numOfPartitions) {
        this.numOfPartitions = numOfPartitions;
    }

    public List<Integer> getPartitionPropertiesIndex() {
        return this.partitionPropertiesIndex;
    }

    public void addPartitionPropertiesIndex(Integer i) {
        if (this.partitionPropertiesIndex == null) {
            this.partitionPropertiesIndex = new ArrayList<Integer>();
        }
        this.partitionPropertiesIndex.add(i);
    }

    public List<Serializable> getPartitionPersistentUserData() {
        return this.partitionPersistentUserData;
    }

    public void addPartitionPersistentUserData(Serializable d) {
        if (this.partitionPersistentUserData == null) {
            this.partitionPersistentUserData = new ArrayList<Serializable>();
        }
        this.partitionPersistentUserData.add(d);
    }

    public List<Serializable> getPartitionReaderCheckpointInfo() {
        return this.partitionReaderCheckpointInfo;
    }

    public void addPartitionReaderCheckpointInfo(Serializable s) {
        if (this.partitionReaderCheckpointInfo == null) {
            this.partitionReaderCheckpointInfo = new ArrayList<Serializable>();
        }
        this.partitionReaderCheckpointInfo.add(s);
    }

    public List<Serializable> getPartitionWriterCheckpointInfo() {
        return this.partitionWriterCheckpointInfo;
    }

    public void addPartitionWriterCheckpointInfo(Serializable s) {
        if (this.partitionWriterCheckpointInfo == null) {
            this.partitionWriterCheckpointInfo = new ArrayList<Serializable>();
        }
        this.partitionWriterCheckpointInfo.add(s);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StepExecutionImpl that = (StepExecutionImpl)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }
}

