/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.dialect.internal;

import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.jdbc.dialect.internal.DatabaseInfoDialectResolverSet;
import org.hibernate.engine.jdbc.dialect.internal.StandardDatabaseInfoDialectResolver;
import org.hibernate.engine.jdbc.dialect.spi.DatabaseInfoDialectResolver;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class DatabaseInfoDialectResolverInitiator
implements StandardServiceInitiator<DatabaseInfoDialectResolver> {
    public static final DatabaseInfoDialectResolverInitiator INSTANCE = new DatabaseInfoDialectResolverInitiator();

    @Override
    public Class<DatabaseInfoDialectResolver> getServiceInitiated() {
        return DatabaseInfoDialectResolver.class;
    }

    @Override
    public DatabaseInfoDialectResolver initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        DatabaseInfoDialectResolverSet resolver = new DatabaseInfoDialectResolverSet();
        this.applyCustomReslvers(resolver, configurationValues, registry);
        resolver.addResolver(StandardDatabaseInfoDialectResolver.INSTANCE);
        return resolver;
    }

    private void applyCustomReslvers(DatabaseInfoDialectResolverSet resolver, Map configurationValues, ServiceRegistryImplementor registry) {
        String resolverImplNames = (String)configurationValues.get("hibernate.dialect_resolvers");
        if (StringHelper.isNotEmpty(resolverImplNames)) {
            ClassLoaderService classLoaderService = registry.getService(ClassLoaderService.class);
            for (String resolverImplName : StringHelper.split(", \n\r\f\t", resolverImplNames)) {
                try {
                    resolver.addResolver((DatabaseInfoDialectResolver)classLoaderService.classForName(resolverImplName).newInstance());
                }
                catch (HibernateException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ServiceException("Unable to instantiate named dialect resolver [" + resolverImplName + "]", e);
                }
            }
        }
    }
}

