/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.custom;

import java.lang.reflect.Constructor;
import org.hibernate.loader.custom.Return;
import org.hibernate.loader.custom.ScalarReturn;

public class ConstructorReturn
implements Return {
    private final Class targetClass;
    private final ScalarReturn[] scalars;

    public ConstructorReturn(Class targetClass, ScalarReturn[] scalars) {
        this.targetClass = targetClass;
        this.scalars = scalars;
    }

    private static Constructor resolveConstructor(Class targetClass, ScalarReturn[] scalars) {
        for (Constructor<?> constructor : targetClass.getConstructors()) {
            Class<?>[] argumentTypes = constructor.getParameterTypes();
            if (argumentTypes.length != scalars.length) continue;
            boolean allMatched = true;
            for (int i = 0; i < argumentTypes.length; ++i) {
                if (!ConstructorReturn.areAssignmentCompatible(argumentTypes[i], scalars[i].getType().getReturnedClass())) continue;
                allMatched = false;
                break;
            }
            if (!allMatched) continue;
            return constructor;
        }
        throw new IllegalArgumentException("Could not locate appropriate constructor on class : " + targetClass.getName());
    }

    private static boolean areAssignmentCompatible(Class argumentType, Class typeReturnedClass) {
        return argumentType.isAssignableFrom(typeReturnedClass);
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public ScalarReturn[] getScalars() {
        return this.scalars;
    }
}

