/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.loader.DefaultEntityAliases;
import org.hibernate.loader.EntityAliases;
import org.hibernate.loader.GeneratedCollectionAliases;
import org.hibernate.loader.plan.spi.CollectionReference;
import org.hibernate.loader.plan.spi.CollectionReturn;
import org.hibernate.loader.plan.spi.CompositeElementGraph;
import org.hibernate.loader.plan.spi.CompositeIndexGraph;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.EntityReturn;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.Return;
import org.hibernate.loader.plan.spi.ScalarReturn;
import org.hibernate.loader.spi.JoinableAssociation;
import org.hibernate.loader.spi.LoadQueryAliasResolutionContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.type.EntityType;

public class LoadQueryAliasResolutionContextImpl
implements LoadQueryAliasResolutionContext {
    private final Map<Return, String[]> aliasesByReturn;
    private final Map<EntityReference, LoadQueryEntityAliasesImpl> aliasesByEntityReference = new HashMap<EntityReference, LoadQueryEntityAliasesImpl>();
    private final Map<CollectionReference, LoadQueryCollectionAliasesImpl> aliasesByCollectionReference = new HashMap<CollectionReference, LoadQueryCollectionAliasesImpl>();
    private final Map<JoinableAssociation, JoinableAssociationAliasesImpl> aliasesByJoinableAssociation = new HashMap<JoinableAssociation, JoinableAssociationAliasesImpl>();
    private final SessionFactoryImplementor sessionFactory;
    private int currentAliasSuffix = 0;

    public LoadQueryAliasResolutionContextImpl(SessionFactoryImplementor sessionFactory, int suffixSeed, Map<Return, String[]> aliasesByReturn) {
        this.sessionFactory = sessionFactory;
        this.currentAliasSuffix = suffixSeed;
        LoadQueryAliasResolutionContextImpl.checkAliasesByReturn(aliasesByReturn);
        this.aliasesByReturn = new HashMap<Return, String[]>(aliasesByReturn);
    }

    private static void checkAliasesByReturn(Map<Return, String[]> aliasesByReturn) {
        if (aliasesByReturn == null || aliasesByReturn.size() == 0) {
            throw new IllegalArgumentException("No return aliases defined");
        }
        for (Map.Entry<Return, String[]> entry : aliasesByReturn.entrySet()) {
            Return aReturn = entry.getKey();
            String[] aliases = entry.getValue();
            if (aReturn == null) {
                throw new IllegalArgumentException("null key found in aliasesByReturn");
            }
            if (aliases == null || aliases.length == 0) {
                throw new IllegalArgumentException(String.format("No alias defined for [%s]", aReturn));
            }
            if (aliases.length > 1 && (aReturn instanceof EntityReturn || aReturn instanceof CollectionReturn)) {
                throw new IllegalArgumentException(String.format("More than 1 alias defined for [%s]", aReturn));
            }
            for (String alias : aliases) {
                if (!StringHelper.isEmpty(alias)) continue;
                throw new IllegalArgumentException(String.format("An alias for [%s] is null or empty.", aReturn));
            }
        }
    }

    @Override
    public String resolveEntityReturnAlias(EntityReturn entityReturn) {
        return this.getAndCheckReturnAliasExists(entityReturn)[0];
    }

    @Override
    public String resolveCollectionReturnAlias(CollectionReturn collectionReturn) {
        return this.getAndCheckReturnAliasExists(collectionReturn)[0];
    }

    @Override
    public String[] resolveScalarReturnAliases(ScalarReturn scalarReturn) {
        throw new NotYetImplementedException("Cannot resolve scalar column aliases yet.");
    }

    private String[] getAndCheckReturnAliasExists(Return aReturn) {
        String[] aliases = this.aliasesByReturn.get(aReturn);
        if (aliases == null) {
            throw new IllegalStateException(String.format("No alias is defined for [%s]", aReturn));
        }
        return aliases;
    }

    @Override
    public String resolveEntityTableAlias(EntityReference entityReference) {
        return this.getOrGenerateLoadQueryEntityAliases(entityReference).tableAlias;
    }

    @Override
    public EntityAliases resolveEntityColumnAliases(EntityReference entityReference) {
        return this.getOrGenerateLoadQueryEntityAliases(entityReference).columnAliases;
    }

    @Override
    public String resolveCollectionTableAlias(CollectionReference collectionReference) {
        return this.getOrGenerateLoadQueryCollectionAliases(collectionReference).tableAlias;
    }

    @Override
    public CollectionAliases resolveCollectionColumnAliases(CollectionReference collectionReference) {
        return this.getOrGenerateLoadQueryCollectionAliases(collectionReference).collectionAliases;
    }

    @Override
    public EntityAliases resolveCollectionElementColumnAliases(CollectionReference collectionReference) {
        return this.getOrGenerateLoadQueryCollectionAliases(collectionReference).collectionElementAliases;
    }

    @Override
    public String resolveAssociationRhsTableAlias(JoinableAssociation joinableAssociation) {
        return this.getOrGenerateJoinAssocationAliases(joinableAssociation).rhsAlias;
    }

    @Override
    public String resolveAssociationLhsTableAlias(JoinableAssociation joinableAssociation) {
        return this.getOrGenerateJoinAssocationAliases(joinableAssociation).lhsAlias;
    }

    @Override
    public String[] resolveAssociationAliasedLhsColumnNames(JoinableAssociation joinableAssociation) {
        return this.getOrGenerateJoinAssocationAliases(joinableAssociation).aliasedLhsColumnNames;
    }

    protected SessionFactoryImplementor sessionFactory() {
        return this.sessionFactory;
    }

    private String createSuffix() {
        return Integer.toString(this.currentAliasSuffix++) + '_';
    }

    private LoadQueryEntityAliasesImpl getOrGenerateLoadQueryEntityAliases(EntityReference entityReference) {
        LoadQueryEntityAliasesImpl aliases = this.aliasesByEntityReference.get(entityReference);
        if (aliases == null) {
            EntityPersister entityPersister = entityReference.getEntityPersister();
            aliases = new LoadQueryEntityAliasesImpl(this.createTableAlias(entityPersister), this.createEntityAliases(entityPersister));
            this.aliasesByEntityReference.put(entityReference, aliases);
        }
        return aliases;
    }

    private LoadQueryCollectionAliasesImpl getOrGenerateLoadQueryCollectionAliases(CollectionReference collectionReference) {
        LoadQueryCollectionAliasesImpl aliases = this.aliasesByCollectionReference.get(collectionReference);
        if (aliases == null) {
            CollectionPersister collectionPersister = collectionReference.getCollectionPersister();
            aliases = new LoadQueryCollectionAliasesImpl(this.createTableAlias(collectionPersister.getRole()), this.createCollectionAliases(collectionPersister), this.createCollectionElementAliases(collectionPersister));
            this.aliasesByCollectionReference.put(collectionReference, aliases);
        }
        return aliases;
    }

    private JoinableAssociationAliasesImpl getOrGenerateJoinAssocationAliases(JoinableAssociation joinableAssociation) {
        JoinableAssociationAliasesImpl aliases = this.aliasesByJoinableAssociation.get(joinableAssociation);
        if (aliases == null) {
            String rhsAlias;
            String lhsAlias;
            Fetch currentFetch = joinableAssociation.getCurrentFetch();
            if (EntityReference.class.isInstance(currentFetch.getOwner())) {
                lhsAlias = this.resolveEntityTableAlias((EntityReference)((Object)currentFetch.getOwner()));
            } else if (CompositeElementGraph.class.isInstance(currentFetch.getOwner())) {
                CompositeElementGraph compositeElementGraph = (CompositeElementGraph)currentFetch.getOwner();
                lhsAlias = this.resolveCollectionTableAlias(compositeElementGraph.getCollectionReference());
            } else if (CompositeIndexGraph.class.isInstance(currentFetch.getOwner())) {
                CompositeIndexGraph compositeIndexGraph = (CompositeIndexGraph)currentFetch.getOwner();
                lhsAlias = this.resolveCollectionTableAlias(compositeIndexGraph.getCollectionReference());
            } else {
                throw new NotYetImplementedException("Cannot determine LHS alias for FetchOwner.");
            }
            String[] aliasedLhsColumnNames = currentFetch.toSqlSelectFragments(lhsAlias);
            if (EntityReference.class.isInstance(currentFetch)) {
                rhsAlias = this.resolveEntityTableAlias((EntityReference)((Object)currentFetch));
            } else if (CollectionReference.class.isInstance(joinableAssociation.getCurrentFetch())) {
                rhsAlias = this.resolveCollectionTableAlias((CollectionReference)((Object)currentFetch));
            } else {
                throw new NotYetImplementedException("Cannot determine RHS alis for a fetch that is not an EntityReference or CollectionReference.");
            }
            aliases = new JoinableAssociationAliasesImpl(lhsAlias, aliasedLhsColumnNames, rhsAlias);
            this.aliasesByJoinableAssociation.put(joinableAssociation, aliases);
        }
        return aliases;
    }

    private String createTableAlias(EntityPersister entityPersister) {
        return this.createTableAlias(StringHelper.unqualifyEntityName(entityPersister.getEntityName()));
    }

    private String createTableAlias(String name) {
        return StringHelper.generateAlias(name) + this.createSuffix();
    }

    private EntityAliases createEntityAliases(EntityPersister entityPersister) {
        return new DefaultEntityAliases((Loadable)entityPersister, this.createSuffix());
    }

    private CollectionAliases createCollectionAliases(CollectionPersister collectionPersister) {
        return new GeneratedCollectionAliases(collectionPersister, this.createSuffix());
    }

    private EntityAliases createCollectionElementAliases(CollectionPersister collectionPersister) {
        if (!collectionPersister.getElementType().isEntityType()) {
            return null;
        }
        EntityType entityElementType = (EntityType)collectionPersister.getElementType();
        return this.createEntityAliases((EntityPersister)((Object)entityElementType.getAssociatedJoinable(this.sessionFactory())));
    }

    private static class JoinableAssociationAliasesImpl {
        private final String lhsAlias;
        private final String[] aliasedLhsColumnNames;
        private final String rhsAlias;

        public JoinableAssociationAliasesImpl(String lhsAlias, String[] aliasedLhsColumnNames, String rhsAlias) {
            this.lhsAlias = lhsAlias;
            this.aliasedLhsColumnNames = aliasedLhsColumnNames;
            this.rhsAlias = rhsAlias;
        }
    }

    private static class LoadQueryCollectionAliasesImpl {
        private final String tableAlias;
        private final CollectionAliases collectionAliases;
        private final EntityAliases collectionElementAliases;

        public LoadQueryCollectionAliasesImpl(String tableAlias, CollectionAliases collectionAliases, EntityAliases collectionElementAliases) {
            this.tableAlias = tableAlias;
            this.collectionAliases = collectionAliases;
            this.collectionElementAliases = collectionElementAliases;
        }
    }

    private static class LoadQueryEntityAliasesImpl {
        private final String tableAlias;
        private final EntityAliases columnAliases;

        public LoadQueryEntityAliasesImpl(String tableAlias, EntityAliases columnAliases) {
            this.tableAlias = tableAlias;
            this.columnAliases = columnAliases;
        }
    }
}

