/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import org.hibernate.HibernateException;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan.spi.AbstractFetchOwner;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchOwner;

public abstract class AbstractSingularAttributeFetch
extends AbstractFetchOwner
implements Fetch {
    private final FetchOwner owner;
    private final String ownerProperty;
    private final FetchStrategy fetchStrategy;
    private final PropertyPath propertyPath;

    public AbstractSingularAttributeFetch(SessionFactoryImplementor factory, FetchOwner owner, String ownerProperty, FetchStrategy fetchStrategy) {
        super(factory);
        this.owner = owner;
        this.ownerProperty = ownerProperty;
        this.fetchStrategy = fetchStrategy;
        owner.addFetch(this);
        this.propertyPath = owner.getPropertyPath().append(ownerProperty);
    }

    public AbstractSingularAttributeFetch(AbstractSingularAttributeFetch original, CopyContext copyContext, FetchOwner fetchOwnerCopy) {
        super(original, copyContext);
        this.owner = fetchOwnerCopy;
        this.ownerProperty = original.ownerProperty;
        this.fetchStrategy = original.fetchStrategy;
        this.propertyPath = original.propertyPath;
    }

    @Override
    public FetchOwner getOwner() {
        return this.owner;
    }

    @Override
    public String getOwnerPropertyName() {
        return this.ownerProperty;
    }

    @Override
    public boolean isNullable() {
        return this.owner.isNullable(this);
    }

    @Override
    public String[] toSqlSelectFragments(String alias) {
        return this.owner.toSqlSelectFragments(this, alias);
    }

    @Override
    public FetchStrategy getFetchStrategy() {
        return this.fetchStrategy;
    }

    @Override
    public void validateFetchPlan(FetchStrategy fetchStrategy) {
        if (fetchStrategy.getStyle() == FetchStyle.JOIN && this.fetchStrategy.getStyle() != FetchStyle.JOIN) {
            throw new HibernateException("Cannot specify join fetch from owner that is a non-joined fetch");
        }
    }

    @Override
    public PropertyPath getPropertyPath() {
        return this.propertyPath;
    }

    public String toString() {
        return "Fetch(" + this.propertyPath.getFullPath() + ")";
    }
}

