/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.plan.spi.AbstractCollectionReference;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchOwner;
import org.hibernate.loader.spi.ResultSetProcessingContext;

public class CollectionFetch
extends AbstractCollectionReference
implements Fetch {
    private final FetchOwner fetchOwner;
    private final FetchStrategy fetchStrategy;

    public CollectionFetch(SessionFactoryImplementor sessionFactory, LockMode lockMode, FetchOwner fetchOwner, FetchStrategy fetchStrategy, String ownerProperty) {
        super(sessionFactory, lockMode, sessionFactory.getCollectionPersister(fetchOwner.retrieveFetchSourcePersister().getEntityName() + '.' + ownerProperty), fetchOwner.getPropertyPath().append(ownerProperty));
        this.fetchOwner = fetchOwner;
        this.fetchStrategy = fetchStrategy;
        fetchOwner.addFetch(this);
    }

    protected CollectionFetch(CollectionFetch original, CopyContext copyContext, FetchOwner fetchOwnerCopy) {
        super(original, copyContext);
        this.fetchOwner = fetchOwnerCopy;
        this.fetchStrategy = original.fetchStrategy;
    }

    @Override
    public FetchOwner getOwner() {
        return this.fetchOwner;
    }

    @Override
    public String getOwnerPropertyName() {
        return this.getPropertyPath().getProperty();
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public String[] toSqlSelectFragments(String alias) {
        return this.getOwner().toSqlSelectFragments(this, alias);
    }

    @Override
    public FetchStrategy getFetchStrategy() {
        return this.fetchStrategy;
    }

    @Override
    public void hydrate(ResultSet resultSet, ResultSetProcessingContext context) throws SQLException {
    }

    @Override
    public Object resolve(ResultSet resultSet, ResultSetProcessingContext context) throws SQLException {
        return null;
    }

    @Override
    public CollectionFetch makeCopy(CopyContext copyContext, FetchOwner fetchOwnerCopy) {
        copyContext.getReturnGraphVisitationStrategy().startingCollectionFetch(this);
        CollectionFetch copy = new CollectionFetch(this, copyContext, fetchOwnerCopy);
        copyContext.getReturnGraphVisitationStrategy().finishingCollectionFetch(this);
        return copy;
    }
}

