/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.plan.spi.AbstractSingularAttributeFetch;
import org.hibernate.loader.plan.spi.CompositeFetchOwnerDelegate;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.FetchOwner;
import org.hibernate.loader.plan.spi.FetchOwnerDelegate;
import org.hibernate.loader.spi.ResultSetProcessingContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.CompositeType;

public class CompositeFetch
extends AbstractSingularAttributeFetch {
    private static final FetchStrategy FETCH_PLAN = new FetchStrategy(FetchTiming.IMMEDIATE, FetchStyle.JOIN);
    private final FetchOwnerDelegate delegate;

    public CompositeFetch(SessionFactoryImplementor sessionFactory, final FetchOwner owner, String ownerProperty) {
        super(sessionFactory, owner, ownerProperty, FETCH_PLAN);
        this.delegate = new CompositeFetchOwnerDelegate(sessionFactory, (CompositeType)this.getOwner().getType(this), new CompositeFetchOwnerDelegate.PropertyMappingDelegate(){

            @Override
            public String[] toSqlSelectFragments(String alias) {
                return owner.toSqlSelectFragments(CompositeFetch.this, alias);
            }
        });
    }

    public CompositeFetch(CompositeFetch original, CopyContext copyContext, FetchOwner fetchOwnerCopy) {
        super(original, copyContext, fetchOwnerCopy);
        this.delegate = original.getFetchOwnerDelegate();
    }

    @Override
    protected FetchOwnerDelegate getFetchOwnerDelegate() {
        return this.delegate;
    }

    @Override
    public EntityPersister retrieveFetchSourcePersister() {
        return this.getOwner().retrieveFetchSourcePersister();
    }

    @Override
    public void hydrate(ResultSet resultSet, ResultSetProcessingContext context) throws SQLException {
    }

    @Override
    public Object resolve(ResultSet resultSet, ResultSetProcessingContext context) throws SQLException {
        return null;
    }

    @Override
    public CompositeFetch makeCopy(CopyContext copyContext, FetchOwner fetchOwnerCopy) {
        copyContext.getReturnGraphVisitationStrategy().startingCompositeFetch(this);
        CompositeFetch copy = new CompositeFetch(this, copyContext, fetchOwnerCopy);
        copyContext.getReturnGraphVisitationStrategy().finishingCompositeFetch(this);
        return copy;
    }
}

