/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import java.util.Arrays;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.plan.spi.AbstractFetchOwnerDelegate;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchOwnerDelegate;
import org.hibernate.persister.walking.spi.WalkingException;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public class CompositeFetchOwnerDelegate
extends AbstractFetchOwnerDelegate
implements FetchOwnerDelegate {
    private final SessionFactoryImplementor sessionFactory;
    private final CompositeType compositeType;
    private final PropertyMappingDelegate propertyMappingDelegate;

    public CompositeFetchOwnerDelegate(SessionFactoryImplementor sessionFactory, CompositeType compositeType, PropertyMappingDelegate propertyMappingDelegate) {
        this.sessionFactory = sessionFactory;
        this.compositeType = compositeType;
        this.propertyMappingDelegate = propertyMappingDelegate;
    }

    @Override
    protected FetchOwnerDelegate.FetchMetadata buildFetchMetadata(Fetch fetch) {
        int subIndex = -1;
        int selectFragmentRangeStart = 0;
        int selectFragmentRangeEnd = -1;
        for (int i = 0; i < this.compositeType.getPropertyNames().length; ++i) {
            Type type = this.compositeType.getSubtypes()[i];
            int typeColSpan = type.getColumnSpan(this.sessionFactory);
            if (this.compositeType.getPropertyNames()[i].equals(fetch.getOwnerPropertyName())) {
                subIndex = i;
                selectFragmentRangeEnd = selectFragmentRangeStart + typeColSpan;
                break;
            }
            selectFragmentRangeStart += typeColSpan;
        }
        if (subIndex < 0) {
            throw new WalkingException(String.format("Owner property [%s] not found in composite properties [%s]", fetch.getOwnerPropertyName(), Arrays.asList(this.compositeType.getPropertyNames())));
        }
        return new FetchMetadataImpl(this.compositeType, subIndex, this.propertyMappingDelegate, selectFragmentRangeStart, selectFragmentRangeEnd);
    }

    private static class FetchMetadataImpl
    implements FetchOwnerDelegate.FetchMetadata {
        private final CompositeType compositeType;
        private final int index;
        private final PropertyMappingDelegate propertyMappingDelegate;
        private final int selectFragmentRangeStart;
        private final int selectFragmentRangeEnd;

        public FetchMetadataImpl(CompositeType compositeType, int index, PropertyMappingDelegate propertyMappingDelegate, int selectFragmentRangeStart, int selectFragmentRangeEnd) {
            this.compositeType = compositeType;
            this.index = index;
            this.propertyMappingDelegate = propertyMappingDelegate;
            this.selectFragmentRangeStart = selectFragmentRangeStart;
            this.selectFragmentRangeEnd = selectFragmentRangeEnd;
        }

        @Override
        public boolean isNullable() {
            return this.compositeType.getPropertyNullability()[this.index];
        }

        @Override
        public Type getType() {
            return this.compositeType.getSubtypes()[this.index];
        }

        @Override
        public String[] toSqlSelectFragments(String alias) {
            return Arrays.copyOfRange(this.propertyMappingDelegate.toSqlSelectFragments(alias), this.selectFragmentRangeStart, this.selectFragmentRangeEnd);
        }
    }

    public static interface PropertyMappingDelegate {
        public String[] toSqlSelectFragments(String var1);
    }
}

