/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import java.util.Arrays;
import org.hibernate.loader.plan.spi.AbstractFetchOwnerDelegate;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchOwnerDelegate;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.walking.spi.WalkingException;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public class EntityFetchOwnerDelegate
extends AbstractFetchOwnerDelegate
implements FetchOwnerDelegate {
    private final EntityPersister entityPersister;

    public EntityFetchOwnerDelegate(EntityPersister entityPersister) {
        this.entityPersister = entityPersister;
    }

    @Override
    protected FetchOwnerDelegate.FetchMetadata buildFetchMetadata(Fetch fetch) {
        Integer propertyIndex = this.entityPersister.getEntityMetamodel().getPropertyIndexOrNull(fetch.getOwnerPropertyName());
        if (propertyIndex == null) {
            Type idType = this.entityPersister.getIdentifierType();
            if (CompositeType.class.isInstance(idType)) {
                CompositeType cidType = (CompositeType)idType;
                if (this.entityPersister.hasIdentifierProperty()) {
                    throw new WalkingException("Expecting different FetchOwnerDelegate type for encapsulated composite id case");
                }
                return new NonEncapsulatedIdentifierAttributeFetchMetadata(this.entityPersister, cidType, fetch.getOwnerPropertyName());
            }
        } else {
            return new NonIdentifierAttributeFetchMetadata(this.entityPersister, fetch.getOwnerPropertyName(), propertyIndex);
        }
        throw new WalkingException("Could not locate metadata about given fetch [" + fetch + "] in its owning persister");
    }

    private class NonEncapsulatedIdentifierAttributeFetchMetadata
    implements FetchOwnerDelegate.FetchMetadata {
        private final EntityPersister entityPersister;
        private final String attributeName;
        private Type type;
        private int selectFragmentRangeStart;
        private int selectFragmentRangeEnd;

        public NonEncapsulatedIdentifierAttributeFetchMetadata(EntityPersister entityPersister, CompositeType cidType, String attributeName) {
            this.entityPersister = entityPersister;
            this.attributeName = attributeName;
            this.selectFragmentRangeStart = 0;
            boolean foundIt = false;
            for (int i = 0; i < cidType.getPropertyNames().length; ++i) {
                Type subType = cidType.getSubtypes()[i];
                if (cidType.getPropertyNames()[i].equals(attributeName)) {
                    foundIt = true;
                    this.type = subType;
                    break;
                }
                this.selectFragmentRangeStart += subType.getColumnSpan(entityPersister.getFactory());
            }
            if (!foundIt) {
                throw new WalkingException("Could not find ");
            }
            this.selectFragmentRangeEnd = this.selectFragmentRangeStart + this.type.getColumnSpan(entityPersister.getFactory());
        }

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public String[] toSqlSelectFragments(String alias) {
            return Arrays.copyOfRange(((Queryable)this.entityPersister).toColumns(alias, this.attributeName), this.selectFragmentRangeStart, this.selectFragmentRangeEnd);
        }
    }

    private class NonIdentifierAttributeFetchMetadata
    implements FetchOwnerDelegate.FetchMetadata {
        private final EntityPersister entityPersister;
        private final String attributeName;
        private final int propertyIndex;
        private Type attributeType;

        public NonIdentifierAttributeFetchMetadata(EntityPersister entityPersister, String attributeName, int propertyIndex) {
            this.entityPersister = entityPersister;
            this.attributeName = attributeName;
            this.propertyIndex = propertyIndex;
        }

        @Override
        public boolean isNullable() {
            return this.entityPersister.getPropertyNullability()[this.propertyIndex];
        }

        @Override
        public Type getType() {
            if (this.attributeType == null) {
                this.attributeType = this.entityPersister.getPropertyTypes()[this.propertyIndex];
            }
            return this.attributeType;
        }

        @Override
        public String[] toSqlSelectFragments(String alias) {
            Queryable queryable = (Queryable)this.entityPersister;
            return queryable.toColumns(alias, this.attributeName);
        }
    }
}

