/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi.build;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan.spi.AbstractFetchOwner;
import org.hibernate.loader.plan.spi.AbstractFetchOwnerDelegate;
import org.hibernate.loader.plan.spi.AbstractPlanNode;
import org.hibernate.loader.plan.spi.CollectionFetch;
import org.hibernate.loader.plan.spi.CollectionReference;
import org.hibernate.loader.plan.spi.CollectionReturn;
import org.hibernate.loader.plan.spi.CompositeElementGraph;
import org.hibernate.loader.plan.spi.CompositeFetch;
import org.hibernate.loader.plan.spi.EntityFetch;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.EntityReturn;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchOwner;
import org.hibernate.loader.plan.spi.FetchOwnerDelegate;
import org.hibernate.loader.plan.spi.IdentifierDescription;
import org.hibernate.loader.plan.spi.Return;
import org.hibernate.loader.plan.spi.build.LoadPlanBuilderStrategy;
import org.hibernate.loader.plan.spi.build.LoadPlanBuildingContext;
import org.hibernate.loader.spi.ResultSetProcessingContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.spi.HydratedCompoundValueHandler;
import org.hibernate.persister.walking.spi.AssociationAttributeDefinition;
import org.hibernate.persister.walking.spi.AttributeDefinition;
import org.hibernate.persister.walking.spi.CollectionDefinition;
import org.hibernate.persister.walking.spi.CollectionElementDefinition;
import org.hibernate.persister.walking.spi.CollectionIndexDefinition;
import org.hibernate.persister.walking.spi.CompositeCollectionElementDefinition;
import org.hibernate.persister.walking.spi.CompositionDefinition;
import org.hibernate.persister.walking.spi.EntityDefinition;
import org.hibernate.persister.walking.spi.EntityIdentifierDefinition;
import org.hibernate.persister.walking.spi.WalkingException;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;
import org.jboss.logging.MDC;

public abstract class AbstractLoadPlanBuilderStrategy
implements LoadPlanBuilderStrategy,
LoadPlanBuildingContext {
    private static final Logger log = Logger.getLogger(AbstractLoadPlanBuilderStrategy.class);
    private static final String MDC_KEY = "hibernateLoadPlanWalkPath";
    private final SessionFactoryImplementor sessionFactory;
    private ArrayDeque<FetchOwner> fetchOwnerStack = new ArrayDeque();
    private ArrayDeque<CollectionReference> collectionReferenceStack = new ArrayDeque();

    protected AbstractLoadPlanBuilderStrategy(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactoryImplementor sessionFactory() {
        return this.sessionFactory;
    }

    protected FetchOwner currentFetchOwner() {
        return this.fetchOwnerStack.peekFirst();
    }

    @Override
    public void start() {
        if (!this.fetchOwnerStack.isEmpty()) {
            throw new WalkingException("Fetch owner stack was not empty on start; be sure to not use LoadPlanBuilderStrategy instances concurrently");
        }
        if (!this.collectionReferenceStack.isEmpty()) {
            throw new WalkingException("Collection reference stack was not empty on start; be sure to not use LoadPlanBuilderStrategy instances concurrently");
        }
        MDC.put((String)MDC_KEY, (Object)new MDCStack());
    }

    @Override
    public void finish() {
        MDC.remove((String)MDC_KEY);
        this.fetchOwnerStack.clear();
        this.collectionReferenceStack.clear();
    }

    @Override
    public void startingEntity(EntityDefinition entityDefinition) {
        log.tracef("%s Starting entity : %s", (Object)StringHelper.repeat(">>", this.fetchOwnerStack.size()), (Object)entityDefinition.getEntityPersister().getEntityName());
        if (this.fetchOwnerStack.isEmpty()) {
            if (!this.supportsRootEntityReturns()) {
                throw new HibernateException("This strategy does not support root entity returns");
            }
            EntityReturn entityReturn = this.buildRootEntityReturn(entityDefinition);
            this.addRootReturn(entityReturn);
            this.pushToStack(entityReturn);
        }
    }

    protected boolean supportsRootEntityReturns() {
        return false;
    }

    protected abstract void addRootReturn(Return var1);

    @Override
    public void finishingEntity(EntityDefinition entityDefinition) {
        FetchOwner poppedFetchOwner = this.popFromStack();
        if (!EntityReference.class.isInstance(poppedFetchOwner)) {
            throw new WalkingException("Mismatched FetchOwner from stack on pop");
        }
        EntityReference entityReference = (EntityReference)((Object)poppedFetchOwner);
        if (!entityReference.getEntityPersister().equals(entityDefinition.getEntityPersister())) {
            throw new WalkingException("Mismatched FetchOwner from stack on pop");
        }
        log.tracef("%s Finished entity : %s", (Object)StringHelper.repeat("<<", this.fetchOwnerStack.size()), (Object)entityDefinition.getEntityPersister().getEntityName());
    }

    @Override
    public void startingEntityIdentifier(EntityIdentifierDefinition entityIdentifierDefinition) {
        log.tracef("%s Starting entity identifier : %s", (Object)StringHelper.repeat(">>", this.fetchOwnerStack.size()), (Object)entityIdentifierDefinition.getEntityDefinition().getEntityPersister().getEntityName());
        EntityReference entityReference = (EntityReference)((Object)this.currentFetchOwner());
        if (!entityReference.getEntityPersister().equals(entityIdentifierDefinition.getEntityDefinition().getEntityPersister())) {
            throw new WalkingException(String.format("Encountered unexpected fetch owner [%s] in stack while processing entity identifier for [%s]", entityReference.getEntityPersister().getEntityName(), entityIdentifierDefinition.getEntityDefinition().getEntityPersister().getEntityName()));
        }
        AbstractIdentifierAttributeCollector identifierAttributeCollector = entityIdentifierDefinition.isEncapsulated() ? new EncapsulatedIdentifierAttributeCollector(this.sessionFactory, entityReference) : new NonEncapsulatedIdentifierAttributeCollector(this.sessionFactory, entityReference);
        this.pushToStack(identifierAttributeCollector);
    }

    @Override
    public void finishingEntityIdentifier(EntityIdentifierDefinition entityIdentifierDefinition) {
        FetchOwner poppedFetchOwner = this.popFromStack();
        if (!AbstractIdentifierAttributeCollector.class.isInstance(poppedFetchOwner)) {
            throw new WalkingException("Unexpected state in FetchOwner stack");
        }
        EntityReference entityReference = (EntityReference)((Object)poppedFetchOwner);
        if (!entityReference.getEntityPersister().equals(entityIdentifierDefinition.getEntityDefinition().getEntityPersister())) {
            throw new WalkingException(String.format("Encountered unexpected fetch owner [%s] in stack while processing entity identifier for [%s]", entityReference.getEntityPersister().getEntityName(), entityIdentifierDefinition.getEntityDefinition().getEntityPersister().getEntityName()));
        }
        FetchOwner currentFetchOwner = this.currentFetchOwner();
        if (!EntityReference.class.isInstance(currentFetchOwner)) {
            throw new WalkingException("Unexpected state in FetchOwner stack");
        }
        entityReference = (EntityReference)((Object)currentFetchOwner);
        if (!entityReference.getEntityPersister().equals(entityIdentifierDefinition.getEntityDefinition().getEntityPersister())) {
            throw new WalkingException(String.format("Encountered unexpected fetch owner [%s] in stack while processing entity identifier for [%s]", entityReference.getEntityPersister().getEntityName(), entityIdentifierDefinition.getEntityDefinition().getEntityPersister().getEntityName()));
        }
        log.tracef("%s Finished entity identifier : %s", (Object)StringHelper.repeat("<<", this.fetchOwnerStack.size()), (Object)entityIdentifierDefinition.getEntityDefinition().getEntityPersister().getEntityName());
    }

    @Override
    public void startingCollection(CollectionDefinition collectionDefinition) {
        log.tracef("%s Starting collection : %s", (Object)StringHelper.repeat(">>", this.fetchOwnerStack.size()), (Object)collectionDefinition.getCollectionPersister().getRole());
        if (this.fetchOwnerStack.isEmpty()) {
            if (!this.supportsRootCollectionReturns()) {
                throw new HibernateException("This strategy does not support root collection returns");
            }
            CollectionReturn collectionReturn = this.buildRootCollectionReturn(collectionDefinition);
            this.addRootReturn(collectionReturn);
            this.pushToCollectionStack(collectionReturn);
        }
    }

    protected boolean supportsRootCollectionReturns() {
        return false;
    }

    @Override
    public void startingCollectionIndex(CollectionIndexDefinition collectionIndexDefinition) {
        Type indexType = collectionIndexDefinition.getType();
        if (indexType.isAssociationType() || indexType.isComponentType()) {
            CollectionReference collectionReference = this.collectionReferenceStack.peekFirst();
            FetchOwner indexGraph = collectionReference.getIndexGraph();
            if (indexGraph == null) {
                throw new WalkingException("Collection reference did not return index handler");
            }
            this.pushToStack(indexGraph);
        }
    }

    @Override
    public void finishingCollectionIndex(CollectionIndexDefinition collectionIndexDefinition) {
    }

    @Override
    public void startingCollectionElements(CollectionElementDefinition elementDefinition) {
        if (elementDefinition.getType().isAssociationType() || elementDefinition.getType().isComponentType()) {
            CollectionReference collectionReference = this.collectionReferenceStack.peekFirst();
            FetchOwner elementGraph = collectionReference.getElementGraph();
            if (elementGraph == null) {
                throw new WalkingException("Collection reference did not return element handler");
            }
            this.pushToStack(elementGraph);
        }
    }

    @Override
    public void finishingCollectionElements(CollectionElementDefinition elementDefinition) {
    }

    @Override
    public void startingCompositeCollectionElement(CompositeCollectionElementDefinition compositeElementDefinition) {
        System.out.println(String.format("%s Starting composite collection element for (%s)", StringHelper.repeat(">>", this.fetchOwnerStack.size()), compositeElementDefinition.getCollectionDefinition().getCollectionPersister().getRole()));
    }

    @Override
    public void finishingCompositeCollectionElement(CompositeCollectionElementDefinition compositeElementDefinition) {
        FetchOwner poppedFetchOwner = this.popFromStack();
        if (!CompositeElementGraph.class.isInstance(poppedFetchOwner)) {
            throw new WalkingException("Mismatched FetchOwner from stack on pop");
        }
        log.tracef("%s Finished composite element for  : %s", (Object)StringHelper.repeat("<<", this.fetchOwnerStack.size()), (Object)compositeElementDefinition.getCollectionDefinition().getCollectionPersister().getRole());
    }

    @Override
    public void finishingCollection(CollectionDefinition collectionDefinition) {
        CollectionReference collectionReference = this.popFromCollectionStack();
        if (!collectionReference.getCollectionPersister().equals(collectionDefinition.getCollectionPersister())) {
            throw new WalkingException("Mismatched FetchOwner from stack on pop");
        }
        log.tracef("%s Finished collection : %s", (Object)StringHelper.repeat("<<", this.fetchOwnerStack.size()), (Object)collectionDefinition.getCollectionPersister().getRole());
    }

    @Override
    public void startingComposite(CompositionDefinition compositionDefinition) {
        log.tracef("%s Starting composition : %s", (Object)StringHelper.repeat(">>", this.fetchOwnerStack.size()), (Object)compositionDefinition.getName());
        if (this.fetchOwnerStack.isEmpty()) {
            throw new HibernateException("A component cannot be the root of a walk nor a graph");
        }
    }

    @Override
    public void finishingComposite(CompositionDefinition compositionDefinition) {
        FetchOwner poppedFetchOwner = this.popFromStack();
        if (!CompositeFetch.class.isInstance(poppedFetchOwner)) {
            throw new WalkingException("Mismatched FetchOwner from stack on pop");
        }
        log.tracef("%s Finished composition : %s", (Object)StringHelper.repeat("<<", this.fetchOwnerStack.size()), (Object)compositionDefinition.getName());
    }

    @Override
    public boolean startingAttribute(AttributeDefinition attributeDefinition) {
        boolean isBasicType;
        log.tracef("%s Starting attribute %s", (Object)StringHelper.repeat(">>", this.fetchOwnerStack.size()), (Object)attributeDefinition);
        Type attributeType = attributeDefinition.getType();
        boolean isComponentType = attributeType.isComponentType();
        boolean bl = isBasicType = !isComponentType && !attributeType.isAssociationType();
        if (isBasicType) {
            return true;
        }
        if (isComponentType) {
            return this.handleCompositeAttribute((CompositionDefinition)attributeDefinition);
        }
        return this.handleAssociationAttribute((AssociationAttributeDefinition)attributeDefinition);
    }

    @Override
    public void finishingAttribute(AttributeDefinition attributeDefinition) {
        log.tracef("%s Finishing up attribute : %s", (Object)StringHelper.repeat("<<", this.fetchOwnerStack.size()), (Object)attributeDefinition);
    }

    protected boolean handleCompositeAttribute(CompositionDefinition attributeDefinition) {
        FetchOwner fetchOwner = this.currentFetchOwner();
        CompositeFetch fetch = fetchOwner.buildCompositeFetch(attributeDefinition, this);
        this.pushToStack(fetch);
        return true;
    }

    protected boolean handleAssociationAttribute(AssociationAttributeDefinition attributeDefinition) {
        AbstractPlanNode associationFetch;
        FetchStrategy fetchStrategy = this.determineFetchPlan(attributeDefinition);
        if (fetchStrategy.getTiming() != FetchTiming.IMMEDIATE) {
            return false;
        }
        FetchOwner fetchOwner = this.currentFetchOwner();
        fetchOwner.validateFetchPlan(fetchStrategy);
        if (attributeDefinition.isCollection()) {
            associationFetch = fetchOwner.buildCollectionFetch(attributeDefinition, fetchStrategy, this);
            this.pushToCollectionStack((CollectionReference)((Object)associationFetch));
        } else {
            associationFetch = fetchOwner.buildEntityFetch(attributeDefinition, fetchStrategy, this);
        }
        if (FetchOwner.class.isInstance(associationFetch)) {
            this.pushToStack((FetchOwner)((Object)associationFetch));
        }
        return true;
    }

    protected abstract FetchStrategy determineFetchPlan(AssociationAttributeDefinition var1);

    protected int currentDepth() {
        return this.fetchOwnerStack.size();
    }

    protected boolean isTooManyCollections() {
        return false;
    }

    private void pushToStack(FetchOwner fetchOwner) {
        log.trace((Object)("Pushing fetch owner to stack : " + fetchOwner));
        this.mdcStack().push(fetchOwner.getPropertyPath());
        this.fetchOwnerStack.addFirst(fetchOwner);
    }

    private MDCStack mdcStack() {
        return (MDCStack)MDC.get((String)MDC_KEY);
    }

    private FetchOwner popFromStack() {
        FetchOwner last = this.fetchOwnerStack.removeFirst();
        log.trace((Object)("Popped fetch owner from stack : " + last));
        this.mdcStack().pop();
        if (FetchStackAware.class.isInstance(last)) {
            ((FetchStackAware)((Object)last)).poppedFromStack();
        }
        return last;
    }

    private void pushToCollectionStack(CollectionReference collectionReference) {
        log.trace((Object)("Pushing collection reference to stack : " + collectionReference));
        this.mdcStack().push(collectionReference.getPropertyPath());
        this.collectionReferenceStack.addFirst(collectionReference);
    }

    private CollectionReference popFromCollectionStack() {
        CollectionReference last = this.collectionReferenceStack.removeFirst();
        log.trace((Object)("Popped collection reference from stack : " + last));
        this.mdcStack().pop();
        if (FetchStackAware.class.isInstance(last)) {
            ((FetchStackAware)((Object)last)).poppedFromStack();
        }
        return last;
    }

    protected abstract EntityReturn buildRootEntityReturn(EntityDefinition var1);

    protected abstract CollectionReturn buildRootCollectionReturn(CollectionDefinition var1);

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory();
    }

    private static void resolveIdentifierFetch(ResultSet resultSet, ResultSetProcessingContext context, Fetch fetch) throws SQLException {
        if (fetch instanceof EntityFetch) {
            EntityFetch entityFetch = (EntityFetch)fetch;
            ResultSetProcessingContext.IdentifierResolutionContext identifierResolutionContext = context.getIdentifierResolutionContext(entityFetch);
            if (identifierResolutionContext.getEntityKey() != null) {
                return;
            }
            EntityKey fetchKey = entityFetch.resolveInIdentifier(resultSet, context);
            identifierResolutionContext.registerEntityKey(fetchKey);
        } else if (fetch instanceof CompositeFetch) {
            for (Fetch subFetch : ((CompositeFetch)fetch).getFetches()) {
                AbstractLoadPlanBuilderStrategy.resolveIdentifierFetch(resultSet, context, subFetch);
            }
        }
    }

    public static class MDCStack {
        private ArrayDeque<PropertyPath> pathStack = new ArrayDeque();

        public void push(PropertyPath path) {
            this.pathStack.addFirst(path);
        }

        public void pop() {
            this.pathStack.removeFirst();
        }

        public String toString() {
            PropertyPath path = this.pathStack.peekFirst();
            return path == null ? "<no-path>" : path.getFullPath();
        }
    }

    private static class IdentifierDescriptionImpl
    implements IdentifierDescription {
        private final EntityReference entityReference;
        private final Fetch[] identifierFetches;
        private final Map<Fetch, HydratedCompoundValueHandler> fetchToHydratedStateExtractorMap;

        private IdentifierDescriptionImpl(EntityReference entityReference, Fetch[] identifierFetches, Map<Fetch, HydratedCompoundValueHandler> fetchToHydratedStateExtractorMap) {
            this.entityReference = entityReference;
            this.identifierFetches = identifierFetches;
            this.fetchToHydratedStateExtractorMap = fetchToHydratedStateExtractorMap;
        }

        @Override
        public Fetch[] getFetches() {
            return this.identifierFetches;
        }

        @Override
        public void hydrate(ResultSet resultSet, ResultSetProcessingContext context) throws SQLException {
            ResultSetProcessingContext.IdentifierResolutionContext ownerIdentifierResolutionContext = context.getIdentifierResolutionContext(this.entityReference);
            Object ownerIdentifierHydratedState = ownerIdentifierResolutionContext.getHydratedForm();
            if (ownerIdentifierHydratedState != null) {
                for (Fetch fetch : this.identifierFetches) {
                    if (fetch instanceof EntityFetch) {
                        ResultSetProcessingContext.IdentifierResolutionContext identifierResolutionContext = context.getIdentifierResolutionContext((EntityFetch)fetch);
                        if (identifierResolutionContext.getHydratedForm() != null) continue;
                        if (this.fetchToHydratedStateExtractorMap != null && ownerIdentifierHydratedState != null) {
                            Serializable extracted = (Serializable)this.fetchToHydratedStateExtractorMap.get(fetch).extract(ownerIdentifierHydratedState);
                            identifierResolutionContext.registerHydratedForm(extracted);
                            continue;
                        }
                        fetch.hydrate(resultSet, context);
                        continue;
                    }
                    throw new NotYetImplementedException("Cannot hydrate identifier Fetch that is not an EntityFetch");
                }
                return;
            }
            Object hydratedIdentifierState = this.entityReference.getEntityPersister().getIdentifierType().hydrate(resultSet, context.getLoadQueryAliasResolutionContext().resolveEntityColumnAliases(this.entityReference).getSuffixedKeyAliases(), context.getSession(), null);
            context.getIdentifierResolutionContext(this.entityReference).registerHydratedForm(hydratedIdentifierState);
        }

        @Override
        public EntityKey resolve(ResultSet resultSet, ResultSetProcessingContext context) throws SQLException {
            for (Fetch fetch : this.identifierFetches) {
                AbstractLoadPlanBuilderStrategy.resolveIdentifierFetch(resultSet, context, fetch);
            }
            ResultSetProcessingContext.IdentifierResolutionContext ownerIdentifierResolutionContext = context.getIdentifierResolutionContext(this.entityReference);
            Object hydratedState = ownerIdentifierResolutionContext.getHydratedForm();
            Serializable resolvedId = (Serializable)this.entityReference.getEntityPersister().getIdentifierType().resolve(hydratedState, context.getSession(), null);
            return context.getSession().generateEntityKey(resolvedId, this.entityReference.getEntityPersister());
        }
    }

    protected static class NonEncapsulatedIdentifierAttributeCollector
    extends AbstractIdentifierAttributeCollector {
        private final PropertyPath propertyPath;
        private final FetchOwnerDelegate fetchOwnerDelegate;

        public NonEncapsulatedIdentifierAttributeCollector(SessionFactoryImplementor sessionfactory, final EntityReference entityReference) {
            super(sessionfactory, entityReference);
            this.propertyPath = ((FetchOwner)((Object)entityReference)).getPropertyPath().append("<id>");
            this.fetchOwnerDelegate = new AbstractFetchOwnerDelegate(){
                final boolean isCompositeType;
                final CompositeType idType;
                {
                    this.isCompositeType = entityReference.getEntityPersister().getIdentifierType().isComponentType();
                    this.idType = (CompositeType)entityReference.getEntityPersister().getIdentifierType();
                }

                @Override
                protected FetchOwnerDelegate.FetchMetadata buildFetchMetadata(Fetch fetch) {
                    if (!this.isCompositeType) {
                        throw new WalkingException("Non-composite identifier cannot be a fetch owner");
                    }
                    final int subPropertyIndex = this.locateSubPropertyIndex(this.idType, fetch.getOwnerPropertyName());
                    return new FetchOwnerDelegate.FetchMetadata(){
                        final Type subType;
                        {
                            this.subType = idType.getSubtypes()[subPropertyIndex];
                        }

                        @Override
                        public boolean isNullable() {
                            return false;
                        }

                        @Override
                        public Type getType() {
                            return this.subType;
                        }

                        @Override
                        public String[] toSqlSelectFragments(String alias) {
                            throw new WalkingException("Should not be called");
                        }
                    };
                }

                private int locateSubPropertyIndex(CompositeType idType, String ownerPropertyName) {
                    for (int i = 0; i < idType.getPropertyNames().length; ++i) {
                        if (!ownerPropertyName.equals(idType.getPropertyNames()[i])) continue;
                        return i;
                    }
                    throw new IllegalStateException(String.format("Unable to locate fetched attribute [%s] as part of composite identifier [%s]", ownerPropertyName, NonEncapsulatedIdentifierAttributeCollector.this.getPropertyPath().getFullPath()));
                }
            };
        }

        @Override
        protected IdentifierDescription buildIdentifierDescription() {
            return new IdentifierDescriptionImpl(this.entityReference, this.getFetches(), this.fetchToHydratedStateExtractorMap);
        }

        @Override
        public PropertyPath getPropertyPath() {
            return this.propertyPath;
        }

        @Override
        protected FetchOwnerDelegate getFetchOwnerDelegate() {
            return this.fetchOwnerDelegate;
        }
    }

    protected static class EncapsulatedIdentifierAttributeCollector
    extends AbstractIdentifierAttributeCollector {
        private final PropertyPath propertyPath;
        private final FetchOwnerDelegate delegate;

        public EncapsulatedIdentifierAttributeCollector(SessionFactoryImplementor sessionFactory, final EntityReference entityReference) {
            super(sessionFactory, entityReference);
            this.propertyPath = ((FetchOwner)((Object)entityReference)).getPropertyPath();
            this.delegate = new AbstractFetchOwnerDelegate(){
                final boolean isCompositeType;
                {
                    this.isCompositeType = entityReference.getEntityPersister().getIdentifierType().isComponentType();
                }

                @Override
                protected FetchOwnerDelegate.FetchMetadata buildFetchMetadata(Fetch fetch) {
                    if (!this.isCompositeType) {
                        throw new WalkingException("Non-composite identifier cannot be a fetch owner");
                    }
                    if (!fetch.getOwnerPropertyName().equals(entityReference.getEntityPersister().getIdentifierPropertyName())) {
                        throw new IllegalArgumentException(String.format("Fetch owner property name [%s] is not the same as the identifier prop" + fetch.getOwnerPropertyName(), entityReference.getEntityPersister().getIdentifierPropertyName()));
                    }
                    return new FetchOwnerDelegate.FetchMetadata(){

                        @Override
                        public boolean isNullable() {
                            return false;
                        }

                        @Override
                        public Type getType() {
                            return entityReference.getEntityPersister().getIdentifierType();
                        }

                        @Override
                        public String[] toSqlSelectFragments(String alias) {
                            throw new WalkingException("Should not be called");
                        }
                    };
                }
            };
        }

        @Override
        protected IdentifierDescription buildIdentifierDescription() {
            return new IdentifierDescriptionImpl(this.entityReference, this.getFetches(), null);
        }

        @Override
        protected FetchOwnerDelegate getFetchOwnerDelegate() {
            return this.delegate;
        }

        @Override
        public PropertyPath getPropertyPath() {
            return this.propertyPath;
        }
    }

    protected static abstract class AbstractIdentifierAttributeCollector
    extends AbstractFetchOwner
    implements FetchOwner,
    EntityReference,
    FetchStackAware {
        protected final EntityReference entityReference;
        protected final Map<Fetch, HydratedCompoundValueHandler> fetchToHydratedStateExtractorMap = new HashMap<Fetch, HydratedCompoundValueHandler>();

        public AbstractIdentifierAttributeCollector(SessionFactoryImplementor sessionFactory, EntityReference entityReference) {
            super(sessionFactory);
            this.entityReference = entityReference;
        }

        @Override
        public LockMode getLockMode() {
            return this.entityReference.getLockMode();
        }

        @Override
        public EntityReference getEntityReference() {
            return this;
        }

        @Override
        public EntityPersister getEntityPersister() {
            return this.entityReference.getEntityPersister();
        }

        @Override
        public IdentifierDescription getIdentifierDescription() {
            return this.entityReference.getIdentifierDescription();
        }

        @Override
        public CollectionFetch buildCollectionFetch(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy, LoadPlanBuildingContext loadPlanBuildingContext) {
            throw new WalkingException("Entity identifier cannot contain persistent collections");
        }

        @Override
        public EntityFetch buildEntityFetch(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy, LoadPlanBuildingContext loadPlanBuildingContext) {
            EntityFetch fetch = super.buildEntityFetch(attributeDefinition, fetchStrategy, loadPlanBuildingContext);
            this.fetchToHydratedStateExtractorMap.put(fetch, attributeDefinition.getHydratedCompoundValueExtractor());
            return fetch;
        }

        @Override
        public Type getType(Fetch fetch) {
            return this.getFetchOwnerDelegate().locateFetchMetadata(fetch).getType();
        }

        @Override
        public boolean isNullable(Fetch fetch) {
            return this.getFetchOwnerDelegate().locateFetchMetadata(fetch).isNullable();
        }

        @Override
        public String[] toSqlSelectFragments(Fetch fetch, String alias) {
            return this.getFetchOwnerDelegate().locateFetchMetadata(fetch).toSqlSelectFragments(alias);
        }

        @Override
        public void poppedFromStack() {
            IdentifierDescription identifierDescription = this.buildIdentifierDescription();
            this.entityReference.injectIdentifierDescription(identifierDescription);
        }

        protected abstract IdentifierDescription buildIdentifierDescription();

        @Override
        public void validateFetchPlan(FetchStrategy fetchStrategy) {
            ((FetchOwner)((Object)this.entityReference)).validateFetchPlan(fetchStrategy);
        }

        @Override
        public EntityPersister retrieveFetchSourcePersister() {
            return ((FetchOwner)((Object)this.entityReference)).retrieveFetchSourcePersister();
        }

        @Override
        public void injectIdentifierDescription(IdentifierDescription identifierDescription) {
            throw new WalkingException("IdentifierDescription collector should not get injected with IdentifierDescription");
        }
    }

    public static interface FetchStackAware {
        public void poppedFromStack();
    }
}

