/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.marshalling;

import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;

public class SimpleClassTable
implements ClassTable {
    private final Class<?>[] classes;
    private final Map<Class<?>, ClassTable.Writer> writers = new IdentityHashMap();

    public SimpleClassTable(Class<?> ... classes) {
        this.classes = classes;
        for (int i = 0; i < classes.length; ++i) {
            this.writers.put(classes[i], new ByteWriter((byte)i));
        }
    }

    public ClassTable.Writer getClassWriter(Class<?> clazz) throws IOException {
        return this.writers.get(clazz);
    }

    public Class<?> readClass(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        return this.classes[unmarshaller.readUnsignedByte()];
    }

    private static final class ByteWriter
    implements ClassTable.Writer {
        final byte[] bytes;

        ByteWriter(byte ... bytes) {
            this.bytes = bytes;
        }

        public void writeClass(Marshaller marshaller, Class<?> clazz) throws IOException {
            marshaller.write(this.bytes);
        }
    }
}

