/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.clustering.infinispan.subsystem.GlobalComponentRegistryService;
import org.jboss.as.clustering.jgroups.subsystem.ChannelService;
import org.jboss.as.clustering.jgroups.subsystem.ChannelServiceProvider;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.as.clustering.naming.JndiNameFactory;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.Services;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jgroups.Channel;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactoryService;
import org.wildfly.clustering.server.group.ChannelGroupProvider;
import org.wildfly.clustering.server.group.ChannelNodeFactory;
import org.wildfly.clustering.server.group.ChannelNodeFactoryProvider;

public class CommandDispatcherFactoryProvider
implements ChannelServiceProvider {
    private static final Logger logger = Logger.getLogger(ChannelServiceProvider.class);

    public static ServiceName getServiceName(String cluster) {
        return ServiceName.JBOSS.append(new String[]{"clustering", "dispatcher"}).append(new String[]{cluster});
    }

    private static ContextNames.BindInfo createBinding(String cluster) {
        return ContextNames.bindInfoFor((String)JndiNameFactory.createJndiName((String)"java:jboss", (String[])new String[]{"clustering", "dispatcher", cluster}).getAbsoluteName());
    }

    public Collection<ServiceName> getServiceNames(String cluster) {
        return Arrays.asList(CommandDispatcherFactoryProvider.getServiceName(cluster), CommandDispatcherFactoryProvider.createBinding(cluster).getBinderServiceName());
    }

    public Collection<ServiceController<?>> install(ServiceTarget target, String cluster, ModuleIdentifier moduleId) {
        ServiceName name = CommandDispatcherFactoryProvider.getServiceName(cluster);
        ContextNames.BindInfo bindInfo = CommandDispatcherFactoryProvider.createBinding(cluster);
        logger.debugf("Installing %s service, bound to ", (Object)name.getCanonicalName(), (Object)bindInfo.getAbsoluteJndiName());
        CommandDispatcherFactoryConfig config = new CommandDispatcherFactoryConfig(moduleId);
        CommandDispatcherFactoryService service = new CommandDispatcherFactoryService(config);
        ServiceBuilder builder = AsynchronousService.addService((ServiceTarget)target, (ServiceName)name, (Service)service).addDependency(GlobalComponentRegistryService.getServiceName((String)cluster)).addDependency(ChannelGroupProvider.getServiceName(cluster), Group.class, config.getGroupInjector()).addDependency(ChannelNodeFactoryProvider.getServiceName(cluster), ChannelNodeFactory.class, config.getNodeFactoryInjector()).addDependency(ChannelService.getServiceName((String)cluster), Channel.class, config.getChannelInjector()).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, config.getModuleLoaderInjector()).setInitialMode(ServiceController.Mode.ON_DEMAND);
        BinderService binder = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = target.addService(bindInfo.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{bindInfo.getBindName()})}).addDependency(name, CommandDispatcherFactory.class, (Injector)new ManagedReferenceInjector(binder.getManagedObjectInjector())).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binder.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.PASSIVE);
        return Arrays.asList(builder.install(), binderBuilder.install());
    }

    private static class CommandDispatcherFactoryConfig
    implements CommandDispatcherFactoryConfiguration {
        private final InjectedValue<Channel> channel = new InjectedValue();
        private final InjectedValue<Group> group = new InjectedValue();
        private final InjectedValue<ChannelNodeFactory> factory = new InjectedValue();
        private final InjectedValue<ModuleLoader> loader = new InjectedValue();
        private final ModuleIdentifier identifier;

        CommandDispatcherFactoryConfig(ModuleIdentifier identifier) {
            this.identifier = identifier;
        }

        @Override
        public Channel getChannel() {
            return (Channel)this.channel.getValue();
        }

        @Override
        public Group getGroup() {
            return (Group)this.group.getValue();
        }

        public ChannelNodeFactory getNodeFactory() {
            return (ChannelNodeFactory)this.factory.getValue();
        }

        @Override
        public ModuleLoader getModuleLoader() {
            return (ModuleLoader)this.loader.getValue();
        }

        @Override
        public ModuleIdentifier getModuleIdentifier() {
            return this.identifier;
        }

        Injector<Channel> getChannelInjector() {
            return this.channel;
        }

        Injector<Group> getGroupInjector() {
            return this.group;
        }

        Injector<ChannelNodeFactory> getNodeFactoryInjector() {
            return this.factory;
        }

        Injector<ModuleLoader> getModuleLoaderInjector() {
            return this.loader;
        }
    }
}

