/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.util.Collection;
import java.util.Collections;
import org.jboss.as.clustering.infinispan.subsystem.CacheServiceProvider;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.server.group.CacheNodeFactoryService;
import org.wildfly.clustering.server.group.ChannelNodeFactory;
import org.wildfly.clustering.server.group.ChannelNodeFactoryProvider;

public class CacheNodeFactoryProvider
implements CacheServiceProvider {
    public static ServiceName getServiceName(String containerName, String cacheName) {
        return ServiceName.JBOSS.append(new String[]{"clustering", "nodes", containerName, cacheName});
    }

    public Collection<ServiceName> getServiceNames(String containerName, String cacheName, boolean defaultCache) {
        return Collections.singleton(CacheNodeFactoryProvider.getServiceName(containerName, cacheName));
    }

    public Collection<ServiceController<?>> install(ServiceTarget target, String containerName, String cacheName, boolean defaultCache, ModuleIdentifier moduleId) {
        InjectedValue factory = new InjectedValue();
        ServiceBuilder builder = target.addService(CacheNodeFactoryProvider.getServiceName(containerName, cacheName), (Service)new CacheNodeFactoryService((Value<ChannelNodeFactory>)factory)).addDependency(ChannelNodeFactoryProvider.getServiceName(containerName), ChannelNodeFactory.class, (Injector)factory).setInitialMode(ServiceController.Mode.ON_DEMAND);
        if (defaultCache) {
            builder.addAliases(new ServiceName[]{CacheNodeFactoryProvider.getServiceName(containerName, "default")});
        }
        return Collections.singleton(builder.install());
    }
}

