/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.transaction.LockingMode;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigOperationHandlers;
import org.jboss.as.clustering.infinispan.subsystem.CacheMetricsHandler;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class TransactionResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement TRANSACTION_PATH = PathElement.pathElement((String)"transaction", (String)"TRANSACTION");
    static final SimpleAttributeDefinition LOCKING = new SimpleAttributeDefinitionBuilder("locking", ModelType.STRING, true).setXmlName(Attribute.LOCKING.getLocalName()).setAllowExpression(true).setValidator((ParameterValidator)new EnumValidator(LockingMode.class, true, false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(LockingMode.PESSIMISTIC.name())).build();
    static final SimpleAttributeDefinition MODE = new SimpleAttributeDefinitionBuilder("mode", ModelType.STRING, true).setXmlName(Attribute.MODE.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new EnumValidator(TransactionMode.class, true, true)).setDefaultValue(new ModelNode().set(TransactionMode.NONE.name())).build();
    static final SimpleAttributeDefinition STOP_TIMEOUT = new SimpleAttributeDefinitionBuilder("stop-timeout", ModelType.LONG, true).setXmlName(Attribute.STOP_TIMEOUT.getLocalName()).setMeasurementUnit(MeasurementUnit.MILLISECONDS).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(30000)).build();
    static final AttributeDefinition[] TRANSACTION_ATTRIBUTES = new AttributeDefinition[]{MODE, STOP_TIMEOUT, LOCKING};
    static final SimpleAttributeDefinition COMMITS = new SimpleAttributeDefinitionBuilder("commits", ModelType.LONG, true).setStorageRuntime().build();
    static final SimpleAttributeDefinition PREPARES = new SimpleAttributeDefinitionBuilder("prepares", ModelType.LONG, true).setStorageRuntime().build();
    static final SimpleAttributeDefinition ROLLBACKS = new SimpleAttributeDefinitionBuilder("rollbacks", ModelType.LONG, true).setStorageRuntime().build();
    static final AttributeDefinition[] TRANSACTION_METRICS = new AttributeDefinition[]{COMMITS, PREPARES, ROLLBACKS};

    public TransactionResourceDefinition() {
        super(TRANSACTION_PATH, InfinispanExtension.getResourceDescriptionResolver("transaction"), CacheConfigOperationHandlers.TRANSACTION_ADD, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(TRANSACTION_ATTRIBUTES);
        for (AttributeDefinition attr : TRANSACTION_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)writeHandler);
        }
        for (AttributeDefinition attr : TRANSACTION_METRICS) {
            resourceRegistration.registerMetric(attr, (OperationStepHandler)CacheMetricsHandler.INSTANCE);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
    }
}

