/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import org.jboss.logging.Cause;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.Messages;
import org.jboss.logging.Param;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.OperationNotSupportedException;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.encoder.PasswordEncoder;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.spi.IdentityStore;

@MessageBundle(projectCode="PLIDM")
public interface IDMMessages {
    public static final IDMMessages MESSAGES = (IDMMessages)Messages.getBundle(IDMMessages.class);

    @Message(id=1, value="Error creating instance for type [%s].")
    public IdentityManagementException instantiationError(Class<?> var1, @Cause Throwable var2);

    @Message(id=2, value="Null argument: [%s].")
    public IdentityManagementException nullArgument(String var1);

    @Message(id=3, value="Error unmarshalling object.")
    public IdentityManagementException unmarshallingError(@Cause Throwable var1);

    @Message(id=4, value="Error marshalling object.")
    public IdentityManagementException marshallingError(@Cause Throwable var1);

    @Message(id=200, value="Credentials class [%s] not supported by this handler [%s].")
    public IdentityManagementException credentialUnsupportedType(Class<?> var1, CredentialHandler var2);

    @Message(id=201, value="Invalid Realm or it was not provided.")
    public IdentityManagementException credentialDigestInvalidRealm();

    @Message(id=202, value="Invalid Password or it was not provided.")
    public IdentityManagementException credentialInvalidPassword();

    @Message(id=203, value="Could not encode password.")
    public IdentityManagementException credentialCouldNotEncodePassword(@Cause UnsupportedEncodingException var1);

    @Message(id=204, value="No suitable CredentialHandler available for validating Credentials of type [%s].")
    public IdentityManagementException credentialHandlerNotFoundForCredentialType(Class<?> var1);

    @Message(id=205, value="No such algorithm [%s] for encoding passwords. Using PasswordEncoder [%s].")
    public IdentityManagementException credentialInvalidEncodingAlgorithm(String var1, PasswordEncoder var2, @Cause Throwable var3);

    @Message(id=206, value="No IdentityStore found for credential class [%s]")
    public IdentityManagementException credentialNoStoreForCredentials(Class<?> var1);

    @Message(id=300, value="Could not create context.")
    public IdentityManagementException storeLdapCouldNotCreateContext(@Cause Throwable var1);

    @Message(id=301, value="Error while trying to determine EntityManager - context parameter not set.")
    public IdentityManagementException storeJpaCouldNotGetEntityManagerFromStoreContext();

    @Message(id=302, value="Unexpected IdentityStore type. Expected [%s]. Actual [%s].")
    public IdentityManagementException storeUnexpectedType(Class<? extends IdentityStore> var1, Class<? extends IdentityStore> var2);

    @Message(id=303, value="No store found with type [%s].")
    public IdentityManagementException storeNotFound(Class<? extends IdentityStore> var1);

    @Message(id=400, value="Could not create contextual IdentityManager for Partition [%s]. Partition not found or it was null.")
    public IdentityManagementException partitionCouldNotCreateIdentityManager(Partition var1);

    @Message(id=401, value="A Partition [%s] with name [%s] already exists.")
    public IdentityManagementException partitionAlreadyExistsWithName(Class<? extends Partition> var1, String var2);

    @Message(id=402, value="Partition [%s] not found with the given name [%s].")
    public IdentityManagementException partitionNotFoundWithName(Class<? extends Partition> var1, String var2);

    @Message(id=403, value="No configuration found with the given name [%s].")
    public IdentityManagementException partitionNoConfigurationFound(String var1);

    @Message(id=404, value="Partition [%s] references an invalid or non-existent configuration.")
    public IdentityManagementException partitionReferencesInvalidConfiguration(Partition var1);

    @Message(id=405, value="Could not load partition for type [%s] and identifier [%s].")
    public IdentityManagementException partitionGetFailed(Class<? extends Partition> var1, String var2, @Cause Exception var3);

    @Message(id=406, value="Could not create partition [%s] using configuration [%s].")
    public IdentityManagementException partitionAddFailed(Partition var1, String var2, @Cause Exception var3);

    @Message(id=407, value="Could not update partition [%s].")
    public IdentityManagementException partitionUpdateFailed(Partition var1, @Cause Exception var2);

    @Message(id=408, value="Could not remove partition [%s].")
    public IdentityManagementException partitionRemoveFailed(Partition var1, @Cause Exception var2);

    @Message(id=409, value="Partition management is not supported by the current configuration.")
    public OperationNotSupportedException partitionManagementNoSupported(@Param Class<Partition> var1, @Param IdentityStoreConfiguration.IdentityOperation var2);

    @Message(id=500, value="Could not query Relationship using query [%s].")
    public IdentityManagementException queryRelationshipFailed(RelationshipQuery<?> var1, @Cause Throwable var2);

    @Message(id=501, value="Could not query IdentityType using query [%s].")
    public IdentityManagementException queryIdentityTypeFailed(IdentityQuery<?> var1, @Cause Throwable var2);

    @Message(id=502, value="Unsupported value for Query Parameter [%s]. Value: %s.")
    public IdentityManagementException queryUnsupportedParameterValue(String var1, Object var2);

    @Message(id=600, value="IdentityType [%s] already exists with the given identifier [%s] for the given Partition [%s].")
    public IdentityManagementException identityTypeAlreadyExists(Class<? extends IdentityType> var1, String var2, Partition var3);

    @Message(id=601, value="Ambiguous AttributedType found with identifier [%s].")
    public IdentityManagementException attributedTypeAmbiguosFoundWithId(String var1);

    @Message(id=602, value="Could not add AttributedType [%s].")
    public IdentityManagementException attributedTypeAddFailed(AttributedType var1, @Cause Throwable var2);

    @Message(id=603, value="Could not remove AttributedType [%s].")
    public IdentityManagementException attributedTypeRemoveFailed(AttributedType var1, @Cause Throwable var2);

    @Message(id=604, value="Could not update AttributedType [%s].")
    public IdentityManagementException attributedTypeUpdateFailed(AttributedType var1, @Cause Throwable var2);

    @Message(id=605, value="Could not find AttributedType [%s] with the given identifier [%s] for Partition [%s]")
    public IdentityManagementException attributedTypeNotFoundWithId(Class<? extends AttributedType> var1, String var2, Partition var3);

    @Message(id=606, value="No identity store configuration found for requested type operation [%s.%s].")
    public OperationNotSupportedException attributedTypeUnsupportedOperation(@Param Class<? extends AttributedType> var1, @Param IdentityStoreConfiguration.IdentityOperation var2, Class<? extends AttributedType> var3, IdentityStoreConfiguration.IdentityOperation var4);

    @Message(id=701, value="Error initializing JpaIdentityStore - no entity classes configured.")
    public SecurityConfigurationException configJpaStoreNoEntityClassesProvided();

    @Message(id=702, value="Entity [%s] must have a field annotated with %s.")
    public SecurityConfigurationException configJpaStoreRequiredMappingAnnotation(Class<?> var1, Class<? extends Annotation> var2);

    @Message(id=703, value="Mapped attribute [%s.%s] does not map to any field for type [%s].")
    public SecurityConfigurationException configJpaStoreMappedPropertyNotFound(Class<?> var1, String var2, Class<?> var3);

    @Message(id=704, value="At least one IdentityConfiguration must be provided")
    public SecurityConfigurationException configNoIdentityConfigurationProvided();

    @Message(id=705, value="Unknown IdentityStore class for configuration [%s].")
    public SecurityConfigurationException configUnknownStoreForConfiguration(IdentityStoreConfiguration var1);

    @Message(id=706, value="Error while creating IdentityStore [%s] instance for configuration [%s].")
    public SecurityConfigurationException configCouldNotCreateStore(Class<? extends IdentityStore> var1, IdentityStoreConfiguration var2, @Cause Exception var3);

    @Message(id=707, value="You have provided more than one configuration. Use the buildAll method instead.")
    public SecurityConfigurationException configBuildMultipleConfigurationExists();

    @Message(id=708, value="Only a single identity store config can support partitions. Found [%s] and [%s].")
    public SecurityConfigurationException configStoreMultiplePartitionConfigExists(IdentityStoreConfiguration var1, IdentityStoreConfiguration var2);

    @Message(id=709, value="Duplicated supported types found for identity store configuration [%s].")
    public SecurityConfigurationException configStoreDuplicatedSupportedType(IdentityStoreConfiguration var1);

    @Message(id=710, value="You must configure at least one identity store configuration.")
    public SecurityConfigurationException configStoreNoIdentityStoreConfigProvided();

    @Message(id=711, value="You must provide at least one configuration.")
    public SecurityConfigurationException configNoConfigurationProvided();

    @Message(id=712, value="Multiple configuration with the same name [%s].")
    public SecurityConfigurationException configMultipleConfigurationsFoundWithSameName(String var1);

    @Message(id=713, value="Could not create configuration.")
    public SecurityConfigurationException configCouldNotCreateConfiguration(@Cause Exception var1);

    @Message(id=714, value="Invalid configuration [%s].")
    public SecurityConfigurationException configInvalidConfiguration(String var1);
}

