/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch;

import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.threads.ThreadFactoryResolver;
import org.jboss.as.threads.ThreadFactoryResourceDefinition;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.UnboundedQueueThreadPoolResourceDefinition;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.batch.BatchSubsystemAdd;
import org.wildfly.extension.batch.BatchSubsystemExtension;
import org.wildfly.extension.batch.JobRepositoryDefinition;
import org.wildfly.extension.batch.services.BatchServiceNames;

public class BatchSubsystemDefinition
extends SimpleResourceDefinition {
    public static final String NAME = "batch";
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"batch");
    private static final String RESOURCE_NAME = BatchSubsystemExtension.class.getPackage().getName() + ".LocalDescriptions";
    public static final BatchSubsystemDefinition INSTANCE = new BatchSubsystemDefinition();

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        String prefix = NAME + (keyPrefix == null ? "" : "." + keyPrefix);
        return new StandardResourceDescriptionResolver(prefix, RESOURCE_NAME, BatchSubsystemExtension.class.getClassLoader(), true, false);
    }

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... prefixes) {
        StringBuilder prefix = new StringBuilder(NAME);
        for (String p : prefixes) {
            prefix.append('.').append(p);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, BatchSubsystemExtension.class.getClassLoader(), true, false);
    }

    private BatchSubsystemDefinition() {
        super(SUBSYSTEM_PATH, (ResourceDescriptionResolver)BatchSubsystemDefinition.getResourceDescriptionResolver((String)null), (OperationStepHandler)BatchSubsystemAdd.INSTANCE, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        UnboundedQueueThreadPoolResourceDefinition threadPoolResource = UnboundedQueueThreadPoolResourceDefinition.create((PathElement)PathElement.pathElement((String)"thread-pool", (String)NAME), (ThreadFactoryResolver)BatchThreadFactoryResolver.INSTANCE, (ServiceName)BatchServiceNames.BASE_BATCH_THREAD_POOL_NAME, (boolean)false);
        resourceRegistration.registerSubModel((ResourceDefinition)threadPoolResource);
        ThreadFactoryResourceDefinition threadFactoryResource = new ThreadFactoryResourceDefinition();
        resourceRegistration.registerSubModel((ResourceDefinition)threadFactoryResource);
        resourceRegistration.registerSubModel((ResourceDefinition)JobRepositoryDefinition.IN_MEMORY);
    }

    private static class BatchThreadFactoryResolver
    extends ThreadFactoryResolver.SimpleResolver {
        static final BatchThreadFactoryResolver INSTANCE = new BatchThreadFactoryResolver();

        private BatchThreadFactoryResolver() {
            super(ThreadsServices.FACTORY);
        }

        protected String getThreadGroupName(String threadPoolName) {
            return "batch-" + threadPoolName;
        }
    }
}

